dnl bttvgrab macro definitions
dnl bttvgrab 0.15.0 [1999-01-18]  
dnl   (c) 1998, 1999 by Joerg Walter <trouble@moes.pmnet.uni-oldenburg.de>
dnl   Maintained by: Joerg Walter
dnl   Current version at http://moes.pmnet.uni-oldenburg.de/bttvgrab/
dnl
dnl    This program is free software; you can redistribute it and/or modify
dnl    it under the terms of the GNU General Public License as published by
dnl    the Free Software Foundation; either version 2 of the License, or
dnl    (at your option) any later version.
dnl
dnl    This program is distributed in the hope that it will be useful,
dnl    but WITHOUT ANY WARRANTY; without even the implied warranty of
dnl    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
dnl    GNU General Public License for more details.
dnl
dnl    You should have received a copy of the GNU General Public License
dnl    along with this program; if not, write to the Free Software
dnl    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

AC_DEFUN(AC_SUMMARY,
[
tput clear
echo "Configuration summary:"
echo "----------------------"
echo ""
echo "Required:"
echo "Found gif_lib.h in: $GIFLIBDIR"
echo "Found jpeglib.h in: $JPEGLIBDIR"
echo "Found ncurses.h in: $NCURSESDIR"
echo ""
echo "Optional:"
echo    "Found bttv driver:   $BTTVDIR"
echo -n "Found X:             "
if test "$have_x" != "yes"; then
	echo "no"
else
	echo "$x_includes, $x_libraries"
fi
echo -n "Found Qt:            "
if test "$have_qt" != "yes"; then
	echo "no"
else
	echo "$qt_includes, $qt_libraries"
fi
echo -n "Found KDE:           "
if test "$have_kde" != "yes"; then
	echo "no"
else
	echo "$kde_includes, $kde_libraries"
fi
echo -n "kgrab will be built: "
if test "$kde_prefix" != "NONE"; then
	echo "yes"
else
	echo -n "no"
	if test "$have_kde" = "yes" && test "$have_qt" = "yes" && test "$have_x" = "yes"; then
		echo ", disabled"
	else
		if test "$have_kde" != "yes"; then
			echo -n ", KDE missing"
		fi
		if test "$have_qt" != "yes"; then
			echo -n ", Qt missing"
		fi
		if test "$have_x" != "yes"; then
			echo -n ", X missing"
		fi
		echo ""
	fi
fi
echo ""
])

AC_DEFUN(AC_DO_KGRAB,
[

AC_MSG_CHECKING([for kgrab])
 ac_kgrab_enabled=set
AC_ARG_ENABLE(kgrab,
    [  --disable-kgrab         don't build kgrab, even if KDE is present],
    [  ac_kgrab_enabled=$enableval ])
if test "$ac_kgrab_enabled" = "set"  && test $ac_kde_prefix != "NONE"; then
  AC_MSG_RESULT(build)
else
  AC_MSG_RESULT(don't build)
  ac_kde_prefix=NONE
fi
kde_prefix="$ac_kde_prefix"
])


AC_DEFUN(AC_HEADER_BTTV, [
AC_MSG_CHECKING(for bttv header files)
AC_TRY_CPP(#include "../bttv/driver/bttv.h"
, [BTTVDIR="`pwd`/../bttv/driver"], [
AC_TRY_CPP(#include "~/bttv/driver/bttv.h"
, [BTTVDIR='~/bttv/driver'], [
AC_TRY_CPP(#include "~/src/bttv/driver/bttv.h"
, [BTTVDIR='~/src/bttv/driver'], [
AC_TRY_CPP(#include "/usr/src/bttv/driver/bttv.h"
, [BTTVDIR='/usr/src/bttv/driver'], [
AC_TRY_CPP(#include "/usr/local/src/bttv/driver/bttv.h"
, [BTTVDIR='/usr/local/src/bttv/driver'], [
BTTVDIR='no'
])])])])])
AC_SUBST(BTTVDIR)
AC_MSG_RESULT($BTTVDIR)
])

AC_DEFUN(AC_HEADER_V4L, [
AC_MSG_CHECKING(for video4linux header files)
AC_TRY_CPP(#include <linux/videodev.h>
, [ AC_MSG_RESULT(yes) ], [
AC_MSG_ERROR('video4linux headers not found - please copy videodev.h from your bttv driver to /usr/include/linux (2.1 and 2.2 kernels keep it there)')])
])


AC_DEFUN(AC_HEADER_NCURSES, [
AC_MSG_CHECKING(for curses header file)
AC_TRY_CPP(#include <curses.h>
, [NCURSESDIR='system include path'], [
AC_TRY_CPP(#include "/usr/include/ncurses/curses.h"
, [NCURSESDIR='/usr/include/ncurses'], [
AC_TRY_CPP(#include "/usr/local/include/ncurses/curses.h"
, [NCURSESDIR='/usr/local/include/ncurses'], [
AC_TRY_CPP(#include "/usr/local/kde/include/curses.h"
, [NCURSESDIR='/usr/local/kde/include'], [
AC_TRY_CPP(#include "/opt/kde/include/curses.h"
, [NCURSESDIR='/opt/kde/include'], [
AC_MSG_ERROR('ncurses headers not found - please add the path to then to your C_INCLUDE_PATH')])
])])])])
AC_SUBST(NCURSESDIR)
AC_MSG_RESULT($NCURSESDIR)
])

AC_DEFUN(AC_HEADER_GIFLIB, [
AC_MSG_CHECKING(for giflib header file)
AC_TRY_CPP(#include <gif_lib.h>
, [GIFLIBDIR='system include path'], [
AC_TRY_CPP(#include "/usr/include/gr/gif_lib.h"
, [GIFLIBDIR='/usr/include/gr'], [
AC_TRY_CPP(#include "/usr/local/include/gr/gif_lib.h"
, [GIFLIBDIR='/usr/local/include/gr'], [
AC_TRY_CPP(#include "/usr/local/kde/include/gif_lib.h"
, [GIFLIBDIR='/usr/local/kde/include'], [
AC_TRY_CPP(#include "/usr/X11/include/gif_lib.h"
, [GIFLIBDIR='/usr/X11/include'], [
AC_TRY_CPP(#include "/opt/kde/include/gif_lib.h"
, [GIFLIBDIR='/opt/kde/include'], [
AC_MSG_ERROR('giflib headers not found - please add the path to then to your C_INCLUDE_PATH')])
])])])])])
AC_SUBST(GIFLIBDIR)
AC_MSG_RESULT($GIFLIBDIR)
])

AC_DEFUN(AC_HEADER_JPEGLIB, [
AC_MSG_CHECKING(for jpeglib header file)
AC_TRY_CPP(#include <jpeglib.h>
, [JPEGLIBDIR='system include path'], [
AC_TRY_CPP(#include "/usr/include/gr/jpeglib.h"
, [JPEGLIBDIR='/usr/include/gr'], [
AC_TRY_CPP(#include "/usr/local/include/gr/jpeglib.h"
, [JPEGLIBDIR='/usr/local/include/gr'], [
AC_TRY_CPP(#include "/usr/local/kde/include/jpeglib.h"
, [JPEGLIBDIR='/usr/local/kde/include'], [
AC_TRY_CPP(#include "/usr/X11/include/jpeglib.h"
, [GIFLIBDIR='/usr/X11/include'], [
AC_TRY_CPP(#include "/opt/kde/include/jpeglib.h"
, [JPEGLIBDIR='/opt/kde/include'], [
AC_MSG_ERROR('jpeglib headers not found - please add the path to then to your C_INCLUDE_PATH')])
])])])])])
AC_SUBST(JPEGLIBDIR)
AC_MSG_RESULT($JPEGLIBDIR)
])

AC_DEFUN(AC_LIB_GIFLIB, [
AC_CHECK_LIB(gif, EGifOpenFileName,,[
AC_CHECK_LIB(gif, DGifOpenFileName,LIBS="$LIBS -lgif -lX11",[
AC_MSG_ERROR('giflib not found - please add the path to giflib to your LIBRARY_PATH')
],-lX11 -L$x_libraries/.)])])

AC_DEFUN(AC_LIB_JPEG, [
AC_CHECK_LIB(jpeg, jpeg_set_defaults,,[
AC_MSG_ERROR('jpeglib not found - please add the path to jpeglib to your LIBRARY_PATH')])
])

AC_DEFUN(AC_FIND_FILE,
[
$3=NO
for i in $2;
do
  for j in $1;
  do
    if test -r "$i/$j"; then
      $3=$i
      break 2
    fi
  done
done
])

AC_DEFUN(AC_PATH_QT_DIRECT,
[if test "$ac_qt_includes" = NO; then
AC_TRY_CPP([#include <qtstream.h>],
[
ac_qt_includes=
],[
])
fi
])

AC_DEFUN(AC_PATH_QT_MOC,
[
AC_PATH_PROG(MOC, moc, /usr/bin/moc,
 $PATH:/usr/bin:/usr/X11R6/bin:$QTDIR/bin:/usr/lib/qt/bin:/usr/local/qt/bin)
])


AC_DEFUN(AC_CREATE_KFSSTND,
[

kde_htmldir="\$(kde_prefix)/share/doc/HTML"
AC_SUBST(kde_htmldir)
kde_appsdir="\$(kde_prefix)/share/applnk"
AC_SUBST(kde_appsdir)
kde_icondir="\$(kde_prefix)/share/icons"
AC_SUBST(kde_icondir)
kde_minidir="\$(kde_prefix)/share/icons/mini"
AC_SUBST(kde_minidir)
kde_datadir="\$(kde_prefix)/share/apps"
AC_SUBST(kde_datadir)
kde_locale="\$(kde_prefix)/share/locale"
AC_SUBST(kde_locale)
kde_cgidir="\$(kde_prefix)/cgi-bin"
AC_SUBST(kde_cgidir)
kde_confdir="\$(kde_prefix)/share/config"
AC_SUBST(kde_confdir)
kde_mimedir="\$(kde_prefix)/share/mimelnk"
AC_SUBST(kde_mimedir)
kde_toolbardir="\$(kde_prefix)/share/toolbar"
AC_SUBST(kde_toolbardir)
kde_wallpaperdir="\$(kde_prefix)/share/wallpaper"
AC_SUBST(kde_wallpaperdir)

])

AC_DEFUN(K_PATH_X,
[
AC_MSG_CHECKING(for X)
AC_CACHE_VAL(ac_cv_have_x,
[# One or both of the vars are not set, and there is no cached value.
ac_x_includes=NO ac_x_libraries=NO
AC_PATH_X_DIRECT
AC_PATH_X_XMKMF
if test "$ac_x_includes" = NO || test "$ac_x_libraries" = NO; then
dnl  AC_MSG_ERROR([Can't find X. Please add the correct paths. View configure --help for usage!])
  ac_cv_have_x="have_x=no"
else
  # Record where we found X for the cache.
  ac_cv_have_x="have_x=yes \
                ac_x_includes=$ac_x_includes ac_x_libraries=$ac_x_libraries"
fi])dnl
eval "$ac_cv_have_x"
 
if test "$have_x" != yes; then
  AC_MSG_RESULT($have_x)
  no_x=yes
else
  # If each of the values was on the command line, it overrides each guess.
  test "x$x_includes" = xNONE && x_includes=$ac_x_includes
  test "x$x_libraries" = xNONE && x_libraries=$ac_x_libraries
  # Update the cache value to reflect the command line values.
  ac_cv_have_x="have_x=yes \
                ac_x_includes=$x_includes ac_x_libraries=$x_libraries"
  AC_MSG_RESULT([libraries $x_libraries, headers $x_includes])
fi

if test -z "$x_includes" || test "x$x_includes" = xNONE; then
  X_INCLUDES=""
  x_includes="."; dnl better than nothing :-
 else
  X_INCLUDES="-I$x_includes"
fi

if test -z "$x_libraries" || test "$x_libraries" = xNONE; then
  X_LDFLAGS=""
  x_libraries="/usr/lib"; dnl better than nothing :-
  all_libraries=""
 else
  X_LDFLAGS="-L$x_libraries"
  all_libraries=$X_LDFLAGS
fi

AC_SUBST(X_INCLUDES)
AC_SUBST(X_LDFLAGS)
all_includes=$X_INCLUDES
])
AC_DEFUN(AC_PATH_QT_1_3,
[
AC_REQUIRE([K_PATH_X])

AC_MSG_CHECKING([for QT])
ac_qt_includes=NO ac_qt_libraries=NO
qt_libraries=""
qt_includes=""
AC_ARG_WITH(qt-dir,
    [  --with-qt-dir           where the root of qt is installed ],
    [  ac_qt_includes="$withval"/include
       ac_qt_libraries="$withval"/lib
    ])

AC_ARG_WITH(qt-includes,
    [  --with-qt-includes      where the qt includes are. ],
    [  
       ac_qt_includes="$withval"
    ])
    
AC_ARG_WITH(qt-libraries,
    [  --with-qt-libraries     where the qt library is installed.],
    [  ac_qt_libraries="$withval"
    ])

if test "$ac_qt_includes" = NO || test "$ac_qt_libraries" = NO; then

AC_CACHE_VAL(ac_cv_have_qt,
AC_PATH_QT_DIRECT
[#try to guess qt locations

qt_incdirs="/usr/lib/qt/include /usr/local/qt/include /usr/include/qt /usr/include /usr/X11R6/include/X11/qt $x_includes $QTINC"
test -n "$QTDIR" && qt_incdirs="$QTDIR/include $QTDIR $qt_incdirs"
AC_FIND_FILE(qmovie.h, $qt_incdirs, qt_incdir)
ac_qt_includes=$qt_incdir

qt_libdirs="/usr/lib/qt/lib /usr/local/qt/lib /usr/lib/qt /usr/lib $x_libraries $QTLIB"
test -n "$QTDIR" && qt_libdirs="$QTDIR/lib $QTDIR $qt_libdirs"
AC_FIND_FILE(libqt.so libqt.so.1.30 libqt.so.1 libqt.a libqt.sl, $qt_libdirs, qt_libdir)
ac_qt_libraries=$qt_libdir

ac_cxxflags_safe=$CXXFLAGS
ac_ldflags_safe=$LDFLAGS
ac_libs_safe=$LIBS
CXXFLAGS="$CXXFLAGS -I$qt_incdir"
LDFLAGS="-L$qt_libdir $X_LDFLAGS"
LIBS="-lqt -lXext -lX11 $LIBSOCKET"

AC_LANG_CPLUSPLUS
cat > conftest.$ac_ext <<EOF
#include "confdefs.h"
#include <qmovie.h>
int main() {
  QMovie m;
  m.setSpeed(20);
  return 0;
};
EOF

if AC_TRY_EVAL(ac_link) && test -s conftest; then
  rm -f conftest*
else
  echo "configure: failed program was:" >&AC_FD_CC
  cat conftest.$ac_ext >&AC_FD_CC
  ac_qt_libraries="NO"
fi
rm -f conftest*
CXXFLAGS=$ac_cxxflags_safe
LDFLAGS=$ac_ldflags_safe
LIBS=$ac_libs_safe

if test "$ac_qt_includes" = NO || test "$ac_qt_libraries" = NO; then
  ac_cv_have_qt="have_qt=no"
  ac_qt_notfound=""
  if test "$ac_qt_includes" = NO; then
    if test "$ac_qt_libraries" = NO; then
      ac_qt_notfound="(headers and libraries)";
    else
      ac_qt_notfound="(headers)";
    fi
  else
    ac_qt_notfound="(libraries)";
  fi

dnl  AC_MSG_ERROR([QT $ac_qt_notfound not found. Please check your installation! ]);
  have_qt="no"
else
  have_qt="yes"
fi
])
else
  have_qt="yes"
fi

eval "$ac_cv_have_qt"

if test "$have_qt" != yes; then
  AC_MSG_RESULT([$have_qt]);
else
  ac_cv_have_qt="have_qt=yes \
    ac_qt_includes=$ac_qt_includes ac_qt_libraries=$ac_qt_libraries"
  AC_MSG_RESULT([libraries $ac_qt_libraries, headers $ac_qt_includes])
  
  qt_libraries=$ac_qt_libraries
  qt_includes=$ac_qt_includes
fi
AC_SUBST(qt_libraries)
AC_SUBST(qt_includes)

if test "$qt_includes" = "$x_includes"; then
 QT_INCLUDES="";
else
 QT_INCLUDES="-I$qt_includes"
 all_includes="$QT_INCLUDES $all_includes"
fi

if test "$qt_libraries" = "$x_libraries"; then
 QT_LDFLAGS=""
else
 QT_LDFLAGS="-L$qt_libraries"
 all_libraries="$QT_LDFLAGS $all_libraries"
fi

AC_SUBST(QT_INCLUDES)
AC_SUBST(QT_LDFLAGS)
AC_PATH_QT_MOC
])

AC_DEFUN(AC_PATH_QT,
[
AC_PATH_QT_1_3
])

AC_DEFUN(AC_PATH_KDE,
[
AC_REQUIRE([AC_PATH_QT])dnl
AC_MSG_CHECKING([for KDE])
ac_kde_includes=NO ac_kde_libraries=NO
kde_libraries=""
kde_includes=""
AC_CACHE_VAL(ac_cv_have_kde,
[#try to guess kde locations

kde_incdirs="/usr/lib/kde/include /usr/local/kde/include /usr/kde/include /usr/include/kde /usr/include $x_includes $qt_includes"

test -n "$KDEDIR" && kde_incdirs="$KDEDIR/include $KDEDIR $kde_incdirs"
AC_FIND_FILE(ksock.h, $kde_incdirs, kde_incdir)
ac_kde_includes=$kde_incdir

kde_libdirs="/usr/lib/kde/lib /usr/local/kde/lib /usr/kde/lib /usr/lib/kde /usr/lib /usr/X11R6/lib /usr/X11R6/kde/lib"
test -n "$KDEDIR" && kde_libdirs="$KDEDIR/lib $KDEDIR $kde_libdirs"
AC_FIND_FILE(libkdecore.la, $kde_libdirs, kde_libdir)
ac_kde_libraries=$kde_libdir

if test "$ac_kde_includes" = NO || test "$ac_kde_libraries" = NO || test "$have_x" != yes || test "$have_qt" != yes; then
  ac_cv_have_kde="have_kde=no"
else
  ac_cv_have_kde="have_kde=yes \
    ac_kde_includes=$ac_kde_includes ac_kde_libraries=$ac_kde_libraries"
fi])dnl

eval "$ac_cv_have_kde"

if test "$have_kde" != yes; then
 ac_kde_prefix=NONE
 AC_MSG_RESULT(["no"])

 kde_libraries=
 kde_includes=

else
  ac_cv_have_kde="have_kde=yes \
    ac_kde_includes=$ac_kde_includes ac_kde_libraries=$ac_kde_libraries"
  AC_MSG_RESULT([libraries $ac_kde_libraries, headers $ac_kde_includes])

  ac_kde_prefix=$ac_kde_libraries/..
  kde_libraries=$ac_kde_libraries
  kde_includes=$ac_kde_includes
fi

kde_prefix=$ac_kde_prefix
AC_SUBST(kde_prefix)
AC_SUBST(kde_libraries)
AC_SUBST(kde_includes)

if test "$kde_includes" = "$x_includes" || test "$kde_includes" = "$qt_includes" ; then
 KDE_INCLUDES=""
else
 KDE_INCLUDES="-I$kde_includes"
 all_includes="$KDE_INCLUDES $all_includes"
fi

if test "$kde_libraries" = "$x_libraries" || test "$kde_libraries" = "$qt_libraries" ; then
 KDE_LDFLAGS=""
else
 KDE_LDFLAGS="-L$kde_libraries"
 all_libraries="$KDE_LDFLAGS $all_libraries"
fi

AC_SUBST(KDE_LDFLAGS)
AC_SUBST(KDE_INCLUDES)
AC_SUBST(all_includes)
AC_SUBST(all_libraries)
AC_CREATE_KFSSTND
])
