#!/usr/local/bin/wish
set pipeafter ""
set cmd(w) 640
set old(w) cmd(w)
set cmd(q) 50
set cmd(s) "1"
set cmd(x) "0"
set old(x) $cmd(x)
set tmp(s) "0"
set old(s) ""
set cmd(l) "250"
set tmp(l) "0"
set old(l) ""
set cmd(D) "/dev/dsp"
set cmd(F) "grab.wav"
set tmp(t) "0"
set tmp(y) "0"
set cmd(Q) "1"
set cmd(B) "16"
set cmd(C) "2"
set cmd(f) "output.pmm"
set cmd(g) "grab.log"
set cmd(R) "44100"
set cmd(d) "output.mpg"
set tmp(d) ""
set tmp(M) "0"
set tmp(r) "0"
set cmd(br) "1152"
set cmd(BR) "128"
set old(br) $cmd(br)
set old(BR) $cmd(BR)
set cmd(m) "mpeg-1"
set pipe ""
set pal "0"

proc testSound {} {
    global tmp cmd
    if {$cmd(Q)} {
	pack .options.sound.d -fill both -expand 1
    } {
	pack forget .options.sound.d
    }
}

proc testGrab {} {
    global tmp cmd
    if {$tmp(g)} {enableFile .options.g.g} {disableFile .options.g.g}
}

proc rangeSleep {} {
    global tmp cmd old
    set cmd(s) [string trimleft $cmd(s) "0"]
    if {[string trim $cmd(s) "0123456789"] != ""} {set cmd(s) $old(s)}
    if {$cmd(s) > 9999} {set cmd(s) $old(s)}
    set old(s) $cmd(s)
}

proc testSleep {} {
    global tmp cmd
    if {$tmp(s)} {
	enableEntry .options.g.w.h.s.entry
    } {
	disableEntry .options.g.w.h.s.entry
    }
}

proc rangeLimit {} {
    global tmp cmd old
    set cmd(l) [string trimleft $cmd(l) "0"]
    if {[string trim $cmd(l) "0123456789"] != ""} {set cmd(l) $old(l)}
    if {$cmd(l) > 999999} {set cmd(l) $old(l)}
    set old(l) $cmd(l)
}

proc rangeStart {} {
    global tmp cmd old
    if {[string length $cmd(x)] != 0} {
	if {$cmd(x) == "0"} {
	    set cmd(x) "0"
	} {
	    set cmd(x) [string trimleft $cmd(x) "0"]
	}
    }
    if {[string trim $cmd(x) "0123456789"] != ""} {set cmd(x) $old(x)}
    if {$cmd(x) > 999999} {set cmd(x) $old(x)}
    set old(x) $cmd(x)
}

proc testMPEG {} {
    global tmp cmd old
    if {$tmp(M)} {
	pack .options.conv.c -expand 1 -fill both
    } {
	pack forget .options.conv.c
    }

}

proc rangeAudio {} {
    global tmp cmd old
    set cmd(BR) [string trimleft $cmd(BR) "0"]
    if {[string trim $cmd(BR) "0123456789"] != ""} {set cmd(BR) $old(BR)}
    if {$cmd(BR) > 384} {set cmd(BR) $old(BR)}
    set old(BR) $cmd(BR)
}

proc rangeVideo {} {
    global tmp cmd old
    set cmd(br) [string trimleft $cmd(br) "0"]
    if {[string trim $cmd(br) "0123456789"] != ""} {set cmd(br) $old(br)}
    if {$cmd(br) > 9999} {set cmd(br) $old(br)}
    set old(br) $cmd(br)
}

proc testLimit {} {
    global tmp cmd
    if {$tmp(l)} {
	enableEntry .options.g.w.w.l.entry
    } {
	disableEntry .options.g.w.w.l.entry
    }
}

proc rangeHeight {} {
    global tmp cmd old
    set cmd(w) [string trimleft $cmd(w) "0"]
    if {[string trim $cmd(w) "0123456789"] != ""} {set cmd(w) $old(w)}
    if {$cmd(w) > 768} {set cmd(w) $old(w)}
    set old(w) $cmd(w)
    .options.g.w.h.text configure -text [expr int("$cmd(w).0"*3/4)]
}

proc scrollWidth {a} {
    global cmd tmp
    incr cmd(w) [expr $a*-32]
    rangeHeight
    if {$cmd(w) == ""} {set cmd(w) "0"}
}

proc parseOptions {} {
    global tmp cmd
    global argv
    set last ""
    foreach a $argv {
	if {[string range $a 0 0] == "-"} {
	    set last [string range $a 1 1]
	    switch $last {
		"d" {set last "XXX"}
		"t" {set tmp(t) "1"}
		"y" {set tmp(y) "1"}
		"s" {
		    set tmp(s) "1"
		    testSleep
		}
		"l" {
		    set tmp(l) "1"
		    testLimit
		}
		"g" {
		    set tmp(g) "1"
		    testGrab
		}
		"Q" {
		    set cmd(Q) "0"
		    testSound
		}
	    }
	} {
	    set cmd($last) $a
	    if {$last == "s"} {rangeSleep}
	    if {$last == "l"} {rangeLimit}
	    if {$last == "w"} {rangeHeight}
	}
    }
}


proc highQ {} {
    global cmd tmp
    set cmd(w) 768
    set tmp(t) 1
    set tmp(y) 1
    set cmd(Q) 1
    set cmd(o) "pmm-best"
    set cmd(R) 44100
    set cmd(B) 16
    set cmd(C) 2
    set tmp(s) 0
    set tmp(g) 0
    set cmd(f) "output.pmm"
    set tmp(M) 1
    testMPEG
    rangeHeight
    testSleep
    testSound
    testGrab
}

proc lowS {} {
    global cmd tmp
    set cmd(w) 320
    set tmp(t) 1
    set tmp(y) 0
    set cmd(Q) 1
    set cmd(o) "pmm-good"
    set cmd(R) 44100
    # was: 32000
    set cmd(B) 16
    set cmd(C) 2
    # was: 1
    set tmp(s) 0
    set tmp(g) 0
    set cmd(q) 35
    set cmd(f) "output.pmm"
    set cmd(r) 1
    set tmp(M) 1
    testMPEG
    rangeHeight
    testSleep
    testSound
    testGrab
}

proc WebTV {} {
    global cmd tmp
    set cmd(w) 320
    set tmp(t) 0
    set tmp(y) 0
    set cmd(Q) 0
    set cmd(o) "jpg"
    set tmp(s) 1
    set cmd(t) 1
    set tmp(g) 0
    set cmd(q) 35
    set tmp(l) 0
    set cmd(f) "webtv.jpg"
    set tmp(M) 0
    testMPEG
    rangeHeight
    testSleep
    testSound
    testLimit
    testGrab
}

set title "bttvgrab 0.15.0"
wm title . $title
#wm overrideredirect . 1
. configure -relief ridge -borderwidth 5

bind . <Return> runGrab

proc disableEntry {x} {
    $x configure -state disabled -bg grey80 -fg grey30
}
proc disableButton {x} {
    $x configure -state disabled -fg grey30
}
proc enableEntry {x} {
    $x configure -state normal -bg grey85 -fg black
}
proc enableButton {x} {
    $x configure -state normal -fg black
}
proc disableFile {x} {
    disableEntry $x.entry
    disableButton $x.browse
}
proc enableFile {x} {
    enableEntry $x.entry
    enableButton $x.browse
}


# action buttons
frame .action
pack .action -side bottom

button .action.run -text "Run!" -com runGrab -default active
button .action.conv -text "Convert" -com runConvert
button .action.info -text "Info" -com grabInfo
button .action.exit -text "Exit" -com exit

button .title -text $title -font\
    "-*-times new roman-bold-i-*-*-30-*" -relief groove\
    -padx 30 -pady 5 -background lemonchiffon -foreground red\
    -borderwidth 3 -activeforeground lightcoral\
    -activebackground seashell -com about
pack .title -side top -pady 5 -padx 5


pack .action.run .action.conv .action.info .action.exit -side left

# parameter selection
frame .options -relief raised -borderwidth 3
frame .options.select
button .options.select.g -text "Grab" -borderwidth 1 -relief raised -com {
    grid forget .options.f .options.conv .options.sound
    grid .options.g -column 0 -row 1 -sticky nwes -pady 4 -padx 4
    .options.select.g configure -relief sunken
    .options.select.f configure -relief raised
    .options.select.conv configure -relief raised
    .options.select.sound configure -relief raised
}
button .options.select.f -text "Output" -borderwidth 1 -relief sunken -com {
    grid forget .options.g .options.conv .options.sound
    grid .options.f -column 0 -row 1 -sticky nwes -pady 4 -padx 4
    .options.select.f configure -relief sunken
    .options.select.g configure -relief raised
    .options.select.conv configure -relief raised
    .options.select.sound configure -relief raised
}
button .options.select.conv -text "Sound" -borderwidth 1 -relief raised -com {
    grid forget .options.f .options.g .options.conv
    grid .options.sound -column 0 -row 1 -sticky nwes -pady 4 -padx 4
    .options.select.conv configure -relief sunken
    .options.select.f configure -relief raised
    .options.select.g configure -relief raised
    .options.select.sound configure -relief raised
}
button .options.select.sound -text "MPEG" -borderwidth 1 -relief raised -com {
    grid forget .options.f .options.sound .options.g
    grid .options.conv -column 0 -row 1 -sticky nwes -pady 4 -padx 4
    .options.select.sound configure -relief sunken
    .options.select.f configure -relief raised
    .options.select.conv configure -relief raised
    .options.select.g configure -relief raised
}
pack .options.select.f .options.select.g .options.select.conv\
    .options.select.sound -side left

frame .options.g -relief sunken -borderwidth 2
frame .options.f -relief sunken -borderwidth 2
frame .options.g.pad1 -width 1 -height 4
frame .options.g.pad2 -width 1 -height 4
frame .options.f.pad1 -width 1 -height 4
frame .options.f.pad2 -width 1 -height 4

frame .options.g.w
frame .options.g.w.w
frame .options.g.w.h
#   width/height
label .options.g.w.w.label -text "Width:" -anchor w -width 7
entry .options.g.w.w.text -relief sunken -width 4 -textvar cmd(w)
bind .options.g.w.w.text <KeyRelease> rangeHeight
scrollbar .options.g.w.w.scr -orient vertical -width 8 -com scrollWidth\
    -repeatinterval 1

#limit
frame .options.g.w.w.l
checkbutton .options.g.w.w.l.check -text "Nr. of frames:" \
    -variable tmp(l) -anchor w -width 16 -com testLimit
entry .options.g.w.w.l.entry -width 6 -textvar cmd(l)
disableEntry .options.g.w.w.l.entry
bind .options.g.w.w.l.entry <KeyRelease> rangeLimit
pack .options.g.w.w.l.check .options.g.w.w.l.entry -side left

# sleep time
frame .options.g.w.h.s
checkbutton .options.g.w.h.s.check -text "Sleep Time (sec.):" \
    -variable tmp(s) -anchor w -width 16 -com testSleep
entry .options.g.w.h.s.entry -width 6 -textvar cmd(s)
disableEntry .options.g.w.h.s.entry
bind .options.g.w.h.s.entry <KeyRelease> rangeSleep
pack .options.g.w.h.s.check .options.g.w.h.s.entry -side left

pack .options.g.w.w.label .options.g.w.w.text .options.g.w.w.scr -side left
pack .options.g.w.w.l -side right
label .options.g.w.h.label -text "Height:" -anchor w -width 7
label .options.g.w.h.text -text "480" -width 4 -anchor w
pack .options.g.w.h.label .options.g.w.h.text -side left
pack .options.g.w.h.s -side right
pack .options.g.w.w .options.g.w.h -side top -fill x

# grablog
frame .options.g.g
checkbutton .options.g.g.check -text "Grab Logfile:" \
    -variable tmp(g) -com testGrab
entry .options.g.g.entry -width 20 -textvar cmd(g)
button .options.g.g.browse -text "Browse..." -com {
    set tmp(g) [tk_getSaveFile -filetypes {
	{{Logfiles} {.log}}
	{{All files} *}
    } -initialfile $cmd(g) -title "Select Grab Logfile..."]
    if {$tmp(g) != ""} {set cmd(g) $tmp(g)}
}
disableFile .options.g.g
pack .options.g.g.check -side left
pack .options.g.g.browse -side right
pack .options.g.g.entry -side right -fill x -expand 1

# output filename
frame .options.f.f
label .options.f.f.label -text "Output Filename:"
entry .options.f.f.entry -width 20 -textvar cmd(f)
button .options.f.f.browse -text "Browse..." -com {
    set tmp(f) [tk_getSaveFile -filetypes {
	{{Image Files} {.pmm .gif .jpg .yuv}}
	{{All files} *}
    } -initialfile $cmd(f) -title "Select Output File..."]
    if {$tmp(f) != ""} {set cmd(f) $tmp(f)}
}
pack .options.f.f.label -side left
pack .options.f.f.browse -side right
pack .options.f.f.entry -side right -fill x -expand 1

# file format
frame .options.f.o
label .options.f.o.label -text "File Format:"
tk_optionMenu .options.f.o.menu cmd(o) pmm-best pmm-good pmm-worse\
    pmm-fast pmm-fastest jpg gif raw8 raw16 raw24 rawyuv yuv
.options.f.o.menu configure -width 12 -anchor c
pack .options.f.o.label .options.f.o.menu -side left

# trace
frame .options.f.o.t
checkbutton .options.f.o.t.t -text "Trace lost frames" -var tmp(t)
checkbutton .options.f.o.t.y -text "Synchronous writes" -var tmp(y)
pack .options.f.o.t.t .options.f.o.t.y -side top -anchor w
pack .options.f.o.t -side right -anchor e

# quality
scale .options.f.q -label "Image Quality" -from 0 -to 200 -resolution 1\
    -variable cmd(q) -orient horizontal -length 200

# sound
frame .options.sound
checkbutton .options.sound.enable -text "Enable Sound" \
    -variable cmd(Q) -com testSound -anchor w

frame .options.sound.d -relief sunken -borderwidth 2
frame .options.sound.d.f
label .options.sound.d.f.label -text "WAV Filename:" -anchor e\
    -width 13
entry .options.sound.d.f.entry -textvar cmd(F) -width 20
button .options.sound.d.f.browse -text "Browse..." -com {
    set tmp(F) [tk_getSaveFile -filetypes {
	{{Sound Files} {.wav}}
	{{All files} *}
    } -initialfile $cmd(F) -title "Select WAV File..."]
    if {$tmp(F) != ""} {set cmd(F) $tmp(F)}
}
pack .options.sound.d.f.label -side left
pack .options.sound.d.f.browse -side right
pack .options.sound.d.f.entry -side right -fill x -expand 1
frame .options.sound.d.d
frame .options.sound.d.pad1 -height 4 -width 1
frame .options.sound.d.pad2 -height 4 -width 1
label .options.sound.d.d.label -text "Device Name:" -anchor e -width 13
entry .options.sound.d.d.entry -textvar cmd(D) -width 20
button .options.sound.d.d.browse -text "Browse..." -com {
    set tmp(D) [tk_getOpenFile -filetypes {
	{{All files} *}
    } -initialdir /dev -title "Select Device..."]
    if {$tmp(D) != ""} {set cmd(D) $tmp(D)}
}
pack .options.sound.d.d.label -side left
pack .options.sound.d.d.browse -side right
pack .options.sound.d.d.entry -side right -fill x -expand 1
frame .options.sound.d.s
label .options.sound.d.s.label -text "Sampling rate:" -anchor e\
    -width 13
tk_optionMenu .options.sound.d.s.samp cmd(R) "48000" "44100" "32000"\
    "22050"
.options.sound.d.s.samp configure -width 5
pack .options.sound.d.s.label .options.sound.d.s.samp -side left
frame .options.sound.d.q
frame .options.sound.d.q.c
radiobutton .options.sound.d.q.c.stereo -text "Stereo" -var cmd(C)\
    -val "2" -width 6 -anchor w
radiobutton .options.sound.d.q.c.mono -text "Mono" -var cmd(C)\
    -val "1" -width 6 -anchor w
pack .options.sound.d.q.c.stereo .options.sound.d.q.c.mono -side top\
    -anchor w -expand 1
frame .options.sound.d.q.b
radiobutton .options.sound.d.q.b.high -text "16 Bit" -var cmd(B)\
    -val "16" -width 6 -anchor w
radiobutton .options.sound.d.q.b.low -text "8 Bit" -var cmd(B)\
    -val "8" -width 6 -anchor w
pack .options.sound.d.q.b.high .options.sound.d.q.b.low -side top\
    -anchor w -expand 1
pack .options.sound.d.q.c -side left -expand 1
pack .options.sound.d.q.b -side right -expand 1

pack .options.sound.d.pad1 .options.sound.d.f .options.sound.d.d\
    .options.sound.d.s .options.sound.d.q -side top -fill x -expand 1\
    -padx 4
pack .options.sound.d.pad2 -side bottom -expand 1 -fill y
pack .options.sound.enable -side top -anchor w -ipadx 2
pack .options.sound.d -side top -anchor w -ipadx 2 -expand 1 -fill both

pack .options.g.pad1 .options.g.w .options.g.g -padx 4 -anchor w\
    -side top -fill x -expand 1
pack .options.g.pad2 -side bottom -expand 1 -fill y

pack .options.f.pad1 .options.f.f .options.f.o \
    -side top -padx 4 -anchor w -expand 1 -fill x
pack .options.f.q -side top -padx 8 -fill x -anchor w -expand 1
pack .options.f.pad2 -side bottom -fill y -expand 1

# conversion
frame .options.conv
checkbutton .options.conv.enable -text "Create MPEG video" -com testMPEG\
    -var tmp(M) -anchor w
frame .options.conv.c -borderwidth 2 -relief sunken
frame .options.conv.c.pad1 -height 4 -width 1
frame .options.conv.c.pad2 -height 4 -width 1
frame .options.conv.c.t
label .options.conv.c.t.label -text "Output Filename:"
entry .options.conv.c.t.entry -width 20 -textvar cmd(d)
button .options.conv.c.t.browse -text "Browse..." -com {
    set tmp(d) [tk_getSaveFile -filetypes {
	{{MPEG Files} {.mpg}}
	{{All files} *}
    } -initialfile $cmd(d) -title "Select MPEG File..."]
    if {$tmp(d) != ""} {set cmd(d) $tmp(d)}
}
pack .options.conv.c.t.label -side left
pack .options.conv.c.t.browse -side right
pack .options.conv.c.t.entry -side right -fill x -expand 1

frame .options.conv.c.m
frame .options.conv.c.b

checkbutton .options.conv.c.b.remove -text "Remove grab files"\
    -var tmp(r) -anchor w
frame .options.conv.c.m.skip
label .options.conv.c.m.skip.l -text "Start frame:"
entry .options.conv.c.m.skip.e -textvar cmd(x) -width 6
bind .options.conv.c.m.skip.e <KeyRelease> rangeStart
pack .options.conv.c.m.skip.l .options.conv.c.m.skip.e -side left

label .options.conv.c.m.label -text "Video BR:" -width 9 -anchor w
entry .options.conv.c.m.entry -width 4 -textvar cmd(br)
bind .options.conv.c.m.entry <KeyRelease> rangeVideo
label .options.conv.c.b.label -text "Audio BR:" -width 9 -anchor w
entry .options.conv.c.b.entry -width 4 -textvar cmd(BR)
bind .options.conv.c.b.entry <KeyRelease> rangeAudio

radiobutton .options.conv.c.m.one -text "MPEG-1" -var cmd(m) \
    -width 8 -anchor w -val "mpeg-1"
radiobutton .options.conv.c.b.two -text "MPEG-2" -var cmd(m) \
    -width 8 -anchor w -val "mpeg-2"

pack .options.conv.c.m.one -side right -padx 10
pack .options.conv.c.m.skip -side left
pack .options.conv.c.m.entry .options.conv.c.m.label -side right

pack .options.conv.c.b.two -side right -padx 10
pack .options.conv.c.b.remove -side left
pack .options.conv.c.b.entry .options.conv.c.b.label -side right
pack .options.conv.c.pad1 .options.conv.c.t .options.conv.c.m\
    .options.conv.c.b -side top -fill both -padx 4 -expand 1
pack .options.conv.c.pad2 -expand 1 -side bottom -fill both
pack .options.conv.enable -side top -anchor w
pack .options.conv.c -fill both -expand 1 -side bottom

pack .options -side top -fill both -padx 4 -pady 4
grid rowconfigure .options 1 -minsize 180
grid columnconfigure .options 0 -minsize 400
grid .options.select -column 0 -row 0 -sticky n -pady 4 -padx 4
grid .options.f -column 0 -row 1 -sticky nwes -pady 4 -padx 4

frame .preset
button .preset.highQ -text "High Quality" -com highQ
button .preset.lowS -text "Low Space" -com lowS
button .preset.webTV -text "Web TV" -com WebTV
pack .preset.highQ .preset.lowS .preset.webTV -side left
pack .preset -side bottom

proc about {} {
    global title
    set msg "This is $title"

    if {[catch "toplevel .about -relief groove -borderwidth 6"]} {
	return
    }
    wm title .about "About $title"
    frame .about.msg -relief groove -borderwidth 2
    label .about.msg.message -text $msg\
	-font "-*-times new roman-bold-r-*-*-30-*" -fg red3
    frame .about.msg.underline -width 250 -height 2 -borderwidth 1\
	-relief sunken
    label .about.msg.message1 -text $msg1\
	-font "-*-times new roman-bold-r-*-*-20-*"
    pack .about.msg.message -padx 5 -pady 10
    pack .about.msg.underline .about.msg.message1 -padx 5
    button .about.ok -text "OK" -default active -com {destroy .about}
    pack .about.msg .about.ok -side top -pady 5 -padx 5

    bind .about <Return> {destroy .about}

}

proc grabInfo {} {
    global title
    set info [exec "bttvgrab" "-i"]

    if {[catch "toplevel .info -relief groove -borderwidth 6"]} {
	return
    }
    wm title .info "Grab Informations"
    frame .info.msg -relief groove -borderwidth 2
    text .info.msg.msg -height 12 -relief flat
    .info.msg.msg insert end $info
    .info.msg.msg configure -state disabled
    pack .info.msg.msg -padx 5 -pady 10 -side left
    button .info.ok -text "OK" -default active -com {destroy .info}
    pack .info.msg .info.ok -side top -pady 5 -padx 5

    bind .info <Return> {destroy .info}

}

proc runGrab {} {
    global tmp pipeafter
    if {$tmp(M)} {set pipeafter runConvert}
    runPipe [makeOptions]
}

proc runConvert {} {
    runPipe [makeConvert]
}

proc runPipe {a} {
    global pipe
    if {$pipe != ""} {return}
    if {![catch "frame .running"]} {	
	.running configure -relief groove -borderwidth 3

	label .running.progress -text "File:"
	label .running.result -text "" -anchor w
	button .running.exit -text "Abort" -com endGrab
	button .running.pause -text "Pause" -com pauseGrab
	pack .running.progress .running.result -side left -padx 5 -pady 5
	pack .running.pause .running.exit -side right
	pack .running -side bottom -fill x -padx 8
    }
    .running.exit configure -text "Abort" -com endGrab
    .running.pause configure -text "Pause" -com pauseGrab -fg black\
	-state normal
    

    set pipe [open $a "r+"]
    fconfigure $pipe -buffering line -buffersize 10
    fileevent $pipe readable "updateResult"
}

proc endGrab {} {
    global pipe
    puts $pipe "q"
}

proc pauseGrab {} {
    global pipe
    puts $pipe ""
    .running.pause configure -text "Continue" -com continueGrab
}

proc continueGrab {} {
    global pipe
    puts $pipe ""
    .running.pause configure -text "Pause" -com pauseGrab
}

proc updateResult {} {
    global pipe pipeafter
    gets $pipe line
    if {[eof $pipe]} {
	.running.exit configure -text "Close" -com {destroy .running}
	fileevent $pipe readable ""
	set lub $pipe
	set pipe ""
	.running.pause configure -state disabled -fg grey30
	close $lub
	if {$pipeafter != ""} {
	    set lub $pipeafter
	    set pipeafter ""
	    eval $lub
	}
    } {
	.running.result configure -text $line
    }
}

proc makeOptions {} {
    global cmd tmp
    set retval "|bttvgrab -w $cmd(w) -q $cmd(q) -o $cmd(o) -f $cmd(f) -d d"
    if {$tmp(s)} {set retval "$retval -s $cmd(s)"}
    if {$tmp(t)} {set retval "$retval -t"}
    if {$tmp(y)} {set retval "$retval -y"}
    if {$tmp(g)} {set retval "$retval -g $cmd(g)"}
    if {$tmp(l)} {set retval "$retval -l $cmd(l)"}
    if {$cmd(Q)} {
	set retval "$retval -R $cmd(R) -C $cmd(C) -B $cmd(B) -D $cmd(D) -F $cmd(F)"
    } {
	set retval "$retval -Q"
    }
    return $retval
}

proc makeConvert {} {
    global cmd tmp
    if {$cmd(x) == ""} {set cmd(x) "0"}
    set retval "|bttvconvert -w $cmd(w) -s $cmd(f) -d d -x $cmd(x)"
    set retval "$retval -o $cmd(m) -f $cmd(d) -b $cmd(br)"
    if {$tmp(t)} {
	if {$tmp(l)} {
	    set retval "$retval -t"
	} {
	    tk_messageBox -type ok -icon error -message\
		"You must specify 'Nr. of Frames' when creating MPEG videos"
	    return "|cat /dev/null"
	}
    }
    if {[string first "pmm" $cmd(o)] != 0} {
	 set retval "$retval -i $cmd(o)"
    } {
	 set retval "$retval -i pmm"
    }


    if {$tmp(g)} {set retval "$retval -g $cmd(g)"}
    if {$tmp(l)} {set retval "$retval -l $cmd(l)"}
    if {$tmp(r)} {set retval "$retval -r"}
    if {$cmd(Q)} {
	set retval "$retval -F $cmd(F) -B $cmd(BR)"
    } {
	set retval "$retval -Q"
    }
    return $retval
}


parseOptions
testMPEG
