/**********************************************************************

	--- Qt Architect generated file ---

	File: InfoWnd.cpp
	Last generated: Wed Aug 12 03:17:58 1998

 *********************************************************************/

#include "InfoWnd.h"
#include <unistd.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include "version.h"
#include <string.h>
#include <errno.h>
#include <linux/types.h>
#include <linux/videodev.h>

#define Inherited InfoWndData

#define NOTNEG1(a) if ((a) == -1) {info->insertLine(strerror(errno)); if (fbttv != -1) close(fbttv); return;}

InfoWnd::InfoWnd
(
	const char *device,
	QWidget* parent,
	const char* name
)
	:
	Inherited( parent, name )
{
	setCaption( "bttvgrab info" );
	defbtn->setDefault(true);

	struct video_capability vcapability;
	struct video_tuner vtuner;
	struct video_channel vchan;
	struct video_buffer vbuffer;
	int i, fbttv = -1;
	char *device_cap[] = {
		"capture", "tuner", "teletext", "overlay", "chromakey", "clipping",
		"frameram", "scales", "monochrome", NULL };

	info->insertLine("bttvgrab "    VERSION    " - Video4Linux Informations");
	info->insertLine("*****************************************************");
	info->insertLine("");

	NOTNEG1(fbttv = ::open(device,O_RDWR));

	NOTNEG1(ioctl(fbttv,VIDIOCGCAP,&vcapability));
	
	NOTNEG1(ioctl(fbttv,VIDIOCGFBUF,&vbuffer));
	
	info->insertLine(QString("card_name     : ")+QString(vcapability.name));
	QString tmp("flags         :");
	for (i = 0; device_cap[i] != NULL; i++) {
		if (vcapability.type & (1 << i)) tmp += QString(" ") + QString(device_cap[i]);
	}
	info->insertLine(tmp);	

	tmp = QString("channels      : ")+QString().setNum(vcapability.channels) + QString(" (");
	for (i = 0; i < vcapability.channels; i++) {
		vchan.channel = i;
		if (ioctl(fbttv,VIDIOCGCHAN,&vchan) != -1) tmp +=  QString(" ") + QString(vchan.name);
	}
	tmp += QString(" )");

	info->insertLine(tmp);
	info->insertLine(QString("audio devices : ")+QString().setNum(vcapability.audios));
	info->insertLine(QString("size (max/min): ")+QString().setNum(vcapability.maxwidth)+QString("*")+QString().setNum(vcapability.maxheight)+QString("/")+QString().setNum(vcapability.minwidth)+QString("*")+QString().setNum(vcapability.minheight));

	vtuner.tuner = 0;
	if (ioctl(fbttv,VIDIOCGTUNER,&vtuner) != -1) {
		info->insertLine(QString("tuner         : ")+QString(vtuner.name)+QString(" (Freq.: ")+QString().setNum(vtuner.rangelow)+QString("-")+QString().setNum(vtuner.rangehigh)+QString(")"));
	}

	info->insertLine(QString("grab_buffer   : base=")+QString().setNum((unsigned long)vbuffer.base)+QString(" size=")+QString().setNum(vbuffer.width)+QString("*")+QString().setNum(vbuffer.height)+QString(" depth=")+QString().setNum(vbuffer.depth)+QString(" bpl=")+QString().setNum(vbuffer.bytesperline));

	::close(fbttv);
}


InfoWnd::~InfoWnd()
{
}
