/**********************************************************************

	--- Qt Architect generated file ---

	File: MainWnd.cpp
	Last generated: Sat Aug 1 11:18:42 1998

 *********************************************************************/

#include "MainWnd.h"
#include "version.h"
#include <string.h>
#include "main.h"
#include "MainWndSettings.h"
#include "ProgressWnd.h"
#include "AboutBox.h"
#include <kapp.h>
#include <qkeycode.h>
#include "InfoWnd.h"
#include <kconfig.h>
#include "TimerWnd.h"
#include "TimerStatus.h"
#include <qdatetime.h>

#define Inherited MainWndData

MainWnd::MainWnd
(
	QWidget* parent,
	const char* name
)
	:
	Inherited( parent, name )
{
	char nm[64] = "bttvgrab " VERSION;
	*(strchr(nm,'[')-1) = 0;
	parent->setCaption( nm );
	defbut->setDefault(true);
}


MainWnd::~MainWnd()
{
}

void MainWnd::quit()
{
	(KApplication::getKApplication())->quit();
}

void MainWnd::runTimer()
{
	TimerWnd *t;
	TimerStatus *s;
	QTime *time;

	t = new TimerWnd(this);
	if (t->exec() == QDialog::Rejected) {
		delete t;
		return;
	}

	time = t->getTime();
	s = new TimerStatus(*time,t->doRepeat(),t->getDays());
	delete t;
	delete time;

	connect(s,SIGNAL(execute()),SLOT(runGrab()));

	parentWidget()->hide();
	s->exec();
	parentWidget()->show();
	delete s;
}

void MainWnd::runConv()
{
	int i = 0;
	char opt[PATH_MAX], val[PATH_MAX];

	while (settings->get(opt,val,i++)) {
		configure(opt,val);
	}

	settings->get("grab_file_fmt",val);
	configure("input_file_fmt",val);

	ProgressWnd(this,"progresswnd").exec();
}

void MainWnd::restoreSettings(KConfig *cfg)
{
	char opt[PATH_MAX], val[PATH_MAX];
	const char *res;
	int i = 0;

	while (settings->get(opt,val,i++)) {
		res = cfg->readEntry(opt);
		if (res) settings->set(opt,res);
	}
}

void MainWnd::saveSession()
{
	char opt[PATH_MAX], val[PATH_MAX];
	int i = 0;
	KConfig *m = KApplication::getKApplication()->getSessionConfig();

	while (settings->get(opt,val,i++)) {
		m->writeEntry(opt,val);
	}
}

void MainWnd::saveSettings()
{
	char opt[PATH_MAX], val[PATH_MAX];
	int i = 0;
	KConfig *m = KApplication::getKApplication()->getConfig();

	while (settings->get(opt,val,i++)) {
		m->writeEntry(opt,val);
	}
}

void MainWnd::runGrab()
{
	int i = 0;
	char opt[PATH_MAX], val[PATH_MAX];

	while (settings->get(opt,val,i++)) {
		configure(opt,val);
	}

	ProgressWnd(this,"progresswnd").exec();
}

void MainWnd::runInfo()
{
	char tmp[PATH_MAX];
	settings->get("grabdevice",tmp);
	InfoWnd(tmp,this,"info").exec();
}

void MainWnd::setDefaults()
{
	settings->setDefaults();
}

void MainWnd::setHiQ()
{
	settings->setHiQ();
}

void MainWnd::setLowS()
{
	settings->setLowS();
}

void MainWnd::setWebTV()
{
	settings->setWebTV();
}

void MainWnd::openAboutBox()
{
	AboutBox(this,"about").exec();
}
