/**********************************************************************

	--- Qt Architect generated file ---

	File: MainWndSettings.cpp
	Last generated: Sat Aug 1 11:18:45 1998

 *********************************************************************/

#include "MainWndSettings.h"
#include <qstring.h>
#include <qlineedit.h>
#include <qcheckbox.h>
#include <qradiobutton.h>
#include <qcombobox.h>
#include "MainWndSettingsGrab.h"
#include "MainWndSettingsSound.h"
#include "MainWndSettingsOutput.h"
#include "MainWndSettingsMPEG.h"
#include "error.h"

#define Inherited MainWndSettingsData

MainWndSettings::MainWndSettings
(
	QWidget* parent,
	const char* name
)
	:
	Inherited( parent, name )
{
	addTab(grab = new MainWndSettingsGrab(this),"&Grab");
	addTab(out = new MainWndSettingsOutput(this),"&Output");
	addTab(sound = new MainWndSettingsSound(this),"&Sound");
	addTab(mpeg = new MainWndSettingsMPEG(this),"&MPEG");
	setOKButton(0);
	connect(grab->limit,SIGNAL(textChanged(const char *)),mpeg->limit,SLOT(setText(const char *)));
	connect(mpeg->limit,SIGNAL(textChanged(const char *)),grab->limit,SLOT(setText(const char *)));
}


MainWndSettings::~MainWndSettings()
{
}

#define STARTOPT int i = 0; if (!option || !value) { ERROR(INTMSG("null pointer passed")); return false
#define SET if (set)
#define GET if (!set)
#define OPT(n) } else if (!strcmp(option,#n) || num == i++) { if (num != -1) strcpy(option,#n);;
#define ENDOPT } else { if (num == -1) ERROR(INTMSG("unknown option '%s'"),option); return false; } return true
#define TEXTOPT(obj,name) \
	OPT(name) \
		SET{obj->name->setText(value);} \
		GET{strcpy(value,obj->name->text());}
#define INTOPT(obj,name) \
	OPT(name) \
		SET{obj->name->setValue(QString(value).toInt());} \
		GET{strcpy(value,QString().setNum(obj->name->value()));}
#define TEXTCHECKOPT(obj,name,var) \
	OPT(name) \
		SET{if (*value && value[0] != '0') obj->name->setText(value); obj->var->setChecked(*value != 0);} \
		GET{if (obj->var->isChecked()) strcpy(value,obj->name->text()); else *value=0;}
#define BOOLOPT(obj,name) \
	OPT(name) \
		SET{obj->name->setChecked(*value != '0');} \
		GET{strcpy(value,(obj->name->isChecked()?"1":"0"));}
#define RADIOOPT(obj,name,var,valn,valr) \
	OPT(name) \
		SET{(strcmp(value,valr)?obj->name:obj->var)->setChecked(true);} \
		GET{strcpy(value,(obj->var->isChecked()?valr:valn));}
#define COMBOOPT(obj,name) \
	OPT(name) \
		SET{for (int i = obj->name->count()-1; i >= 0; i--) if (!strcmp(obj->name->text(i),value)) { obj->name->setCurrentItem(i); break; }} \
		GET{strcpy(value,obj->name->currentText());}
#define COMBOINTOPT(obj,name) \
	OPT(name) \
		SET{obj->name->setCurrentItem(QString(value).toInt());} \
		GET{strcpy(value,QString().setNum(obj->name->currentItem()));}


bool MainWndSettings::setget(char *option, char *value, bool set, int num)
{
	STARTOPT;
	TEXTOPT(grab,grabdevice);
	COMBOINTOPT(grab,channel);
	TEXTOPT(grab,width);
	TEXTOPT(grab,height);
	TEXTCHECKOPT(grab,limit,do_limit);
	TEXTCHECKOPT(grab,sleeptime,do_sleeptime);
	TEXTCHECKOPT(grab,skip,do_skip);
	TEXTCHECKOPT(grab,grablog,do_grablog);
	TEXTOPT(out,grabname);
	COMBOOPT(out,grab_file_fmt);
	BOOLOPT(out,do_trace);
	BOOLOPT(out,do_sync);
	INTOPT(out,quality);
	BOOLOPT(mpeg,lowdisk);
	OPT(conv_file_fmt)
		SET {
			if (*value) {
				if (!strcmp(value,"mpeg-1")) mpeg->mpeg1->setChecked(true);
				else if (!strcmp(value,"mpeg-2")) mpeg->mpeg2->setChecked(true);
				else {
					ERROR(INTMSG("file format '%s' not supported for conversion"),value);
					return true;
				}
				mpeg->do_conv->setChecked(true);
			} else {
				mpeg->do_conv->setChecked(false);
			}
		}
		GET {
			strcpy(value,(mpeg->do_conv->isChecked()?(mpeg->mpeg2->isChecked()?"mpeg-2":"mpeg-1"):""));
		}
	TEXTOPT(mpeg,first_conv);
	TEXTOPT(mpeg,video_bitrate);
	TEXTOPT(mpeg,audio_bitrate);
	TEXTOPT(mpeg,convname);
	BOOLOPT(sound,do_sound);
	TEXTOPT(sound,soundfile);
	TEXTOPT(sound,sounddevice);
	COMBOOPT(sound,soundrate);
	RADIOOPT(sound,soundchannels,mono,"2","1");
	RADIOOPT(sound,soundbits,b8,"16","8");
	ENDOPT;
}

void MainWndSettings::set(const char *option, const char *value)
{
	setget((char *)((void *)option),(char *)((void *)value),true);
}

void MainWndSettings::get(const char *option, char *value)
{
	setget((char *)((void *)option),value,false);
}

bool MainWndSettings::get(char *option, char *value, int index)
{
	*option = 0;
	return setget(option,value,false,index);
}

void MainWndSettings::setHiQ()
{
	set("width","768");
	set("do_trace","1");
	set("do_sync","1");
	set("do_sound","1");
	set("grab_file_fmt","pmm-best");
	set("soundrate","44100");
	set("soundbits","16");
	set("soundchannels","2");
	set("sleeptime","");
	set("lowdisk","0");
	set("grablog","");
	set("grabname","output.pmm");
	set("convname","output.mpg");
	set("conv_file_fmt","mpeg-1");
}

void MainWndSettings::setLowS()
{
	set("width","320");
	set("do_trace","1");
	set("do_sync","0");
	set("do_sound","1");
	set("grab_file_fmt","pmm-good");
	set("soundrate","44100");
	set("soundbits","16");
	set("soundchannels","2");
	set("sleeptime","");
	set("quality","35");
	set("lowdisk","1");
	set("grablog","");
	set("grabname","output.pmm");
	set("convname","output.mpg");
	set("conv_file_fmt","mpeg-1");
}

void MainWndSettings::setDefaults()
{
	set("width","640");
	set("do_trace","0");
	set("do_sync","0");
	set("do_sound","1");
	set("grab_file_fmt","pmm-good");
	set("soundrate","44100");
	set("soundbits","16");
	set("soundchannels","2");
	set("sleeptime","1");
	set("sleeptime","");
	set("quality","50");
	set("lowdisk","0");
	set("grablog","");
	set("grabname","output.pmm");
	set("limit","250");
	set("limit","");
	set("skip","-1");
	set("skip","");
	set("soundfile","grab.wav");
	set("sounddevice","/dev/dsp");
	set("convname","output.mpg");
	set("first_conv","0");
	set("video_bitrate","1152");
	set("audio_bitrate","128");
	set("conv_file_fmt","mpeg-1");
	set("conv_file_fmt","");
}

void MainWndSettings::setWebTV()
{
	set("width","320");
	set("do_trace","0");
	set("limit","");
	set("do_sync","0");
	set("do_sound","0");
	set("grab_file_fmt","jpg");
	set("sleeptime","1");
	set("quality","35");
	set("grablog","");
	set("grabname","webtv.jpg");
	set("conv_file_fmt","");
}

