/**********************************************************************

	--- Qt Architect generated file ---

	File: MainWndSettingsGrab.cpp
	Last generated: Sat Aug 1 11:18:48 1998

 *********************************************************************/

#include "MainWndSettingsGrab.h"
#include <qstring.h>
#include <qvalidator.h>
#include <qfiledialog.h>
#include "main.h"


#define Inherited MainWndSettingsGrabData

MainWndSettingsGrab::MainWndSettingsGrab
(
	QWidget* parent,
	const char* name
)
	:
	Inherited( parent, name )
{
	limit->setValidator(new QIntValidator(0,99999999,this));
	sleeptime->setValidator(new QIntValidator(0,99999999,this));
	skip->setValidator(new QIntValidator(-100,100,this));
	width->setValidator(new QIntValidator(32,768,this));
	sleeptime->setEnabled(false);
	limit->setEnabled(false);
	skip->setEnabled(false);
	grablog->setEnabled(false);
	grabbrowse->setEnabled(false);

	updateSrc();
}

MainWndSettingsGrab::~MainWndSettingsGrab()
{
}

void MainWndSettingsGrab::updateSrc()
{
	char val[PATH_MAX], *cur;

	while(channel->count()) channel->removeItem(0);
	
	configure("grabdevice",grabdevice->text());
	inquire("channel list",val);
	cur = strtok(val," ");
	while (cur) {
		channel->insertItem(cur);
		cur = strtok(NULL," ");
	}
	channel->setCurrentItem(0);
}

void MainWndSettingsGrab::rangeWidth(const char *str)
{
	height->setText(QString().setNum(QString(str).toInt()*3/4));
}

void MainWndSettingsGrab::testSleep(bool enabled)
{
	sleeptime->setEnabled(enabled);
}

void MainWndSettingsGrab::testSkip(bool enabled)
{
	skip->setEnabled(enabled);
}

void MainWndSettingsGrab::decreaseWidth()
{
	width->validateAndSet(QString().setNum(QString(width->text()).toInt()-32),
			      0,0,0);
}

void MainWndSettingsGrab::increaseWidth()
{
	width->validateAndSet(QString().setNum(QString(width->text()).toInt()+32),
			      0,0,0);
}

void MainWndSettingsGrab::browseGrablog()
{
	QString s = QFileDialog::getSaveFileName(grablog->text(),0,this,"Select Grablog");
	if (s.isEmpty()) return;
	grablog->setText(s);
}

void MainWndSettingsGrab::browseGrabdev()
{
	QString s = QFileDialog::getSaveFileName(grabdevice->text(),0,this,"Select Grablog");
	if (s.isEmpty()) return;
	grabdevice->setText(s);
}

void MainWndSettingsGrab::testLimit(bool enabled)
{
	limit->setEnabled(enabled);
}

void MainWndSettingsGrab::testGrablog(bool enabled)
{
	grablog->setEnabled(enabled);
	grabbrowse->setEnabled(enabled);
}
