/**********************************************************************

	--- Qt Architect generated file ---

	File: ProgressWnd.cpp
	Last generated: Mon Aug 10 21:00:05 1998

 *********************************************************************/

#include "ProgressWnd.h"
#include "main.h"
#include <sys/time.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <limits.h>
#include <error.h>
#include <qsocketnotifier.h>

#define Inherited ProgressWndData

void ProgressWnd::update_grabprogress()
{
	char src[PATH_MAX], dest[PATH_MAX], conv[PATH_MAX], *p;
	char tmp[64];
	int rc, i = 0;

	nr += (rc = getprogress(src,dest,conv));

	if (rc == -1) {
		setCaption("bttvgrab done");
		endbutton->setEnabled(true);
		endbutton->setText("Done");
		pausebtn->setEnabled(false);
		sock->setEnabled(false);
		srclabel->setText("finished");
		destlabel->setText("");
		delete sock;
		sock = 0;
		return;
	} 
	if (rc == -2) {
		sock->setEnabled(false);
		delete sock;
		sock = new QSocketNotifier(main_inpipe,QSocketNotifier::Read);
		connect(sock, SIGNAL(activated(int)), SLOT(update_convprogress()));
		fpslabel->setText("25");
		if (nr == -2) lostlabel->setText("");
		pausebtn->setEnabled(false);
		endbutton->setEnabled(false);
		nr = 0;
		return;
	}
	gettimeofday(&after, 0);
	p = strrchr(dest,'[');
	if (p) sscanf(p,"[%d",&i);
	lostlabel->setText(QString().setNum(i-nr+2));
	nrlabel->setText(QString().setNum(nr));
	destlabel->setText(dest);
	sprintf(tmp, "%2.01f", after.tv_sec==start?0:(double)nr/(double)(after.tv_sec-start));
	fpslabel->setText(tmp);
	sprintf(tmp,"%li:%02li.%02li",(after.tv_sec-start)/3600,
		((after.tv_sec-start)/60)%60,(after.tv_sec-start)%60);
	timelabel->setText(tmp);
	srclabel->setText(src);
}

void ProgressWnd::update_convprogress()
{
	char src[PATH_MAX], dest[PATH_MAX], conv[PATH_MAX];
	char tmp[64];
	int rc;
	nr += (rc = getprogress(src,dest,conv));

	if (rc == -1) {
		setCaption("bttvgrab done");
		endbutton->setEnabled(true);
		endbutton->setText("Done");
		pausebtn->setEnabled(false);
		sock->setEnabled(false);
		srclabel->setText("finished");
		destlabel->setText("");
		delete sock;
		sock = 0;
		return;
	}

	gettimeofday(&after, 0);
	nrlabel->setText(QString().setNum(nr));
	destlabel->setText(conv);
	sprintf(tmp,"%li:%02li.%02li",(after.tv_sec-start)/3600,
		((after.tv_sec-start)/60)%60,(after.tv_sec-start)%60);
	timelabel->setText(tmp);
	srclabel->setText(src);
}

ProgressWnd::ProgressWnd
(
	QWidget* parent,
	const char* name
)
	:
	Inherited( parent, name )
{
	setCaption( "bttvgrab working..." );
	endbutton->setDefault(true);
	gettimeofday(&after, 0);
	start = after.tv_sec;
	nr = 0;
	sock = new QSocketNotifier(main_inpipe,QSocketNotifier::Read);
	connect(sock, SIGNAL(activated(int)), SLOT(update_grabprogress()));
	control(C_START);
}

ProgressWnd::~ProgressWnd()
{
}

void ProgressWnd::pauseRun(bool pause)
{
	if (pause) {
		control(C_PAUSE);
		pausebtn->setText("Continue");
	} else {
		control(C_CONT);
		pausebtn->setText("Pause");
	}
}

void ProgressWnd::abortRun()
{
	if (sock) control(C_STOP);
	else accept();
}
