/**********************************************************************

	--- Qt Architect generated file ---

	File: TimerStatus.cpp
	Last generated: Mon Aug 17 16:25:41 1998

 *********************************************************************/

#include "TimerStatus.h"
#include <qdatetime.h>
#include <qtimer.h>

#define Inherited TimerStatusData

TimerStatus::TimerStatus
(
	QTime &target, bool repeat, int days,
	QWidget* parent,
	const char* name
)
	:
	Inherited( parent, name )
{
	setCaption( "bttvgrab timer" );
	if (days == 0 && target < QTime::currentTime()) days = 1;
	day = days?days:1;
	time = new QTime(target);
	QTimer::singleShot((QTime::currentTime().secsTo(*time)+60*60*24*days)*1000,this,SLOT(run()));
	restart->setChecked(repeat);
	timelabel->setText(time->toString()+QString(", day ")+QString().setNum(days));
}

void TimerStatus::run()
{
	emit execute();
	if (restart->isChecked()) QTimer::singleShot(QTime::currentTime().msecsTo(*time)+1000*60*60*24*day,this,SLOT(run()));
	else accept();
	timelabel->setText(time->toString()+QString(", day ")+QString().setNum(day));
}

TimerStatus::~TimerStatus()
{
	delete time;
}
