/* 
   bttvgrab 0.15.0 [1999-01-18]
   (c) 1998, 1999 by Joerg Walter <trouble@moes.pmnet.uni-oldenburg.de>
   Maintained by: Joerg Walter
   Current version at http://moes.pmnet.uni-oldenburg.de/bttvgrab/

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include "MainWnd.h"
#include <limits.h>
#include <string.h>
#include <kapp.h>
#include <kconfig.h>
#include "main.h"
#include <ktopwidget.h>
#include "Error.h"

char error_progname[PATH_MAX];

int main(int argc, char *argv[], char *envp[])
{
	KApplication app(argc, argv);
	KTopLevelWidget *top = 0;
	MainWnd *m = 0;
	Error *h;
	int rc;

	strcpy(error_progname,argv[0]);
	main_init();
	configure("always_abort","0");
	h = new Error();

	if (kapp->isRestored()) {
		int n = 1;
		while (KTopLevelWidget::canBeRestored(n)) {
			top = new KTopLevelWidget();
			m = new MainWnd(top);
			QObject::connect(kapp,SIGNAL(saveYourself()),m,SLOT(saveSession()));
			top->setView(m);
			top->restore(n);
			m->restoreSettings(kapp->getSessionConfig());
			n++;
		}
	} else {
		top = new KTopLevelWidget();
		m = new MainWnd(top);
		m->restoreSettings(kapp->getConfig());
		QObject::connect(kapp,SIGNAL(saveYourself()),m,SLOT(saveSession()));
		top->setView(m);
		top->show();
	}
	
	app.setMainWidget(top);

	rc = app.exec();
	return rc;
}
