/* 
   bttvgrab 0.15.0 [1999-01-18]
   (c) 1998, 1999 by Joerg Walter <trouble@moes.pmnet.uni-oldenburg.de>
   Maintained by: Joerg Walter
   Current version at http://moes.pmnet.uni-oldenburg.de/bttvgrab/

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#define START_OPTIONS        void SYMBOL(option) (const char *option, char *value, int set) { if (!option || !value) { ERROR(INTMSG("null pointer passed")); exit(1);
#define OPTION(x)            } else if (!strcmp(#x,option)) {
#define FORWARD(mod,opt) OPTIONSET(mod ## _configure(#opt,value);)
#define OPTREDIRECT(x,mod,opt) OPTION(x) FORWARD(mod,opt) OPTIONGET(mod ## _inquire(#opt,value);)
#define OPTIONSET(x)         if (set) { x }
#define OPTIONGET(x)         if (!set) { x }

#define INTOPTION(x,min,max) OPTION(x) OPTIONSET(SYMBOL(x) = atoi(value); ASSERT(SYMBOL(x) >= (min) && SYMBOL(x) <= (max),(INTMSG(#x " out of range")));) OPTIONGET(sprintf(value,"%i",SYMBOL(x));)
#define INTINFO(x) OPTION(x) OPTIONGET(sprintf(value,"%i",SYMBOL(x));)

#define PTROPTION(x,nr)      OPTION(x) ASSERT(!nr || SYMBOL(x),(INTMSG("access to null pointer in option " #x))); OPTIONSET(memcpy(SYMBOL(x),(void *)value,(nr) * sizeof(void *));) OPTIONGET(memcpy((void *)value,SYMBOL(x),(nr) * sizeof(void *));)
#define PTRINFO(x,nr)        OPTION(x) OPTIONGET(memcpy((void *)value,SYMBOL(x),(nr) * sizeof(void *));)

#define STROPTION(x)         OPTION(x) OPTIONSET(strcpy(SYMBOL(x),value);) OPTIONGET(strcpy(value,SYMBOL(x));)
#define STRINFO(x)           OPTION(x) OPTIONGET(strcpy(value,SYMBOL(x));)
#define END_OPTIONS          } else {ERROR(INTMSG("unknown option '%s'"),option);exit(1);}} void SYMBOL(configure) (const char *option, const char *value) {SYMBOL(option)(option,(char *)value,1);} void SYMBOL(inquire) (const char *option, char *value) {SYMBOL(option)(option,value,0);}
