/* 
   bttvgrab 0.15.0 [1999-01-18]
   (c) 1998, 1999 by Joerg Walter <trouble@moes.pmnet.uni-oldenburg.de>
   Maintained by: Joerg Walter
   Current version at http://moes.pmnet.uni-oldenburg.de/bttvgrab/

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef ERROR_H
#define ERROR_H
#include <errno.h>
#include <stdio.h>
extern char error_progname[];
extern char *error_text;
extern void error_abort(int);

#ifdef DEBUG
#undef DEBUG
#define DEBUG(x) "%s:%i: " x ,__FILE__,__LINE__
#else
#define DEBUG(x) x
#endif

#ifdef ASSERT
#undef ASSERT
#endif

#define ERROR                            sprintf
#define ERROR_H_ERR(a)                   ERROR a
#define END(n)				 ENDFUNC(n); error_abort(n)
#define ENDFUNC(n)			 

#define ERRMSG(a)                        error_text,DEBUG("%s error: %s (" a ")"),error_progname,strerror(errno)
#define MSG(a)                           error_text,DEBUG("%s error: " a),error_progname
#define NOERR(a)                           error_text,DEBUG("%s: " a),error_progname
#define INTMSG(a)                        error_text,DEBUG("%s internal error: " a),error_progname
#define ARGMSG(a)                        error_text,DEBUG("%s error: invalid argument \"-%c\" - " a),error_progname,optchar
#define ARGPMSG(a)                       error_text,DEBUG("%s error: invalid argument \"-%c %s\" - " a),error_progname,optchar,optarg

#define ASSERT(a,b)                      do if (!(a)) { ERROR_H_ERR(b); END(1);} while (0)

#define NOTNULL(a,b)                     ASSERT((a) != NULL,b)
#define NOTNEG1(a,b)                     ASSERT((a) != -1,b)
#define RANGE(var,min,max,name,func)     ASSERT((var) >= (min) && (var) <= (max),(func(name " must be %i - %i"),min,max))
#define ARGRANGE(var,min,max,name)       RANGE(var,min,max,name,ARGPMSG)

#define OPENMSG(name)                    (ERRMSG("open %s"),name)
#define READMSG(name)                    (ERRMSG("read %s"),name)
#define WRITEMSG(name)                   (ERRMSG("write %s"),name)
#define CLOSEMSG(name)                   (ERRMSG("close %s"),name)

#define SAFE_REALLOC(var,size)           do { if (size) {NOTNULL((var) = realloc((var),(size)),(ERRMSG("realloc %i bytes"),(size)));} else {free(var); (var) = NULL;}} while (0)
#define SAFE_MALLOC(var,size)            NOTNULL((var) = malloc(size),(ERRMSG("malloc %i bytes"),(size)))
#define SAFE_CALLOC(var,n,size)          NOTNULL((var) = calloc((n),(size)),(ERRMSG("calloc %i bytes"),(n)*(size)))
#define SAFE_CREAT(var,name,mode)        NOTNEG1((var) = creat((name),(mode)),OPENMSG(name))
#define SAFE_OPEN(var,name,mode)         NOTNEG1((var) = open((name),(mode)), OPENMSG(name))
#define SAFE_FOPEN(var,name,mode)        NOTNULL((var) = fopen((name),(mode)),OPENMSG(name))
#define SAFE_CLOSE(var,name)             NOTNEG1(close(var),CLOSEMSG(name))
#define SAFE_FCLOSE(var,name)            ASSERT(fclose(var) == 0,CLOSEMSG(name))
#define SAFE_WRITE(fh,buffer,size,name)  ASSERT(write((fh),(buffer),(size)) == (size),WRITEMSG(name));
#define SAFE_FWRITE(buffer,size,fp,name) ASSERT(fwrite((buffer),01,(size),(fp)) == (size),WRITEMSG(name));
#define SAFE_READ(fh,buffer,size,name)   ASSERT(read((fh),(buffer),(size)) == (size),READMSG(name));
#define SAFE_FREAD(buffer,size,fp,name)  ASSERT(fread((buffer),01,(size),(fp)) == (size),READMSG(name));
#define SAFE_FREE(var)                   do {if (var) {free(var); (var) = NULL;}} while (0)

#endif
