/* 
   bttvgrab 0.15.0 [1999-01-18]
   (c) 1998, 1999 by Joerg Walter <trouble@moes.pmnet.uni-oldenburg.de>
   Maintained by: Joerg Walter
   Current version at http://moes.pmnet.uni-oldenburg.de/bttvgrab/

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include <values.h>
#include <unistd.h>
#include <stdio.h>
#include <limits.h>
#include <string.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <time.h>
#include "mpeg.h"
#include "error.h"
#include "version.h"
#include "configuration.h"
#define SYMBOL(x) mpeg_ ## x

char mpeg_parname[PATH_MAX] = "", mpeg_tmpname[PATH_MAX] = "";
char mpeg_name[PATH_MAX] = "./", mpeg_wavname[PATH_MAX] = "grab.wav";
char mpeg_logname[PATH_MAX] = "/dev/null";
int mpeg_first = 0, mpeg_last = 0, mpeg_lowdisk = 0, mpeg_n = 0;
int mpeg_gopsize = 12, mpeg_type = 1, mpeg_framerate = 3;
int mpeg_bitrate = 1152, mpeg_audio_rate = 128;
int mpeg_width, mpeg_height, mpeg_trace = 0, mpeg_sound = 1;
int mpeg_sound_skip = -1, mpeg_audio_skip = -1, mpeg_ntsc = 0;

int mpeg_samprate, mpeg_running = 0;
FILE *mpeg_pipe, *mpeg_log;
int mpeg_initialized = 0;

START_OPTIONS
STROPTION(wavname);
STROPTION(tmpname) {
	OPTIONSET(ASSERT(!strcmp(value+(strlen(value)-4),".yuv"),(INTMSG("mpeg temp name must end in '.yuv' (%s)"),value)););
}
STROPTION(logname);
STROPTION(name);
INTOPTION(first,0,MAXINT);
INTOPTION(last,0,MAXINT);
INTOPTION(lowdisk,0,1);
INTOPTION(gopsize,0,MAXINT) {
	ASSERT((mpeg_gopsize % 3)==0,(MSG("GOP size must be multiple of 3")));
}
INTOPTION(type,1,2);
INTOPTION(framerate,3,3);
INTOPTION(bitrate,0,MAXINT);
INTOPTION(audio_rate,0,384);
INTOPTION(width,0,1024);
INTOPTION(height,0,768);
INTOPTION(trace,0,1);
INTOPTION(sound,0,1);
INTOPTION(ntsc,0,1);
INTOPTION(audio_skip,-1,MAXINT);
END_OPTIONS

 int (*mpeg_conv_func)(int picnr);
 void (*mpeg_remove_func)(int n);
 void (*mpeg_trace_func)(const char *s);
 void (*mpeg_strace_func)(const char *s);

/************ Prototypes ************/

void mpeg_init();
void mpeg_start();
void mpeg_convert_video();
void mpeg_convert_audio();
void mpeg_multiplex();
void mpeg_wait(int n);
void mpeg_end();

/************************************/


void mpeg_init()
{
	if (mpeg_initialized) return;
	atexit(mpeg_end);
	mpeg_initialized = 1;
}

//#define CONSTRAINED (mpeg_type == 1 && mpeg_width <= 768 && mpeg_height <= 576 && mpeg_bitrate <= 1856000)
#define CONSTRAINED 0

void mpeg_start()
{
	int fd;
	FILE *par;
	time_t t;
	char tmp[PATH_MAX];
	struct sigaction old;


	SAFE_FOPEN(mpeg_log,mpeg_logname,"w");

	sigaction(SIGCLD,NULL,&old);
	signal(SIGCLD,SIG_IGN);
	mpeg_running = 1;

	ASSERT(mpeg_first >= 0,(MSG("start frame must be >= 0")));
	ASSERT(mpeg_last > 0,(MSG("mpeg output needs grablog or -l option")));
	ASSERT(mpeg_last > mpeg_first,(MSG("frame count must be > 0")));

	if (mpeg_name[strlen(mpeg_name)-1] == '/') strcat(mpeg_name,"output.mpg");

	if (mpeg_sound) {
		SAFE_FOPEN(par,mpeg_wavname,"r");
		do {
			if (fgetc(par) != 'f') continue;
			if (fgetc(par) != 'm') continue;
			if (fgetc(par) != 't') continue;
			if (fgetc(par) != ' ') continue;
			fseek(par,8,SEEK_CUR);
			SAFE_FREAD(&mpeg_samprate,4,par,mpeg_wavname);
			break;
		} while (1);
		SAFE_FCLOSE(par,mpeg_wavname);
		if (mpeg_audio_skip == -1) mpeg_sound_skip = mpeg_first*mpeg_samprate/25;
	}

	// parameter file creation
	do {
		tmpnam(mpeg_parname);
		fd = open(mpeg_parname,O_CREAT|O_WRONLY|O_EXCL,0600);
	} while (fd == -1 && errno == EEXIST);
	ASSERT(fd != -1,OPENMSG(mpeg_parname));

	NOTNULL(par = fdopen(fd,"w"),OPENMSG(mpeg_parname));

	time(&t);
	strcpy(tmp,mpeg_tmpname);
	tmp[strlen(tmp)-4] = 0;

	if (mpeg_ntsc) {
		mpeg_gopsize = 15;
		mpeg_framerate = 5;
	}

	fprintf(par,"Created by bttvgrab " VERSION " on %s",ctime(&t));
	fprintf(par,"%s\n",tmp);
	fprintf(par,"-\n");
	fprintf(par,"-\n");
	fprintf(par,"-\n");
	fprintf(par,"/dev/null\n");
	fprintf(par,"1\n");
	fprintf(par,"%i\n",mpeg_last-mpeg_first+1);
	fprintf(par,"%i\n",mpeg_first);
	fprintf(par,"00:00:00:00\n");
	fprintf(par,"%i\n",mpeg_gopsize);
	fprintf(par,"3\n");
	fprintf(par,"%i\n",2-mpeg_type);
	fprintf(par,"1\n");
	fprintf(par,"%i\n",mpeg_width);
	fprintf(par,"%i\n",mpeg_height);
	fprintf(par,"1\n");
	fprintf(par,"%i\n",mpeg_framerate);
	fprintf(par,"%i000.0\n",mpeg_bitrate);
	if (CONSTRAINED) fprintf(par,"20\n"); else fprintf(par,"112\n");
	fprintf(par,"0\n");
	if (CONSTRAINED) fprintf(par,"1\n"); else fprintf(par,"0\n");
	fprintf(par,"4\n");
	fprintf(par,"8\n");
	fprintf(par,"0\n");
	fprintf(par,"1\n");
	fprintf(par,"%i\n",1+mpeg_ntsc);
	fprintf(par,"5\n");
	fprintf(par,"5\n");
	fprintf(par,"5\n");
	fprintf(par,"%i\n",mpeg_width);
	fprintf(par,"%i\n",mpeg_height);
	fprintf(par,"0\n");
	fprintf(par,"0\n");
	fprintf(par,"0 0 0\n");
	fprintf(par,"0 0 0\n");
	fprintf(par,"1 1 1\n");
	if (mpeg_type == 1) fprintf(par,"0 0 0\n"); else fprintf(par,"1 0 0\n");
	fprintf(par,"1 1 1\n");
	fprintf(par,"0\n");
	fprintf(par,"0\n");
	fprintf(par,"0\n");
	fprintf(par,"0\n");
	fprintf(par,"0\n");
	fprintf(par,"0\n");
	fprintf(par,"0\n");
	fprintf(par,"0\n");
	fprintf(par,"0\n");
	fprintf(par,"0\n");
	fprintf(par,"0\n");
	fprintf(par,"2 2 11 11\n");
	fprintf(par,"1 1 3 3\n");
	fprintf(par,"1 1 7 7\n");
	fprintf(par,"1 1 7 7\n");
	fprintf(par,"1 1 3 3\n");

	SAFE_FCLOSE(par,mpeg_parname);

	
	if (mpeg_sound) {
		mpeg_convert_audio();
		if (mpeg_lowdisk) {
			unlink(mpeg_wavname);
		}
	}

	mpeg_convert_video();
	
	if (mpeg_sound) mpeg_multiplex();

	mpeg_stop();
	mpeg_running = 0;
	sigaction(SIGCLD,&old,NULL);
}

void mpeg_convert_video()
{
	char tmpnam[PATH_MAX];
	int i;
	mpeg_n = mpeg_first;

	(*mpeg_trace_func)(" ");
	for (i = 0; i < 10; i++) {
		(*mpeg_conv_func)(mpeg_n);
		mpeg_n++;
	}

	if (mpeg_sound) sprintf(tmpnam,"mpeg2encode %s %s-video 2>&1",mpeg_parname,mpeg_name);
	else sprintf(tmpnam,"mpeg2encode %s %s 2>&1",mpeg_parname,mpeg_name);
	NOTNULL(mpeg_pipe = popen(tmpnam,"r"),(ERRMSG("popen")));

mpeg_loop:

	if ((mpeg_n <= mpeg_last) && (*mpeg_conv_func)(mpeg_n)) {
		if (mpeg_sound) sprintf(tmpnam,"%s-video frame %i",mpeg_name,mpeg_n-10-mpeg_first);
		else sprintf(tmpnam,"%s frame %i",mpeg_name,mpeg_n-10-mpeg_first);
		(*mpeg_trace_func)(tmpnam);
		mpeg_wait(mpeg_n-10-mpeg_first);
		(*mpeg_remove_func)(mpeg_n-11);
	} else {
		for (i = 10; i > 0; i--) {
			mpeg_wait(mpeg_n-i-mpeg_first);
			if (mpeg_sound) sprintf(tmpnam,"%s-video frame %i",mpeg_name,mpeg_n-i-mpeg_first);
			else sprintf(tmpnam,"%s frame %i",mpeg_name,mpeg_n-i-mpeg_first);
			(*mpeg_trace_func)(tmpnam);
		}
		while ((i = fgetc(mpeg_pipe)) != EOF) fputc(i,mpeg_log);
		pclose(mpeg_pipe);
		mpeg_pipe = NULL;
		if (mpeg_sound) sprintf(tmpnam,"%s-video frame %i",mpeg_name,mpeg_last);
		else sprintf(tmpnam,"%s frame %i",mpeg_name,mpeg_last);
		memset(tmpnam,' ',strlen(tmpnam));
		(*mpeg_trace_func)(tmpnam);
		return;
	}
	
	mpeg_n++;

	goto mpeg_loop;
}

void mpeg_convert_audio()
{
	char tmpnam[PATH_MAX];
	int c, frames;
	frames = ((((mpeg_last - mpeg_first + 1)/25) * (mpeg_audio_rate*1000/8)) /
		((int)((1152.0 / ((double)mpeg_samprate / 1000.0)) * ((double)mpeg_audio_rate / 8.0))));

        sprintf(tmpnam,"bttvmusicin -x %i -n %i -b %i %s %s-audio 2>&1",
		mpeg_sound_skip,
		(mpeg_last-mpeg_first+1)*mpeg_samprate/25,
		mpeg_audio_rate,
		mpeg_wavname,
		mpeg_name);
	mpeg_pipe = popen(tmpnam,"r");
	sprintf(tmpnam,"%s",mpeg_wavname);
	(*mpeg_strace_func)(tmpnam);

	while ((c = fgetc(mpeg_pipe)) != '{' && !feof(mpeg_pipe)) fputc(c,mpeg_log);
	if (feof(mpeg_pipe)) exit(1);
	fscanf(mpeg_pipe,"%i}",&c);
	fprintf(mpeg_log,"{%4d}",c);
	sprintf(tmpnam,"%s-audio (%i %%)",mpeg_name,c*100/frames);
	(*mpeg_trace_func)(tmpnam);
	while ((c = fgetc(mpeg_pipe)) != '{' && !feof(mpeg_pipe)) fputc(c,mpeg_log);
	if (feof(mpeg_pipe)) exit(1);
	fscanf(mpeg_pipe,"%i}",&c);
	fprintf(mpeg_log,"{%4d}",c);
	sprintf(tmpnam,"%s-audio (%i %%)",mpeg_name,c*100/frames);
	(*mpeg_trace_func)(tmpnam);

	while ((c = fgetc(mpeg_pipe) == '{')) {
		fscanf(mpeg_pipe,"%i}",&c);
		fprintf(mpeg_log,"{%4d}",c);
		sprintf(tmpnam,"%s-audio (%i %%)",mpeg_name,c*100/frames);
		(*mpeg_trace_func)(tmpnam);
	}

	fputc('\n',mpeg_log);
	while ((c = fgetc(mpeg_pipe)) != EOF) fputc(c,mpeg_log);
	pclose(mpeg_pipe);
	mpeg_pipe = NULL;

	memset(tmpnam,' ',strlen(tmpnam));
	(*mpeg_trace_func)(tmpnam);
	sprintf(tmpnam,"%s",mpeg_wavname);
	memset(tmpnam,' ',strlen(tmpnam));
	(*mpeg_strace_func)(tmpnam);
}

void mpeg_multiplex()
{
	char tmpnam[PATH_MAX];
	char progress[4] = "/|\\-";
	int p = 0, c;

        sprintf(tmpnam,"bttvsystem_encode -o %s %s-video 0 %s-audio 0 2>&1",mpeg_name,mpeg_name,mpeg_name);
	mpeg_pipe = popen(tmpnam,"r");

	sprintf(tmpnam,"%s-video, %s-audio",mpeg_name, mpeg_name);
	(*mpeg_strace_func)(tmpnam);

	while ((c = fgetc(mpeg_pipe)) != EOF) {
		if (c == '\r') {
			sprintf(tmpnam,"%s %c",mpeg_name, progress[p]);
			(*mpeg_trace_func)(tmpnam);
			p = (p+1) & 3;
			fputc('\n',mpeg_log);
		} else {
			fputc(c,mpeg_log);
		}
	}
}


void mpeg_wait(int n)
{
	int i, c;

	do {
		do {
			do {
				c = getc(mpeg_pipe);
				fputc(c,mpeg_log);
			} while (c != '\n');
		} while (fscanf(mpeg_pipe,"Encoding frame %i .",&i) == 0);
		fprintf(mpeg_log,"Encoding frame %i(%i) .",i,n);
	} while (i < n);
}

void mpeg_stop()
{
	char tmpnam[PATH_MAX];
	int i;

	if (!mpeg_running) return;
	unlink(mpeg_parname);
	for (i = -1; i < 12; i++) {
		(*mpeg_remove_func)(mpeg_n-i);
	}
	sprintf(tmpnam,"%s-audio",mpeg_name);
	unlink(tmpnam);
	sprintf(tmpnam,"%s-video",mpeg_name);
	unlink(tmpnam);
}

void mpeg_end()
{
	mpeg_stop();
}
