/* 
   bttvgrab 0.15.0 [1999-01-18]
   (c) 1998, 1999 by Joerg Walter <trouble@moes.pmnet.uni-oldenburg.de>
   Maintained by: Joerg Walter
   Current version at http://moes.pmnet.uni-oldenburg.de/bttvgrab/

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>
#include <fcntl.h>
#include <sys/time.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/keysym.h>
#include <X11/Xatom.h>
#include <unistd.h>
#include <limits.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <X11/extensions/XShm.h>

#define TRANSPORT_INTERNAL
#include "output_X.h"
#include "version.h"
#include "error.h"

/************ Prototypes ************/

int output_X_error(Display * d, XErrorEvent * xeev);
int output_X_ioerror(Display *d);
void output_X_handle();
void output_X_start();
void output_X_stop(void);
void output_X_write(int fbnr, int picnr);
void output_X_abort(int x);

/************************************/

#define OUTPUT_X_EVENTMASK (KeyPressMask)

char *output_X_buffer = NULL;
XShmSegmentInfo output_X_shminfo;
Display *output_X_disp = NULL;
Window output_X_win = 0;
XImage *output_X_ximage = NULL;
GC output_X_gc = 0;
int output_X_errorcnt = 0;
int output_X_noerr = 0;
Colormap output_X_colormap = 0;
static Atom output_X_WM_PROTOCOLS = 0, output_X_WM_DELETE_WINDOW = 0;

int output_X_error(Display * d, XErrorEvent * xeev)
{
	output_X_errorcnt++;
	return 0;
}

int output_X_ioerror(Display *d)
{
	if (!output_X_noerr) {
		ERROR(MSG("fatal X Windows error"));
		END(1);
	}
	return 0;
}

void output_X_handle()
{
	XEvent xev;
	KeySym keysym;

	while (XCheckWindowEvent(output_X_disp, output_X_win, OUTPUT_X_EVENTMASK, &xev)) {
		switch (xev.type) {
		case KeyPress:
			keysym = XKeycodeToKeysym(output_X_disp, xev.xkey.keycode, 0);
			if (keysym == XK_Q || keysym == XK_q) {
				ERROR(NOERR("user abort"));
				END(0);
			}
			break;

		case ClientMessage:
			if (xev.xclient.message_type == output_X_WM_PROTOCOLS && xev.xclient.data.l[0] == output_X_WM_DELETE_WINDOW) {
				ERROR(NOERR("user abort"));
				END(0);
			}
			break;

		default:
			break;

		}
	} 
}


void output_X_start()
{
	static XGCValues values;
	XSizeHints hints;
	XWMHints wmhints;
	XTextProperty windowName, iconName;
	Window root;
	int screen_num;
	int depth;
	static XColor palette[256];

	int i = 0, r, g, b;
	int tg[9] = {0,32,64,96,128,160,192,224,255};
	int trb[5] = {0,64,128,192,255};
	char *name = "bttvgrab " VERSION;

	output_X_shminfo.shmaddr = 0;
	output_X_shminfo.shmid = -1;

	ASSERT(signal(SIGPIPE,output_X_abort) != SIG_ERR,(ERRMSG("signal")));

	ASSERT((output_X_disp = XOpenDisplay(NULL)),(MSG("open display failed\n")));

	output_X_noerr = 0;
	output_X_errorcnt = 0;
	XSetErrorHandler(output_X_error);
	XSetIOErrorHandler(output_X_ioerror);
	
	screen_num = DefaultScreen(output_X_disp);
	
	root = DefaultRootWindow(output_X_disp);
	
	output_X_win = XCreateSimpleWindow(output_X_disp, root, 0, 0, output_width, output_height, 0,
					   XWhitePixel(output_X_disp,screen_num), XBlackPixel(output_X_disp,screen_num));
	ASSERT(output_X_win,(MSG("create window failed\n")));
	
	hints.flags = PSize|PMaxSize|PMinSize;
	hints.min_width = hints.max_width = hints.width = output_width;
	hints.min_height = hints.max_height = hints.height = output_height;
	wmhints.input = True;
	wmhints.flags = InputHint;
	
	XStringListToTextProperty(&name, 1 ,&windowName);
	XStringListToTextProperty(&name, 1 ,&iconName);

	XSetWMProperties(output_X_disp, output_X_win, &windowName, &iconName, NULL, 0, &hints, &wmhints, NULL);
	
	output_X_WM_DELETE_WINDOW = XInternAtom(output_X_disp, "WM_DELETE_WINDOW", False);
	output_X_WM_PROTOCOLS = XInternAtom(output_X_disp, "WM_PROTOCOLS", False);
	XSetWMProtocols(output_X_disp, output_X_win, &output_X_WM_DELETE_WINDOW, 1);

	XSelectInput(output_X_disp, output_X_win, OUTPUT_X_EVENTMASK);

	XMapRaised(output_X_disp, output_X_win);
	
	output_X_gc = XCreateGC(output_X_disp, output_X_win, 0, &values);
	
	XSync(output_X_disp, 0);
	
	depth = DefaultDepthOfScreen(DefaultScreenOfDisplay(output_X_disp));

	output_X_ximage = XShmCreateImage(output_X_disp, DefaultVisual(output_X_disp, screen_num), 
					  depth, ZPixmap, NULL, &output_X_shminfo, output_width, output_height);
	ASSERT(output_X_ximage,(MSG("CreateImage Failed\n")));

	output_X_shminfo.shmid = shmget(IPC_PRIVATE, output_X_ximage->bytes_per_line*output_X_ximage->height, IPC_CREAT|0777);
	ASSERT(output_X_shminfo.shmid >= 0,(ERRMSG("shmget failed")));
	output_X_buffer = output_X_ximage->data = output_X_shminfo.shmaddr = shmat(output_X_shminfo.shmid, 0, 0);
	
	XShmAttach(output_X_disp, &output_X_shminfo);
	
	XSync(output_X_disp, 0);
	
	if (output_X_errorcnt) {
		fprintf(stderr, "Shared memory unavailable, using regular images\n");
		shmdt(output_X_shminfo.shmaddr);
		output_X_shminfo.shmaddr = 0;
		
		SAFE_MALLOC(output_X_buffer,((depth + 7) / 8) * output_width * output_height);
		output_X_ximage = XCreateImage(output_X_disp, DefaultVisual(output_X_disp, screen_num), 
					       depth, ZPixmap, 0, output_X_buffer, output_width, output_height, depth,
					       output_width * ((depth + 7) / 8));
		ASSERT(output_X_ximage,(MSG("CreateImage Failed\n")));
	}
  
	if(depth == 8) {
		output_X_colormap = XCreateColormap(output_X_disp, DefaultRootWindow(output_X_disp), DefaultVisual(output_X_disp, screen_num), AllocAll);
		for (g=0; g<9; g++) for (r=0; r<5; r++) for (b=0;b<5;b++) {
			palette[i].pixel=i;
			palette[i].red = trb[r]*256;
			palette[i].green = tg[g]*256;;
			palette[i].blue = trb[b]*256;
			palette[i].flags=DoRed|DoGreen|DoBlue;
			i++;
		}
		XStoreColors(output_X_disp, output_X_colormap, palette, 256);
		XSetWindowColormap(output_X_disp, output_X_win, output_X_colormap);
	}
	XFlush(output_X_disp);
}

void output_X_stop(void)
{
	output_X_noerr = 1;
	if (output_X_colormap) {
		XFreeColormap(output_X_disp,output_X_colormap);
		output_X_colormap = 0;
	}
	if (output_X_ximage) XDestroyImage(output_X_ximage);
	if (output_X_shminfo.shmid >= 0) {
		XShmDetach(output_X_disp, &output_X_shminfo);
		if (output_X_shminfo.shmaddr) {
			shmdt(output_X_shminfo.shmaddr);
			output_X_buffer = NULL;
		}
		shmctl(output_X_shminfo.shmid, IPC_RMID, 0);
		output_X_shminfo.shmid = -1;
	}
	if (output_X_buffer) {
		SAFE_FREE(output_X_buffer);
		output_X_buffer = NULL;
	}

	if (output_X_win) {
		XEvent xev;
		if (output_X_gc) {
			XFreeGC(output_X_disp, output_X_gc);
			output_X_gc = 0;	
		}
		XUnmapWindow(output_X_disp,output_X_win);
		XFlush(output_X_disp);
		while (XCheckWindowEvent(output_X_disp, output_X_win, OUTPUT_X_EVENTMASK, &xev));
		XDestroyWindow(output_X_disp,output_X_win);
		output_X_win = 0;
	}
	if (output_X_colormap) {
		XFreeColormap(output_X_disp,output_X_colormap);
		output_X_colormap = 0;
	}
	if (output_X_disp && transport_parent == getpid()) {
		XCloseDisplay(output_X_disp);
		output_X_disp = NULL;
	}
}
   
void output_X_write(int fbnr, int picnr)
{
	char msg[80];
	memcpy(output_X_buffer,output_ptrs[fbnr][0],output_bytes);
	sprintf(msg,"displaying frame [%i]",picnr-1);
	(*transport_otrace)(msg);

	if (output_X_shminfo.shmaddr) XShmPutImage(output_X_disp, output_X_win, output_X_gc, output_X_ximage, 0, 0, 0, 0, output_width, output_height, False);
	else XPutImage(output_X_disp, output_X_win, output_X_gc, output_X_ximage,  0, 0, 0, 0, output_width, output_height);

	XFlush(output_X_disp);
	output_X_handle();
}

void output_X_abort(int x)
{
}

