/* 
   bttvgrab 0.15.0 [1999-01-18]
   (c) 1998, 1999 by Joerg Walter <trouble@moes.pmnet.uni-oldenburg.de>
   Maintained by: Joerg Walter
   Current version at http://moes.pmnet.uni-oldenburg.de/bttvgrab/

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include <unistd.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <limits.h>
#include <gif_lib.h>
#include "output_gif.h"
#include "error.h"

ColorMapObject *output_gif_map = NULL;

/************ Prototypes ************/

void output_gif_start();
void output_gif_write(int fbnr, int picnr);
void output_gif_stop();

/************************************/

void output_gif_start()
{
	int tg[9] = {0,32,64,96,128,160,192,224,255};
	int trb[5] = {0,64,128,192,255};
	int i = 16, r, g, b;

	if (!output_gif_map) {
		NOTNULL(output_gif_map = MakeMapObject(256,NULL),(ERRMSG("gif init")));
		for (g=0; g<9; g++) for (r=0; r<5; r++) for (b=0;b<5;b++) {
			output_gif_map->Colors[i].Red = trb[r];
			output_gif_map->Colors[i].Green = tg[g];
			output_gif_map->Colors[i].Blue = trb[b];
			i++;
		}
	}

	transport_wstart("gif",output_width,output_height,1);
}

void output_gif_write(int fbnr, int picnr)
{
	GifFileType *gif;
	int fh;

	fh = transport_wframe(picnr);
	NOTNULL(gif = EGifOpenFileHandle(fh),(ERRMSG("EGifOpenFileHandle")));
	ASSERT(EGifPutScreenDesc(gif,output_width,output_height,256,0,output_gif_map) == GIF_OK,
	       (ERRMSG("EGifPutScreenDesc")));
	ASSERT(EGifPutImageDesc(gif,0,0,output_width,output_height,0,output_gif_map) == GIF_OK,
	       (ERRMSG("EGifPutImageDesc")));
	ASSERT(EGifPutLine(gif,output_ptrs[fbnr][0],output_width*output_height) == GIF_OK,
	       (ERRMSG("EGifPutLine")));
	ASSERT(EGifCloseFile(gif) == GIF_OK,(ERRMSG("EGifCloseFile")));
}

void output_gif_stop()
{
	if (output_gif_map) {
		FreeMapObject(output_gif_map);
		output_gif_map = NULL;
	}
}
