/* 
   bttvgrab 0.15.0 [1999-01-18]
   (c) 1998, 1999 by Joerg Walter <trouble@moes.pmnet.uni-oldenburg.de>
   Maintained by: Joerg Walter
   Current version at http://moes.pmnet.uni-oldenburg.de/bttvgrab/

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include <unistd.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <limits.h>
#include <jpeglib.h>
#include <errno.h>
#include "output_jpg.h"
#include "error.h"

#define OUTPUT_JPG_BUFSIZE 1

struct output_jpg_dest {
	struct jpeg_destination_mgr dest;
	JOCTET buffer[OUTPUT_JPG_BUFSIZE];
} output_jpg_destmgr;
struct jpeg_compress_struct output_jpg_cinfo;
struct jpeg_error_mgr output_jpg_jerr;
unsigned char *output_jpg_y = NULL, *output_jpg_cr = NULL, *output_jpg_cb = NULL;
unsigned char **output_jpg_ptrs[3] = {NULL,NULL,NULL}, **output_jpg_bptrs[3] = {NULL,NULL,NULL};
int output_jpg_y_padwidth, output_jpg_c_padwidth, output_jpg_y_padheight, output_jpg_c_padheight, output_jpg_pad;

/************ Prototypes ************/

void output_jpg_common_start();
void output_jpg8_start();
void output_jpg_start();
void output_jpg8_stop();
void output_jpg_stop();
void output_jpg8_write(int fbnr, int picnr);
void output_jpg_write(int fbnr, int picnr);
void output_jpg_dest_init(struct jpeg_compress_struct *cinfo);
boolean output_jpg_dest_flush(struct jpeg_compress_struct *cinfo);
void output_jpg_dest_term(struct jpeg_compress_struct *cinfo);

/************************************/

void output_jpg_common_start()
{
	memset(&output_jpg_cinfo,0,sizeof(output_jpg_cinfo));
	memset(&output_jpg_jerr,0,sizeof(output_jpg_jerr));
	output_jpg_cinfo.err = jpeg_std_error(&output_jpg_jerr);
	jpeg_create_compress(&output_jpg_cinfo);
	output_jpg_cinfo.image_width = output_width;
	output_jpg_cinfo.image_height = output_height;

	output_jpg_cinfo.dest = (struct jpeg_destination_mgr *)&output_jpg_destmgr;

	((struct output_jpg_dest *)output_jpg_cinfo.dest)->dest.init_destination = output_jpg_dest_init;
	((struct output_jpg_dest *)output_jpg_cinfo.dest)->dest.empty_output_buffer = output_jpg_dest_flush;
	((struct output_jpg_dest *)output_jpg_cinfo.dest)->dest.term_destination = output_jpg_dest_term;;
}

void output_jpg8_start()
{
	int i;

	output_jpg_common_start();

	output_jpg_cinfo.input_components = 1;
	output_jpg_cinfo.in_color_space = JCS_GRAYSCALE;
	jpeg_set_defaults(&output_jpg_cinfo);  
	output_jpg_cinfo.dct_method = output_quality<=100?JDCT_FASTEST:JDCT_ISLOW;
	jpeg_set_quality(&output_jpg_cinfo, output_quality - (output_quality>100?100:0), TRUE);

	output_jpg_cinfo.raw_data_in = TRUE;
	jpeg_set_colorspace(&output_jpg_cinfo,JCS_GRAYSCALE);
	output_jpg_cinfo.comp_info[0].h_samp_factor = 1;
	output_jpg_cinfo.comp_info[0].v_samp_factor = 1;

	output_jpg_y_padwidth = ((int)((output_width+DCTSIZE-1)/DCTSIZE))*DCTSIZE;
	output_jpg_y_padheight = ((int)((output_height+DCTSIZE-1)/DCTSIZE))*DCTSIZE;
	output_jpg_pad = output_jpg_y_padheight;

	SAFE_MALLOC(output_jpg_y,output_jpg_y_padwidth*output_height);
	SAFE_MALLOC(output_jpg_bptrs[0],output_jpg_pad*sizeof(char *));
	output_jpg_ptrs[0] = output_jpg_bptrs[0];

	for (i = 0; i < output_jpg_pad; i++) {
		output_jpg_ptrs[0][i] =
			output_jpg_y+(((i < output_height)?i:(output_height-1))*output_jpg_y_padwidth);
	}

	transport_fwstart("jpg",output_width,output_height,1);
}

void output_jpg_start()
{
	int i;

	output_jpg_common_start();

	output_jpg_cinfo.input_components = 3;
	output_jpg_cinfo.in_color_space = JCS_YCbCr;
	jpeg_set_defaults(&output_jpg_cinfo);  
	output_jpg_cinfo.dct_method = output_quality<=100?JDCT_FASTEST:JDCT_ISLOW;
	jpeg_set_quality(&output_jpg_cinfo, output_quality - (output_quality>100?100:0), TRUE);

	output_jpg_cinfo.raw_data_in = TRUE;
	jpeg_set_colorspace(&output_jpg_cinfo,JCS_YCbCr);
	output_jpg_cinfo.comp_info[0].h_samp_factor = 2;
	output_jpg_cinfo.comp_info[0].v_samp_factor = 2;
	output_jpg_cinfo.comp_info[1].h_samp_factor = 1;
	output_jpg_cinfo.comp_info[1].v_samp_factor = 1;
	output_jpg_cinfo.comp_info[2].h_samp_factor = 1;
	output_jpg_cinfo.comp_info[2].v_samp_factor = 1;

	output_jpg_y_padwidth = ((int)((output_width+DCTSIZE-1)/DCTSIZE))*DCTSIZE;
	output_jpg_c_padwidth = ((int)((output_width+(2*DCTSIZE)-1)/(2*DCTSIZE)))*DCTSIZE;
	output_jpg_y_padheight = ((int)((output_height+DCTSIZE-1)/DCTSIZE))*DCTSIZE;
	output_jpg_c_padheight = ((int)((output_height+(2*DCTSIZE)-1)/(2*DCTSIZE)))*DCTSIZE;
	output_jpg_pad = output_jpg_c_padheight;

	SAFE_MALLOC(output_jpg_y,output_jpg_y_padwidth*output_height);
	SAFE_MALLOC(output_jpg_cr,output_jpg_c_padwidth*((output_height+1)/2));
	SAFE_MALLOC(output_jpg_cb,output_jpg_c_padwidth*((output_height+1)/2));
	SAFE_MALLOC(output_jpg_bptrs[0],2*output_jpg_pad*sizeof(char *));
	SAFE_MALLOC(output_jpg_bptrs[1],output_jpg_pad*sizeof(char *));
	SAFE_MALLOC(output_jpg_bptrs[2],output_jpg_pad*sizeof(char *));
	output_jpg_ptrs[0] = output_jpg_bptrs[0];
	output_jpg_ptrs[1] = output_jpg_bptrs[1];
	output_jpg_ptrs[2] = output_jpg_bptrs[2];

	for (i = 0; i < (2*output_jpg_pad); i++) {
		output_jpg_ptrs[0][i] =
			output_jpg_y+(((i < output_height)?i:(output_height-1))*output_jpg_y_padwidth);
	}
	for (i = 0; i < output_jpg_pad; i++) {
		output_jpg_ptrs[1][i] =
			output_jpg_cb+(((i < ((output_height+1)/2))?i:((output_height+1)/2)-1)*output_jpg_c_padwidth);
	}
	for (i = 0; i < output_jpg_pad; i++) {
		output_jpg_ptrs[2][i] =
			output_jpg_cr+(((i < ((output_height+1)/2))?i:((output_height+1)/2)-1)*output_jpg_c_padwidth);
	}

	transport_fwstart("jpg",output_width,output_height,1);
}

void output_jpg8_stop()
{
	jpeg_destroy_compress(&(output_jpg_cinfo));
	memset(&output_jpg_cinfo,0,sizeof(output_jpg_cinfo));
	memset(&output_jpg_jerr,0,sizeof(output_jpg_jerr));
	SAFE_FREE(output_jpg_y);
	SAFE_FREE(output_jpg_bptrs[0]);
}

void output_jpg_stop()
{
	jpeg_destroy_compress(&(output_jpg_cinfo));
	memset(&output_jpg_cinfo,0,sizeof(output_jpg_cinfo));
	memset(&output_jpg_jerr,0,sizeof(output_jpg_jerr));
	SAFE_FREE(output_jpg_y);
	SAFE_FREE(output_jpg_cb);
	SAFE_FREE(output_jpg_cr);
	SAFE_FREE(output_jpg_bptrs[0]);
	SAFE_FREE(output_jpg_bptrs[1]);
	SAFE_FREE(output_jpg_bptrs[2]);
}

void output_jpg8_write(int fbnr, int picnr)
{
	int j, n;
	unsigned char *src;
	
	transport_fwframe(picnr);

	output_jpg_ptrs[0] = output_jpg_bptrs[0];
	output_jpg_ptrs[1] = output_jpg_bptrs[1];
	output_jpg_ptrs[2] = output_jpg_bptrs[2];

	src = output_ptrs[fbnr][0];
	for (j = 0; j < output_height; j++) {
		memcpy(output_jpg_ptrs[0][j],src,output_width);
		src += output_width;
	}

	jpeg_start_compress(&output_jpg_cinfo, TRUE);
	n = output_jpg_pad/DCTSIZE;
	while (n--) {
		jpeg_write_raw_data(&output_jpg_cinfo, output_jpg_ptrs, DCTSIZE);
		output_jpg_ptrs[0] += DCTSIZE;
	}
	jpeg_finish_compress(&output_jpg_cinfo);
}

void output_jpg_write(int fbnr, int picnr)
{
	int i, j, n;
	unsigned char *src, *dest, *dest1, *dest2;
	
	transport_fwframe(picnr);

	output_jpg_ptrs[0] = output_jpg_bptrs[0];
	output_jpg_ptrs[1] = output_jpg_bptrs[1];
	output_jpg_ptrs[2] = output_jpg_bptrs[2];

	src = output_ptrs[fbnr][0];
	for (j = 0; j < output_height; j++) {
		dest = output_jpg_ptrs[0][j];
		dest1 = output_jpg_ptrs[1][j/2];
		dest2 = output_jpg_ptrs[2][j/2];
		for (i = output_width/2; i; i--) {
			*(dest++) = *(src++);
			*(dest1++)  = *(src++);
			*(dest++) = *(src++);
			*(dest2++) = *(src++);
		}
		j++;
		dest = output_jpg_ptrs[0][j];
		for (i = output_width/2; i; i--) {
			*(dest++) = *(src++);
			src++;
			*(dest++) = *(src++);
			src++;
		}
	}

	jpeg_start_compress(&output_jpg_cinfo, TRUE);
	n = output_jpg_pad/DCTSIZE;
	while (n--) {
		jpeg_write_raw_data(&output_jpg_cinfo, output_jpg_ptrs, 2*DCTSIZE);
		output_jpg_ptrs[0] += 2*DCTSIZE;
		output_jpg_ptrs[1] += DCTSIZE;
		output_jpg_ptrs[2] += DCTSIZE;
	}
	jpeg_finish_compress(&output_jpg_cinfo);
}

void output_jpg_dest_init(struct jpeg_compress_struct *cinfo)
{
  ((struct output_jpg_dest *)cinfo->dest)->dest.next_output_byte = ((struct output_jpg_dest *)cinfo->dest)->buffer;
  ((struct output_jpg_dest *)cinfo->dest)->dest.free_in_buffer = OUTPUT_JPG_BUFSIZE;
}

boolean output_jpg_dest_flush(struct jpeg_compress_struct *cinfo)
{
	transport_write(((struct output_jpg_dest *)cinfo->dest)->buffer, OUTPUT_JPG_BUFSIZE);
	((struct output_jpg_dest *)cinfo->dest)->dest.next_output_byte = ((struct output_jpg_dest *)cinfo->dest)->buffer;
	((struct output_jpg_dest *)cinfo->dest)->dest.free_in_buffer = OUTPUT_JPG_BUFSIZE;

	return TRUE;
}

void output_jpg_dest_term(struct jpeg_compress_struct *cinfo)
{
	output_jpg_dest_flush(cinfo);
}
