/* 
   bttvgrab 0.15.0 [1999-01-18]
   (c) 1998, 1999 by Joerg Walter <trouble@moes.pmnet.uni-oldenburg.de>
   Maintained by: Joerg Walter
   Current version at http://moes.pmnet.uni-oldenburg.de/bttvgrab/

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include <fcntl.h>
#include <stdio.h>
#include <sys/types.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <limits.h>
#include <errno.h>
#include "minilzo.h"
#include "RTjpeg.h"
#include "output_pmm.h"
#include "error.h"
#define SYMBOL(x)

/************ Prototypes ************/

void output_pmm_start();
void output_pmm_jpg_start();
void output_pmm_lzo8_start();
void output_pmm_jpg8_start();
void output_pmm_raw_start();
void output_pmm_write(int fbnr, int picnr);
void output_pmm_jpg_write(int fbnr);
void output_pmm_lzo8_write(int fbnr);
void output_pmm_jpg8_write(int fbnr);
void output_pmm_raw_write(int fbnr);
void output_pmm_stop();
void output_pmm_jpg_stop();
void output_pmm_lzo8_stop();
void output_pmm_jpg8_stop();
void output_pmm_raw_stop();

/************************************/

void (*output_pmm_write_func)(int fbnr);
void (*output_pmm_stop_func)() = NULL;
int output_pmm_q = 10;
int output_pmm_lzo_started = 0;

// RTjpeg stuff
int output_pmm_RTjpegbuf[128];

// lzo stuff
unsigned char *output_pmm_write_buffer = NULL;
unsigned char *output_pmm_work_buffer = NULL;


void output_pmm_start()
{
	char tmp[80];

	transport_fwstart("pmm",output_width,output_height,0);

	transport_write("PMM1",4);
	transport_write_int(420003); // 42=magic number, 2=version

	transport_write_int(output_width);
	transport_write_int(output_height);

	output_inquire("file_fmt str",tmp);
	if (!strcmp(tmp,"pmm-fast")) {
		transport_write_int(PMM_LZO8);
		output_pmm_write_func = output_pmm_lzo8_write;
		output_pmm_stop_func = output_pmm_lzo8_stop;
		output_pmm_lzo8_start();
	} else if (!strcmp(tmp,"pmm-grey")) {
		transport_write_int(PMM_JPG8);
		output_pmm_write_func = output_pmm_jpg8_write;
		output_pmm_stop_func = output_pmm_jpg8_stop;
		output_pmm_jpg8_start();
	} else if (!strcmp(tmp,"pmm-bestgrey")) {
		transport_write_int(PMM_GREY8);
		output_pmm_write_func = output_pmm_raw_write;
		output_pmm_stop_func = output_pmm_raw_stop;
		output_pmm_jpg8_start();
	} else if (!strcmp(tmp,"pmm-good")) {
		transport_write_int(PMM_JPG);
		output_pmm_write_func = output_pmm_jpg_write;
		output_pmm_stop_func = output_pmm_jpg_stop;
		output_pmm_jpg_start();
	} else if (!strcmp(tmp,"pmm-fastest")) {
		transport_write_int(PMM_RAW8);
		output_pmm_write_func = output_pmm_raw_write;
		output_pmm_stop_func = output_pmm_raw_stop;
		output_pmm_raw_start();
	} else if (!strcmp(tmp,"pmm-best")) {
		transport_write_int(PMM_RAWYUV);
		output_pmm_write_func = output_pmm_raw_write;
		output_pmm_stop_func = output_pmm_raw_stop;
		output_pmm_raw_start();
	} else {
		ERROR(INTMSG("invalid pmm type: %s"),tmp);
		exit(1);
	}
}

void output_pmm_jpg_start()
{
	int i;

	SAFE_MALLOC(output_pmm_write_buffer,output_bytes);

	i = ((output_quality-1)%100)+1;
	output_pmm_q = 6/(int)((output_quality/100)+1);
	i = i > 75? 255 : (i >= 50? 128+(127*(i-50)/25):128*i/50);
//	printf("q = %i, %i, %i\n",i,output_quality,output_pmm_q);
	RTjpeg_init_compress(output_pmm_RTjpegbuf,output_width,output_height,i);
	RTjpeg_init_mcompress();
	transport_write(output_pmm_RTjpegbuf,128*sizeof(int));
}

void output_pmm_lzo8_start()
{
	SAFE_MALLOC(output_pmm_write_buffer,output_bytes+output_bytes/64+16+3);

	SAFE_MALLOC(output_pmm_work_buffer,LZO1X_MEM_COMPRESS);

	if (!output_pmm_lzo_started) {
		ASSERT(lzo_init() == LZO_E_OK,(ERRMSG("lzo init")));
		output_pmm_lzo_started = 1;
	}
}

void output_pmm_jpg8_start()
{
	output_pmm_jpg_start();
}

void output_pmm_raw_start()
{
}

void output_pmm_write(int fbnr, int picnr)
{
	transport_fwframe(picnr);
	transport_write_int(picnr);

	(*output_pmm_write_func)(fbnr);
}

void output_pmm_jpg_write(int fbnr)
{
	int n;

	n = RTjpeg_mcompress(output_pmm_write_buffer,output_ptrs[fbnr][0],output_pmm_q,output_pmm_q);
	transport_write_int(n);
	transport_write(output_pmm_write_buffer,n);
}

void output_pmm_lzo8_write(int fbnr)
{
	unsigned int n;

	lzo1x_1_compress(output_ptrs[fbnr][0],output_bytes,output_pmm_write_buffer,&n,output_pmm_work_buffer);
	transport_write_int(n);
	transport_write(output_pmm_write_buffer,n);
}

void output_pmm_jpg8_write(int fbnr)
{	
	int n;
	n = RTjpeg_mcompress8(output_pmm_write_buffer,output_ptrs[fbnr][0],output_pmm_q);
	transport_write_int(n);
	transport_write(output_pmm_write_buffer,n);
}

void output_pmm_raw_write(int fbnr)
{
	transport_write(output_ptrs[fbnr][0],output_bytes);
}

void output_pmm_stop()
{
	if (output_pmm_stop_func) (*output_pmm_stop_func)();
}

void output_pmm_jpg_stop()
{
	SAFE_FREE(output_pmm_write_buffer);

}

void output_pmm_lzo8_stop()
{
	SAFE_FREE(output_pmm_write_buffer);
	SAFE_FREE(output_pmm_work_buffer);
}

void output_pmm_jpg8_stop()
{
	output_pmm_jpg_stop();
}

void output_pmm_raw_stop()
{
}
