/* 
   bttvgrab 0.15.0 [1999-01-18]
   (c) 1998, 1999 by Joerg Walter <trouble@moes.pmnet.uni-oldenburg.de>
   Maintained by: Joerg Walter
   Current version at http://moes.pmnet.uni-oldenburg.de/bttvgrab/

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include <fcntl.h>
#include <stdio.h>
#include <sys/types.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <limits.h>
#include <errno.h>
#include "output_yuv.h"
#include "error.h"

/************ Prototypes ************/

void output_yuv_start();
void output_yuv_write(int fbnr, int picnr);
void output_yuv_stop();

/************************************/

unsigned char *output_yuv_buffer = NULL;

void output_yuv_start()
{
	SAFE_MALLOC(output_yuv_buffer,output_bytes);

	transport_wstart("yuv",output_width,output_height,1);
}

void output_yuv_write(int fbnr, int picnr)
{
	int i, j;
	unsigned char *src, *dest, *dest1, *dest2;

	transport_wframe(picnr);

	src = output_ptrs[fbnr][0];
	dest = output_yuv_buffer;
	dest1 = output_yuv_buffer+output_height*output_width;
	dest2 = output_yuv_buffer+output_height*output_width+(output_width/2)*((output_height+1)/2);
	src = output_ptrs[fbnr][0];
	for (j = 0; j < output_height/2; j++) {
		for (i = output_width/2; i; i--) {
			*(dest++) = *(src++);
			*(dest1++)  = *(src++);
			*(dest++) = *(src++);
			*(dest2++) = *(src++);
		}
		for (i = output_width/2; i; i--) {
			*(dest++) = *(src++);
			src++;
			*(dest++) = *(src++);
			src++;
		}
	}

	if (output_height%2) for (i = output_width/2; i; i--) {
		*(dest++) = *(src++);
		*(dest1++)  = *(src++);
		*(dest++) = *(src++);
		*(dest2++) = *(src++);
	}

	transport_write(output_yuv_buffer,output_bytes);
}

void output_yuv_stop()
{
	SAFE_FREE(output_yuv_buffer);
}
