#!/bin/sh
# bttvgrab 0.15.0 [1999-01-18]
# patch bttv driver for more grab buffers

# ******* Insert you bttv driver directory below ***********
BTTVDIR=no
# **********************************************************

if pushd $BTTVDIR > /dev/null; then
    echo -n "";
else
    echo "Sorry, I don't know where you keep your driver. Please edit patch-driver.sh";
    exit 1;
fi

if [ -z "$1" ]; then
	BUFS=4
else
	BUFS=$1
fi

if [ ! -f bttv.c.old ]; then
	mv bttv.c bttv.c.old
fi
if [ ! -f bttv.h.old ]; then
	mv bttv.h bttv.h.old
fi
sed -e "
s/2\\*BTTV_MAX_FBUF/MAX_GBUFFERS\\*BTTV_MAX_FBUF/
s/BTTV_MAX_FBUF\\*2/BTTV_MAX_FBUF\\*MAX_GBUFFERS/
s/vm.frames=2/vm.frames=MAX_GBUFFERS/
s/mp->frame>1/mp->frame>(MAX_GBUFFERS-1)/
s/if(i>1 || i<0)/if(i>(MAX_GBUFFERS-1) || i<0)/
" bttv.c.old > bttv.c
sed -e "s/\(MAX_GBUFFERS.*\)2$/\1$BUFS/" bttv.h.old > bttv.h
popd > /dev/null
echo "Now cd to $BTTVDIR, become root and do a make, then install the driver"

