/* 
   bttvgrab 0.15.0 [1999-01-18]
   (c) 1998, 1999 by Joerg Walter <trouble@moes.pmnet.uni-oldenburg.de>
   Maintained by: Joerg Walter
   Current version at http://moes.pmnet.uni-oldenburg.de/bttvgrab/

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

// see below for adding new read modules

#include <unistd.h>
#include <values.h>
#include <stdio.h>
#include <stdlib.h>
#include <limits.h>
#include <string.h>
#define READ_INTERNAL
#include "read.h"
#include "error.h"
#include "configuration.h"
#define SYMBOL(x) read_ ## x

int read_width = 640;
int read_height = 480;
int read_file_fmt = 0;
const char *read_color_fmt = "";

unsigned char **read_ptrs[1];
void *read_buf[1] = {NULL};
int read_bytes;

/************ Prototypes ************/

void read_init();
void read_start();
void read_stop();
int read_read(int fbnr, int picnr);
void read_remove(int n);
void read_end();

/************************************/

#define READ_COLORS 8
const int read_color_bpps[READ_COLORS] = {24,8,16,16,-12,8,24,-12};
const char *read_color_names[READ_COLORS] = {"RGB24","PAL8","RGB16","YUV422S","YUV420","GREY8","RGB24S","YUV420P"};

#define ADD_FORMAT(name,symbol) { \
	read_ ## symbol ## _start, \
	read_ ## symbol ## _read, \
	read_ ## symbol ## _stop, \
	#name \
}

struct READ_FORMAT_STRUCT {
	void (*start)();
	int (*read)(int fbnr, int picnr);
	void (*stop)();
	char *name;
};

////////////////////////////////////////////////////////////////////////////////
///////////////////////// read module registration ///////////////////////////
////////////////////////////////////////////////////////////////////////////////

// Step 1: include header file
#include "read_raw.h"
#include "read_pmm.h"
#include "read_pnm.h"

// Step 2: increase number of formats
#define READ_FORMATS 7

// Step 3: fill in structure with ADD_FORMAT
//         supply literal name, symbol name
struct READ_FORMAT_STRUCT read_formats[READ_FORMATS] = {
	ADD_FORMAT(raw24,  raw),
	ADD_FORMAT(raw16,  raw),
	ADD_FORMAT(raw8,   raw),
	ADD_FORMAT(rawyuv, raw),
	ADD_FORMAT(pmm,    pmm),
	ADD_FORMAT(pgm,    pnm),
	ADD_FORMAT(ppm,    pnm)
};

// Step 4: add the new object file to Makefile.in
// Step 5: create the source and header file, see read_raw.c/h for an example

// finished
////////////////////////////////////////////////////////////////////////////////

int (*read_read_func)(int fbnr, int picnr);
void (*read_stop_func)() = NULL;

START_OPTIONS
OPTION(file_fmt nr) {
	OPTIONGET(sprintf(value,"%i",READ_FORMATS););
}
OPTION(file_fmt str) {
	OPTIONSET(int i;
		  for (i = 0; i < READ_FORMATS; i++) {
			  if (!strcmp(read_formats[i].name,value)) {
				  read_file_fmt = i;
				  break;
			  }
		  }
		  ASSERT(i < READ_FORMATS,(MSG("unknown input format '%s'"),value)););
	OPTIONGET(strcpy(value,read_formats[read_file_fmt].name););
}
INTOPTION(file_fmt,0,READ_FORMATS-1);
INTOPTION(width,0,MAXINT);
INTOPTION(height,0,MAXINT);
STRINFO(color_fmt);
OPTION(fbs) {
	OPTIONGET(sprintf(value,"1"););
}
PTRINFO(buf,1);
INTINFO(bytes);
END_OPTIONS

void read_init()
{
	atexit(read_end);
	transport_init();
}

void read_start()
{
	int i, c;
	char tmp[80];

	read_inquire("file_fmt str",tmp);
	transport_rdetect(tmp,&read_width,&read_height);
	read_configure("file_fmt str",tmp);

	read_read_func = read_formats[read_file_fmt].read;
	read_stop_func = read_formats[read_file_fmt].stop;

	(*read_formats[read_file_fmt].start)();

	c = 0;
	for (i = 0; i < READ_COLORS; i++) {
		if (!strcmp(read_color_fmt,read_color_names[i])) {
			c = read_color_bpps[i];
			break;
		}
	}
	ASSERT(c,(INTMSG("unknown color format '%s'"),read_color_fmt));
	if (c > 0) read_bytes = (((read_width * c) + 7) / 8) * read_height;
	else read_bytes = (((read_width * -c) + 7) / 8) * read_height + (read_height%2) * read_width/2;

	SAFE_CALLOC(((void *)read_ptrs[0]),read_height,sizeof(char *));
	SAFE_CALLOC(read_ptrs[0][0],read_bytes+65000,1);

	for (i = 1; i < read_height; i++) {
		read_ptrs[0][i] = read_ptrs[0][0]+(i*read_bytes/read_height);
	}
	read_buf[0] = read_ptrs[0][0];
}

void read_stop()
{
	if (read_stop_func) (*read_stop_func)();
	read_stop_func = NULL;

	transport_rstop();

	if (read_ptrs[0]) {
		SAFE_FREE(read_ptrs[0][0]);
		SAFE_FREE(read_ptrs[0]);
		read_buf[0] = NULL;
	}
}

int read_read(int fbnr, int picnr)
{
	int nr = -1;

	while (nr < picnr) {
		nr = (*read_read_func)(fbnr,picnr);
	}

	if (nr > picnr) return 0;
	return 1;
}

void read_end()
{
	read_stop();
}
