/* 
   bttvgrab 0.15.0 [1999-01-18]
   (c) 1998, 1999 by Joerg Walter <trouble@moes.pmnet.uni-oldenburg.de>
   Maintained by: Joerg Walter
   Current version at http://moes.pmnet.uni-oldenburg.de/bttvgrab/

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include <fcntl.h>
#include <stdio.h>
#include <sys/types.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <limits.h>
#include <errno.h>
#include <jpeglib.h>
#include "minilzo.h"
#include "RTjpeg.h"
#include "read_pmm.h"
#include "error.h"

/************ Prototypes ************/

void read_pmm_start();
void read_pmm_lzo8_start();
void read_pmm_jpg8_start();
void read_pmm_jpg_start();
void read_pmm_raw_start();
int read_pmm_read(int fbnr, int picnr);
void read_pmm_lzo8_read(int fbnr);
void read_pmm_jpg8_read(int fbnr);
void read_pmm_jpg_read(int fbnr);
void read_pmm_raw_read(int fbnr);
void read_pmm_stop();
void read_pmm_lzo8_stop();
void read_pmm_jpg8_stop();
void read_pmm_raw_stop();
void read_pmm_jpg_stop();

/************************************/

int read_pmm_format;
int read_pmm_lzo_init = 0;
void (*read_pmm_read_func)(int fbnr);
void (*read_pmm_stop_func)() = NULL;

// RTjpeg stuff
int read_pmm_RTjpegbuf[128];

// lzo stuff
unsigned char *read_pmm_read_buffer = NULL;
unsigned char *read_pmm_work_buffer = NULL;

void read_pmm_start()
{
	char sig[5] = "XXXX";
	int tmp;

	transport_frstart(0);

	transport_read(sig,4);
	ASSERT(!strcmp(sig,"PMM1"),(MSG("wrong file format")));

	tmp = transport_read_int(); // 42=magic number, 1=version

	ASSERT(tmp > 420000 && tmp < 421000,(MSG("wrong file format")));
	ASSERT(tmp == 420003,(MSG("wrong pmm version: %i"),tmp-420000));

	read_width = transport_read_int();
	read_height = transport_read_int();
	read_pmm_format = transport_read_int();

	if (read_pmm_format == PMM_LZO8) {
		read_pmm_read_func = read_pmm_lzo8_read;
		read_pmm_stop_func = read_pmm_lzo8_stop;
		read_pmm_lzo8_start();
		read_color_fmt = "PAL8";
	} else if (read_pmm_format == PMM_JPG8) {
		read_pmm_read_func = read_pmm_jpg8_read;
		read_pmm_stop_func = read_pmm_jpg8_stop;
		read_pmm_jpg8_start();
		read_color_fmt = "GREY8";
	} else if (read_pmm_format == PMM_GREY8) {
		read_pmm_read_func = read_pmm_raw_read;
		read_pmm_stop_func = read_pmm_raw_stop;
		read_pmm_raw_start();
		read_color_fmt = "GREY8";
	} else if (read_pmm_format == PMM_RAW8) {
		read_pmm_read_func = read_pmm_raw_read;
		read_pmm_stop_func = read_pmm_raw_stop;
		read_pmm_raw_start();
		read_color_fmt = "PAL8";
	} else if (read_pmm_format == PMM_RAWYUV) {
		read_pmm_read_func = read_pmm_raw_read;
		read_pmm_stop_func = read_pmm_raw_stop;
		read_pmm_raw_start();
		read_color_fmt = "YUV422S";
	} else if (read_pmm_format == PMM_JPG) {
		read_pmm_read_func = read_pmm_jpg_read;
		read_pmm_stop_func = read_pmm_jpg_stop;
		read_pmm_jpg_start();
		read_color_fmt = "YUV420P";
	} else {
		ERROR(MSG("unknown pmm subformat"));
		exit(1);
	}
}

void read_pmm_lzo8_start()
{
	SAFE_MALLOC(read_pmm_read_buffer,read_width*read_height+(read_width*read_height)/64+16+3);

	SAFE_MALLOC(read_pmm_work_buffer,LZO1X_MEM_COMPRESS);

	if (!read_pmm_lzo_init) {
		ASSERT(lzo_init() == LZO_E_OK,(ERRMSG("lzo init")));
		read_pmm_lzo_init = 1;
	}
}

void read_pmm_jpg8_start()
{
	read_pmm_jpg_start();
}

void read_pmm_jpg_start()
{
	SAFE_MALLOC(read_pmm_read_buffer,read_width*read_height);
	transport_read(read_pmm_RTjpegbuf,128*sizeof(int));
	RTjpeg_init_decompress(read_pmm_RTjpegbuf,read_width,read_height);
}

void read_pmm_raw_start()
{
}

int read_pmm_read(int fbnr, int picnr)
{
	int n = picnr;

	n = transport_read_int();
	transport_frframe(&n);

	if (n > picnr) {
		transport_unread_int(n);
		transport_unframe();
		return n;
	}

	(*read_pmm_read_func)(fbnr);

	return n;
}

void read_pmm_lzo8_read(int fbnr)
{
	int n, tmp;

	n = transport_read_int();
	transport_read(read_pmm_read_buffer,n);
	tmp = read_bytes;
	if (lzo1x_decompress(read_pmm_read_buffer,n,read_ptrs[fbnr][0],&tmp,read_pmm_work_buffer) != LZO_E_OK) {
		ERROR(ERRMSG("decompression"));
		exit(1);
	}
}

void read_pmm_jpg8_read(int fbnr)
{
	int n;

	n = transport_read_int();
	transport_read(read_pmm_read_buffer,n);
	RTjpeg_decompress8(read_pmm_read_buffer,read_ptrs[0][0]);
	
}

void read_pmm_jpg_read(int fbnr)
{
	int n;

	n = transport_read_int();
	transport_read(read_pmm_read_buffer,n);
	RTjpeg_decompress(read_pmm_read_buffer,read_ptrs[0][0]);

}

void read_pmm_raw_read(int fbnr)
{
	transport_read(read_ptrs[fbnr][0],read_bytes);
}

void read_pmm_stop()
{
	if (read_pmm_stop_func) (*read_pmm_stop_func)();
}

void read_pmm_lzo8_stop()
{
	SAFE_FREE(read_pmm_read_buffer);
	SAFE_FREE(read_pmm_work_buffer);
}

void read_pmm_jpg8_stop()
{
	read_pmm_jpg_stop();
}

void read_pmm_raw_stop()
{
}

void read_pmm_jpg_stop()
{
	SAFE_FREE(read_pmm_read_buffer);
}
