/* 
   bttvgrab 0.15.0 [1999-01-18]
   (c) 1998, 1999 by Joerg Walter <trouble@moes.pmnet.uni-oldenburg.de>
   Maintained by: Joerg Walter
   Current version at http://moes.pmnet.uni-oldenburg.de/bttvgrab/

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include <fcntl.h>
#include <stdio.h>
#include <sys/types.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <limits.h>
#include <errno.h>
#include "read_raw.h"
#include "error.h"

/************ Prototypes ************/

void read_raw_start();
int read_raw_read(int fbnr, int picnr);
void read_raw_stop();

/************************************/


void read_raw_start()
{
	char tmp[PATH_MAX];

	read_inquire("file_fmt str",tmp);
	if (!strcmp(tmp,"raw24")) read_color_fmt = "RGB24S";
	else if (!strcmp(tmp,"raw16")) read_color_fmt = "RGB16";
	else if (!strcmp(tmp,"raw8")) read_color_fmt = "PAL8";
	else if (!strcmp(tmp,"rawyuv")) read_color_fmt = "YUV422S";
	else if (!strcmp(tmp,"rawgrey")) read_color_fmt = "GREY8";
	else {
		ERROR(INTMSG("unknown raw format '%s'"),tmp);
		exit(1);
	}
	transport_rstart(1);
}

int read_raw_read(int fbnr, int picnr)
{
	int n = picnr;

	transport_rframe(&n);
	if (n > picnr) {
		transport_unframe();
		return n;
	}

	transport_read(read_ptrs[fbnr][0],read_bytes);

	return n;
}

void read_raw_stop()
{
}
