/* 
   bttvgrab 0.15.0 [1999-01-18]
   (c) 1998, 1999 by Joerg Walter <trouble@moes.pmnet.uni-oldenburg.de>
   Maintained by: Joerg Walter
   Current version at http://moes.pmnet.uni-oldenburg.de/bttvgrab/

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <limits.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <bytesex.h>
#include <sys/soundcard.h>
#include <sys/ioctl.h>
#include <errno.h>
#include "sound.h"
#include "error.h"
#include "configuration.h"
#define SYMBOL(x) sound_ ## x
#undef ENDFUNC
#define ENDFUNC(n) sound_error(n)

/************ Prototypes ************/

void sound_init();
void sound_start();
void sound_stop();
void sound_error(int n);
void sound_end();

/************************************/

/* byte order stuff */
#if __BYTE_ORDER == 1234
# define cpu_to_le32(x) (x)
# define cpu_to_le16(x) (x)
# define le32_to_cpu(x) (x)
# define le16_to_cpu(x) (x)
#else
#error "byte order currently not supported, perhaps you want to fix it right here?"
#endif
/* other byte orders still missing */



/* ---------------------------------------------------------------------- */
/* *.wav I/O stolen from krecord, which in turn stole from cdda2wav */
/* Copyright (C) by Heiko Eissfeldt */

typedef unsigned char  BYTE;
typedef unsigned short WORD;
typedef unsigned long  DWORD;
typedef unsigned long  FOURCC;	/* a four character code */

/* flags for 'wFormatTag' field of WAVEFORMAT */
#define WAVE_FORMAT_PCM 1

/* MMIO macros */
#define mmioFOURCC(ch0, ch1, ch2, ch3) \
  ((DWORD)(BYTE)(ch0) | ((DWORD)(BYTE)(ch1) << 8) | \
  ((DWORD)(BYTE)(ch2) << 16) | ((DWORD)(BYTE)(ch3) << 24))

#define FOURCC_RIFF	mmioFOURCC ('R', 'I', 'F', 'F')
#define FOURCC_WAVE	mmioFOURCC ('W', 'A', 'V', 'E')
#define FOURCC_FMT	mmioFOURCC ('f', 'm', 't', ' ')
#define FOURCC_DATA	mmioFOURCC ('d', 'a', 't', 'a')

struct CHUNKHDR {
    FOURCC ckid;		/* chunk ID */
    DWORD dwSize; 	        /* chunk size */
};

/* simplified Header for standard WAV files */
struct WAVEHDR {
    struct CHUNKHDR chkRiff;
    FOURCC fccWave;
    struct CHUNKHDR chkFmt;
    WORD wFormatTag;	   /* format type */
    WORD nChannels;	   /* number of channels (i.e. mono, stereo, etc.) */
    DWORD nSamplesPerSec;  /* sample rate */
    DWORD nAvgBytesPerSec; /* for buffer estimation */
    WORD nBlockAlign;	   /* block size of data */
    WORD wBitsPerSample;
    struct CHUNKHDR chkData;
} sound_fileheader;

#define FMT_8BIT       1          /* unsigned */
#define FMT_16BIT      2          /* signed - native byte order */

/* ---------------------------------------------------------------------- */

#define BUFFER_SIZE 0x1000
#define BUFFER_LEN (((int)(BUFFER_SIZE/sound_align))*sound_align)

char sound_device[PATH_MAX] = "/dev/dsp";
char sound_file[PATH_MAX]   = "./grab.wav";
int sound_rate     = 44100;
int sound_bits     = 16;
int sound_channels = 2;

unsigned long sound_align;
int sound_fdsp = 0, sound_fwav = 0, sound_size = 0;
unsigned char sound_buffer[BUFFER_SIZE];
pid_t sound_child = 0, sound_parent = 0;

START_OPTIONS
STROPTION(device);
STROPTION(file);
INTOPTION(rate,4000,48000);
INTOPTION(bits,8,16);
INTOPTION(channels,1,4);
END_OPTIONS

void sound_init()
{
	if (sound_parent) return;
	atexit(sound_end);
	
	sound_fileheader.chkRiff.ckid    = cpu_to_le32(FOURCC_RIFF);
	sound_fileheader.chkRiff.dwSize  = cpu_to_le32(sizeof(struct WAVEHDR) - sizeof(struct CHUNKHDR));
	sound_fileheader.fccWave         = cpu_to_le32(FOURCC_WAVE);
	sound_fileheader.chkFmt.ckid     = cpu_to_le32(FOURCC_FMT);
	sound_fileheader.chkFmt.dwSize   = cpu_to_le32(16);
	sound_fileheader.wFormatTag      = cpu_to_le16(WAVE_FORMAT_PCM);
	sound_fileheader.chkData.ckid    = cpu_to_le32(FOURCC_DATA);
	sound_fileheader.chkData.dwSize  = cpu_to_le32(0);

	sound_parent = getpid();
}

void sound_start()
{
	int tmp;

	if (sound_child) return;
	
	NOTNEG1(sound_child = fork(),(ERRMSG("fork")));
	if (sound_child) return;

	sound_align = sound_channels * ((sound_bits + 7) / 8);
	
	sound_fileheader.nChannels       = cpu_to_le16(sound_channels);
	sound_fileheader.nSamplesPerSec  = cpu_to_le32(sound_rate);
	sound_fileheader.nAvgBytesPerSec = cpu_to_le32(sound_align * sound_rate);
	sound_fileheader.nBlockAlign     = cpu_to_le16(sound_align);
	sound_fileheader.wBitsPerSample  = cpu_to_le16(sound_bits);
	sound_size = 0;

	SAFE_OPEN(sound_fdsp,sound_device,O_RDONLY);

	tmp = AFMT_S16_LE;
	if (sound_bits == 8) tmp = AFMT_U8;
	NOTNEG1(ioctl(sound_fdsp, SNDCTL_DSP_SETFMT, &tmp),(ERRMSG("sound format %i"),tmp));

	NOTNEG1(ioctl(sound_fdsp, SNDCTL_DSP_CHANNELS, &sound_channels),(ERRMSG("%i sound channels"),sound_channels));

	NOTNEG1(ioctl(sound_fdsp, SNDCTL_DSP_SPEED, &sound_rate),(ERRMSG("sampling rate %i"),sound_rate));

	SAFE_CREAT(sound_fwav,sound_file,0666);

	SAFE_WRITE(sound_fwav,&sound_fileheader,sizeof(struct WAVEHDR),sound_file);

loop:

	SAFE_READ(sound_fdsp,sound_buffer,BUFFER_LEN,"sound data");

	SAFE_WRITE(sound_fwav,sound_buffer,BUFFER_LEN,sound_file);

	sound_size += BUFFER_LEN;

	goto loop;
}

void sound_stop()
{
	struct sigaction old;

	if (getpid() == sound_parent) {
		if (sound_child && sound_child != -1) {
			sigaction(SIGCLD,NULL,&old);
			signal(SIGCLD,SIG_IGN);
			kill(sound_child,SIGINT);
			waitpid(sound_child,NULL,0);
			sound_child = 0;
			sigaction(SIGCLD,&old,NULL);
		}
	}
}

void sound_error(int n)
{
	if (getpid() == sound_parent) sound_stop();
	else exit(n);
}

void sound_end()
{
	sound_stop();

	if (!sound_child) {
		if (sound_fdsp > 0) close(sound_fdsp);
		if (sound_fwav > 0) {
			sound_fileheader.chkRiff.dwSize = cpu_to_le32(sound_size + sizeof(struct WAVEHDR) - sizeof(struct CHUNKHDR));
			sound_fileheader.chkData.dwSize = cpu_to_le32(sound_size);
			lseek(sound_fwav,0,SEEK_SET);
			write(sound_fwav,&sound_fileheader,sizeof(struct WAVEHDR));
			close(sound_fwav);
		}
	}
}
