/* 
   bttvgrab 0.15.0 [1999-01-18]
   (c) 1998, 1999 by Joerg Walter <trouble@moes.pmnet.uni-oldenburg.de>
   Maintained by: Joerg Walter
   Current version at http://moes.pmnet.uni-oldenburg.de/bttvgrab/

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef TRANSPORT_H
#define TRANSPORT_H

 extern void (*transport_itrace)(const char *s);
 extern void (*transport_otrace)(const char *s);
void transport_configure(const char *option, const char *value);
void transport_inquire(const char *option, char *value);
void transport_init();
void transport_rdetect(char *format, int *width, int *height);
int transport_rstart(int multi);
int transport_wstart(const char *format, int width, int height, int multi);
void transport_rstop();
void transport_wstop();
void transport_rclose();
void transport_wclose();
void transport_end();
FILE *transport_fwframe(int nr);
FILE *transport_fwstart(const char *format, int width, int height, int multi);
int transport_wframe(int nr);
void transport_write(void *ptr, unsigned long cnt);
FILE *transport_frframe(int *nr);
FILE *transport_frstart(int multi);
int transport_rframe(int *nr);
void transport_read(void *ptr, unsigned long cnt);
void transport_rremove(int nr);
void transport_wremove(int nr);
void transport_write_int(int x);
int transport_read_int();
void transport_unread_int(int n);
void transport_unframe();

#ifdef TRANSPORT_INTERNAL
struct transport_signature {
	unsigned char version;
	char format[80];
	int width;
	int height;
};

void transport_rmkdef();
void transport_wmkdef();

#define TRANSPORT_CURRENT_VERSION ((unsigned char)2)

extern int transport_format;
extern int transport_sync;
extern char transport_rname[PATH_MAX];
extern char transport_wname[PATH_MAX];
extern char transport_rcname[PATH_MAX];
extern char transport_wcname[PATH_MAX];
extern int transport_rfd;
extern int transport_wfd;
extern pid_t transport_parent;
extern int transport_rmulti;
extern int transport_wmulti;
extern struct transport_signature transport_rsig, transport_wsig;

#endif

#endif
