/* 
   bttvgrab 0.15.0 [1999-01-18]
   (c) 1998, 1999 by Joerg Walter <trouble@moes.pmnet.uni-oldenburg.de>
   Maintained by: Joerg Walter
   Current version at http://moes.pmnet.uni-oldenburg.de/bttvgrab/

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <limits.h>
#include "transport_file.h"
#include "error.h"

/************ Prototypes ************/

void transport_file_wstart();
void transport_file_wframe(int nr);
void transport_file_rframe(int *nr);
void transport_file_wstop();
void transport_file_rremove(int n);
void transport_file_wremove(int n);
void transport_file_rdetect();
void transport_file_rstart();
void transport_file_rstop();
void transport_file_unframe();

/************************************/

void transport_file_wstart()
{
	if (transport_wname[strlen(transport_wname)-1] == '/') transport_wmkdef();
	if (!transport_wmulti) {
		SAFE_CREAT(transport_wfd,transport_wname,0666);
	}
}

void transport_file_wframe(int nr)
{
	if (transport_wmulti) {
		SAFE_CREAT(transport_wfd,transport_wcname,0666);
	}
}

void transport_file_rframe(int *nr)
{
	if (transport_rmulti) {
		transport_rfd = open(transport_rcname,O_RDONLY);
		if (transport_rfd == -1) {
			*nr += 1;
			return;
		}
	}
}

void transport_file_wstop()
{
}

void transport_file_rremove(int n)
{
	char tmp[PATH_MAX];
	sprintf(tmp,transport_rname,n);
	unlink(tmp);
}

void transport_file_wremove(int n)
{
	char tmp[PATH_MAX];
	sprintf(tmp,transport_wname,n);
	unlink(tmp);
}


void transport_file_rdetect()
{
}

void transport_file_rstart()
{
	if (transport_rname[strlen(transport_rname)-1] == '/') transport_rmkdef();
	if (!transport_rmulti) {
		SAFE_OPEN(transport_rfd,transport_rname,O_RDONLY);
	}
}

void transport_file_rstop()
{
}

void transport_file_unframe()
{
}
