/* 
   bttvgrab 0.15.0 [1999-01-18]
   (c) 1998, 1999 by Joerg Walter <trouble@moes.pmnet.uni-oldenburg.de>
   Maintained by: Joerg Walter
   Current version at http://moes.pmnet.uni-oldenburg.de/bttvgrab/

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <stdio.h>
#include <stdlib.h>
#include <limits.h>
#include <signal.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include "transport_net.h"
#include "error.h"

/************ Prototypes ************/

void transport_net_wstart();
void transport_net_wframe(int nr);
void transport_net_rframe(int *nr);
void transport_net_wstop();
void transport_net_abort(int x);
void transport_net_rremove(int n);
void transport_net_wremove(int n);
void transport_net_rdetect();
void transport_net_rstart();
void transport_net_rstop();
void transport_net_unframe();

/************************************/

int transport_net_lfd = -1;
int transport_net_unframe_num = 0;
int transport_net_unframe_p = 0;

void transport_net_wstart()
{
	char *portp, *remotep;
	int c;
	int port = 31337;
	struct sockaddr_in net_addr;
	int addr = 0;
	
	transport_wmulti = 0;
	remotep = strchr(transport_wname,'/');
	if (remotep) *remotep = 0;

	portp = strchr(transport_wname,':');
	if (portp) {
		*portp = 0;
		port = atoi(portp+1);
		ASSERT(port > 0 && port < 65536,(MSG("invalid port address: %i"),port));
	}

	/* create what looks like an ordinary UDP socket */
	ASSERT((transport_net_lfd=socket(AF_INET,SOCK_STREAM,0)) >= 0,(ERRMSG("socket")));
	
	/* set up destination address */
	memset(&net_addr,0,sizeof(net_addr));
	net_addr.sin_family=AF_INET;
	if (transport_wname[0] == 0 || (transport_wname[0] == '.' && transport_wname[1] == 0)) net_addr.sin_addr.s_addr = htonl(INADDR_ANY);
	else ASSERT(inet_aton(transport_wname,&net_addr.sin_addr),(MSG("invalid internet address: %s"),transport_wname));
	net_addr.sin_port=htons(port);

	c = 1;
	ASSERT(setsockopt(transport_net_lfd, SOL_SOCKET, SO_REUSEADDR, &c, sizeof(c)) >= 0,(ERRMSG("setsockopt")));

	/* bind to receive address */
	ASSERT(bind(transport_net_lfd,(struct sockaddr *) &net_addr,sizeof(net_addr)) >= 0,(ERRMSG("bind")));
	ASSERT(listen(transport_net_lfd,10) >= 0,(ERRMSG("listen")));

	if (portp) *portp = ':';
	if (remotep) {
		port = 0;
		portp = strchr(remotep+1,':');
		if (portp) {
			*portp = 0;
			port = atoi(portp+1);
			ASSERT(port >= 0 && port < 65536,(MSG("invalid port address: %i"),port));
		}
		if (remotep[1] == 0 || (remotep[1] == '.' && remotep[2] == 0)) addr = htonl(INADDR_ANY);
		else {
			ASSERT(inet_aton(remotep+1,&net_addr.sin_addr),(MSG("invalid internet address: %s"),remotep+1));
			addr = net_addr.sin_addr.s_addr;
		}
		if (portp) *portp = ':';
		*remotep = '/';
	}

	do {
		if (transport_wfd >= 0) {
			SAFE_CLOSE(transport_wfd,"unauthorized connection");
			transport_wfd = -1;
		}
		c = sizeof(net_addr);
		ASSERT((transport_wfd = accept(transport_net_lfd,(struct sockaddr *) &net_addr, &c)) >= 0,(ERRMSG("accept")));
	} while ((addr && net_addr.sin_addr.s_addr != addr) || (port && net_addr.sin_port != port));
	
	ASSERT(signal(SIGPIPE,transport_net_abort) != SIG_ERR,(ERRMSG("signal")));

	c = transport_wsig.width*transport_wsig.height*3;
	ASSERT(setsockopt(transport_wfd, SOL_SOCKET, SO_SNDBUF, &c, sizeof(c)) >= 0,(ERRMSG("setsockopt")));

	ASSERT((c = send(transport_wfd,&transport_wsig,sizeof(transport_wsig),0)) >= 0 ,(ERRMSG("send")));
	ASSERT(c == sizeof(transport_wsig),(MSG("Network error")));
}

void transport_net_wframe(int nr)
{
	transport_write_int(nr);
}

void transport_net_rframe(int *nr)
{
	if (transport_net_unframe_p) {
		transport_net_unframe_p = 0;
		*nr = transport_net_unframe_num;
		return;
	}

	*nr = transport_net_unframe_num = transport_read_int();
}

void transport_net_wstop()
{
	if (transport_net_lfd >= 0) {
		SAFE_CLOSE(transport_net_lfd,transport_wname);
		transport_net_lfd = -1;
	}
}

void transport_net_abort(int x)
{
	ERROR(MSG("Network error (%i)"),x);
	END(x);
}

void transport_net_rremove(int n)
{
}

void transport_net_wremove(int n)
{
}


void transport_net_rdetect()
{
	char *portp;
	struct sockaddr_in net_addr;
	int c;
	int port = 31337;

	transport_rmulti = 0;
	portp = strchr(transport_rname,':');
	if (portp) {
		*portp = 0;
		port = atoi(portp+1);
		ASSERT(port > 0 && port < 65536,(MSG("invalid port address: %i"),port));
	}
	
	ASSERT((transport_rfd=socket(AF_INET,SOCK_STREAM,0)) >= 0,(ERRMSG("socket")));
	
	memset(&net_addr,0,sizeof(net_addr));
	net_addr.sin_family=AF_INET;
	if (transport_rname[0] == 0 || (transport_rname[0] == '.' && transport_rname[1] == '/' && transport_rname[2] == 0)) net_addr.sin_addr.s_addr = htonl(INADDR_ANY);
	else {
		ASSERT(inet_aton(transport_rname,&net_addr.sin_addr),(MSG("invalid internet address: %s"),transport_rname));
	}
	net_addr.sin_port=htons(port);

	ASSERT(connect(transport_rfd,(struct sockaddr *) &net_addr,sizeof(net_addr)) >= 0,(ERRMSG("connect")));

	if (portp) *portp = ':';
	else strcat(transport_rname,":31337");

	ASSERT((c = recv(transport_rfd,&transport_rsig,sizeof(transport_rsig),0)) >= 0,(ERRMSG("recv")));
	ASSERT(c != 0,(MSG("Connection refused (recv)")));
	ASSERT(c == sizeof(transport_rsig),(MSG("network error")));

	c = transport_rsig.width*transport_rsig.height*3;
	ASSERT(setsockopt(transport_rfd, SOL_SOCKET, SO_RCVBUF, &c, sizeof(c)) >= 0,(ERRMSG("setsockopt")));
}

void transport_net_rstart()
{
	transport_rmulti = 0;
}

void transport_net_rstop()
{
}

void transport_net_unframe()
{
	transport_net_unframe_p = 1;
}
