/* 
   bttvgrab 0.15.0 [1999-01-18]
   (c) 1998, 1999 by Joerg Walter <trouble@moes.pmnet.uni-oldenburg.de>
   Maintained by: Joerg Walter
   Current version at http://moes.pmnet.uni-oldenburg.de/bttvgrab/

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include <string.h>
#include <unistd.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <limits.h>
#include "transport_webcam.h"
#include "transport_file.h"
#include "error.h"

/************ Prototypes ************/

void transport_webcam_wstart();
void transport_webcam_wframe(int nr);
void transport_webcam_rframe(int *nr);
void transport_webcam_wstop();
void transport_webcam_rremove(int n);
void transport_webcam_wremove(int n);
void transport_webcam_rdetect();
void transport_webcam_rstart();
void transport_webcam_rstop();
void transport_webcam_unframe();

/************************************/

char transport_webcam_path[PATH_MAX] = "";
char transport_webcam_status[PATH_MAX] = "";
char transport_webcam_status_lock[PATH_MAX] = "";
char transport_webcam_file[PATH_MAX] = "";
char transport_webcam_wname[PATH_MAX] = "";
int transport_webcam_fifo = 0;
int transport_webcam_fifo_lock = 0;

void transport_webcam_wstart()
{
	char tmp[PATH_MAX], *ptr;
	int fh, multi;
	FILE *f;

	ptr = strrchr(transport_wname,'/');
	if (ptr) {
		*ptr = 0;
		strcpy(transport_webcam_path,transport_wname);
		*ptr = '/';
	} else {
		strcpy(transport_webcam_path,".");
	}
	mkdir(transport_webcam_path,0755);

	strcpy(tmp,transport_webcam_path);
	strcat(tmp,"/.htaccess");
	SAFE_FOPEN(f,tmp,"w");
	fprintf(f,"ExpiresActive On\nExpiresByType image/jpeg M1\nExpiresByType image/jpg  M1\n");
	SAFE_FCLOSE(f,tmp);

	strcpy(tmp,transport_webcam_path);
	strcat(tmp,"/format");
	SAFE_CREAT(fh,tmp,0644);
	SAFE_WRITE(fh,transport_wsig.format,strlen(transport_wsig.format),tmp);
	SAFE_CLOSE(fh,tmp);

	strcpy(transport_webcam_status,transport_webcam_path);
	strcat(transport_webcam_status,"/status");
	NOTNEG1(mknod(transport_webcam_status,S_IFIFO|0644,-1),(ERRMSG("mknod %s"),transport_webcam_status));
	SAFE_OPEN(transport_webcam_fifo,transport_webcam_status,O_RDWR);

	strcpy(transport_webcam_status_lock,transport_webcam_path);
	strcat(transport_webcam_status_lock,"/status-lock");
	NOTNEG1(mknod(transport_webcam_status_lock,S_IFIFO|0644,-1),(ERRMSG("mknod %s"),transport_webcam_status_lock));
	SAFE_OPEN(transport_webcam_fifo_lock,transport_webcam_status_lock,O_RDWR);

	multi = transport_wmulti;
	transport_wmulti = 0;
	if (transport_wname[strlen(transport_wname)-1] == '/') transport_wmkdef();
	transport_wmulti = multi;
	strcpy(transport_webcam_wname,transport_wname);

	strcpy(transport_wname,transport_webcam_path);
	strcat(transport_wname,"/image-new");
	strcpy(transport_webcam_file,transport_webcam_path);
	strcat(transport_webcam_file,"/image");
	
	symlink(transport_webcam_file,transport_webcam_wname);
	SAFE_WRITE(transport_webcam_fifo_lock,"\n",1,transport_webcam_status);

	transport_file_wstart();
}

void transport_webcam_wframe(int nr)
{
	char tmp[PATH_MAX];
	rename(transport_wname,transport_webcam_file);
	SAFE_READ(transport_webcam_fifo_lock,tmp,1,transport_webcam_status_lock);
	SAFE_WRITE(transport_webcam_fifo,"\n",1,transport_webcam_status);
	SAFE_READ(transport_webcam_fifo,tmp,1,transport_webcam_status);
	SAFE_WRITE(transport_webcam_fifo_lock,"\n",1,transport_webcam_status_lock);

	transport_file_wframe(nr);
}

void transport_webcam_rframe(int *nr)
{
	transport_file_rframe(nr);
}

void transport_webcam_wstop()
{
	char tmp[PATH_MAX];

	if (!transport_webcam_fifo) return;

	if (transport_parent != getpid()) {
		SAFE_CLOSE(transport_webcam_fifo,transport_webcam_status);
		transport_webcam_fifo = 0;
		SAFE_CLOSE(transport_webcam_fifo_lock,transport_webcam_status_lock);
		transport_webcam_fifo_lock = 0;
		return;
	}
	
	strcpy(tmp,transport_webcam_path);
	strcat(tmp,"/format");
	NOTNEG1(unlink(tmp),(ERRMSG("unlink %s"),tmp));

	SAFE_CLOSE(transport_webcam_fifo,transport_webcam_status);
	transport_webcam_fifo = 0;
	SAFE_CLOSE(transport_webcam_fifo_lock,transport_webcam_status_lock);
	transport_webcam_fifo_lock = 0;
	   
	strcpy(tmp,transport_webcam_path);
	strcat(tmp,"/.htaccess");
	NOTNEG1(unlink(tmp),(ERRMSG("unlink %s"),tmp));
	   
	NOTNEG1(unlink(transport_webcam_wname),(ERRMSG("unlink %s"),transport_webcam_wname));
	   
	NOTNEG1(unlink(transport_webcam_status),(ERRMSG("unlink %s"),transport_webcam_status));
	NOTNEG1(unlink(transport_webcam_status_lock),(ERRMSG("unlink %s"),transport_webcam_status_lock));
	NOTNEG1(unlink(transport_webcam_file),(ERRMSG("unlink %s"),transport_webcam_file));
	unlink(transport_wname);
	   
	rmdir(transport_webcam_path);
	
	transport_file_wstop();
}

void transport_webcam_rremove(int n)
{
	transport_file_rremove(n);
}

void transport_webcam_wremove(int n)
{
}


void transport_webcam_rdetect()
{
	transport_file_rdetect();
}

void transport_webcam_rstart()
{
	transport_file_rstart();
}

void transport_webcam_rstop()
{
	transport_file_rstop();
}

void transport_webcam_unframe()
{
	transport_file_unframe();
}
