/**************************************************************************
* Copyright (c) 1994 The Multimedia Communications Lab, Boston University.
* All rights reserved.
*
* Permission to use, copy, modify, and distribute this software and its
* documentation for any purpose, without fee, and without written agreement is
* hereby granted, provided that the above copyright notice and the following
* two paragraphs appear in all copies of this software.
*
* IN NO EVENT SHALL BOSTON UNIVERSITY BE LIABLE TO ANY PARTY FOR
* DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
* OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF BOSTON
* UNIVERSITY HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*
* BOSTON UNIVERSITY SPECIFICALLY DISCLAIMS ANY WARRANTIES,
* INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
* AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
* ON AN "AS IS" BASIS, AND BOSTON UNIVERSITY HAS NO OBLIGATION TO
* PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
*
**************************************************************************/

/*************************************************************************
*  File Name:     check.c
*  Creation Date: 12 Aug 1994
*  Author:        Ziv Yaar
*                 email  zyaar@bu.edu
*                 Multimedia Communications Lab, Boston University
*                  Professor T.D.C. Little tdcl@flash.bu.edu
*  Usage:         function calls
*
*  Description:   This file holds the function check_param
**************************************************************************/

#include "defines.h"

/*************************************************************************
*  Function:      check_param()
*  Creation Date: 12 Aug 1994
*  Author:        Ziv Yaar
*                 email  zyaar@bu.edu
*                 Multimedia Communications Lab, Boston University
*                  Professor T.D.C. Little tdcl@flash.bu.edu
*  Input:         system_encoder parameters
*
*  Effects:       exits program if any of the parameters are out of range
*
*  Description:   This function takes all the user set parameters of the 
*  program and makes sure that it can generate a legal MPEG system stream,
*  it exits the program otherwise.
**************************************************************************/

void check_param(INT packet_size,INT packets_per_pack,INT pack_size,
		 INT num_video,INT num_audio,
		 unsigned INT bitrate)
{
  unsigned INT packet_total, pack_total;

/* Check bitrate */
  if (bitrate && !pack_size)                   /* if bitrate specified, but  */
  {                                            /* no fixed packet            */
    printf("Constant bitrate requires a fixed pack size\n"); /* print error  */
    exit(1);                                   /* message and exit           */
  }

/* Check packet_size */
  if (packet_size > MAXBUFFER)                 /* if packet_size too large   */
  {
    printf("Packet size too large (> %d)\n",MAXBUFFER); /*print error message*/
    exit(1);                                   /* and exit                   */
  }

  if (packet_size < (MINBUFFER+NUMSTUFFBYTES)) /* if packet_size too small   */
  {
    printf("Packet size too small (< %d)\n",   /* print error message        */
	   MINBUFFER+NUMSTUFFBYTES);
    exit(1);                                   /* and exit                   */
  }

/* Check pack size */

  if (pack_size > MAXPACK)                     /* if pack_size too large     */
  {
    printf("Pack size too large (> %d)\n",     /* print error message        */
	   MAXPACK);
    exit(1);                                   /* and exit                   */
  }

  packet_total = (packet_size*packets_per_pack)+MINPADPACKET; /* calculate   */
                                               /* total space taken by A/V   */
                                               /* packets and padding packet */

  pack_total = 24+((num_audio+num_video+1)*3); /* calculate max pack header= */
                                               /* 24 bytes for pack header & */
                                               /* system header + 3 bytes for*/
                                               /* each A/V stream and 3 bytes*/
                                               /* for the padding stream     */

  if (pack_size < (pack_total+packet_total) && pack_size != 0)
                                               /* if pack_size < min pack    */
  {
    printf("Pack size too small\n");           /* print error message        */
    printf("Minimum pack size for this configuration: %d bytes\n",
	   pack_total+packet_total);
    printf("\nCurrent Parameters\n");
    printf("Pack size         : %d\n",pack_size);
    printf("Packet size       : %d\n",packet_size);
    printf("Packets per pack  : %d\n",packets_per_pack);
    printf("Total Streams Used: %d\n",num_audio+num_video+1);
    printf("(includes padding stream)\n");
    exit(1);                                   /* and exit                   */
  }
}


