/**************************************************************************
* Copyright (c) 1994 The Multimedia Communications Lab, Boston University.
* All rights reserved.
*
* Permission to use, copy, modify, and distribute this software and its
* documentation for any purpose, without fee, and without written agreement is
* hereby granted, provided that the above copyright notice and the following
* two paragraphs appear in all copies of this software.
*
* IN NO EVENT SHALL BOSTON UNIVERSITY BE LIABLE TO ANY PARTY FOR
* DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
* OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF BOSTON
* UNIVERSITY HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*
* BOSTON UNIVERSITY SPECIFICALLY DISCLAIMS ANY WARRANTIES,
* INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
* AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
* ON AN "AS IS" BASIS, AND BOSTON UNIVERSITY HAS NO OBLIGATION TO
* PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
*
**************************************************************************/

/*************************************************************************
*  File Name:     defines.h
*  Creation Date: 12 Aug 1994
*  Author:        Ziv Yaar
*                 email  zyaar@bu.edu
*                 Multimedia Communications Lab, Boston University
*                  Professor T.D.C. Little tdcl@flash.bu.edu
*  Usage:         header file
*
*  Description:   This header file contains most of the customizable #defines 
*  for the MPEG encoder program.
**************************************************************************/

#include <bytesex.h>
#include <endian.h>

/* system specific variables */
#define INT                 int                /* INT must be 32-bits signed */
#define FLOAT               float              /* FLOAT must be 32-bit       */
#define CHAR                char               /* CHAR must be 8-bits signed */
#define SHORT               short              /* SHORT must be 16-bit signed*/
#ifdef LITTLE_ENDIAN
#undef LITTLE_ENDIAN
#endif
#if __BYTE_ORDER == 1234
#define LITTLE_ENDIAN 1                        /* set to 1 if compiling on a */
                                               /* little endian processor    */
                                               /* like Intel '386 '486 etc.  */
#else
#define LITTLE_ENDIAN 0
#endif

/* system_encode special function settings */
#define VERSION             "1.0"              /* define version number      */
#define MAXFILESIZE         255                /* max. name of file, w/path  */
#define PACKETSIZE          2048               /* default packet size        */
#define PACKSIZE            0                  /* default pack size          */
                                               /* 0 means no attempt to keep */
                                               /* target pack size           */
#define PACKETSPERPACK      3                  /* default # of packs/packet  */
#define DEFAULTOUTPUTFILE   "outfile.mpg"      /* default output file name   */
#define MAXVIDEO            16                 /* Max. number video streams  */
#define MAXAUDIO            32                 /* Max. number audio streams  */
#define VIDEOHEADERSIZE     4                  /* 32bit for video header     */
#define AUDIOHEADERSIZE     2                  /* 16bit for audio header     */
#define CLOCKFREQUENCY      90000              /* Clock frequency            */
#define UPDATEPERIOD        10                 /* Number of frames per "."   */
#define MAXPACK             81920              /* Max size of pack           */
#define MAXBUFFER           16384              /* Max size of packet         */
#define MINBUFFER           19                 /* Min size of packet         */
#define NUMSTUFFBYTES       0                  /* no more than 5             */
#define PACKHEADERLENGTH    6                  /* Max length of packet head  */
#define FIXEDFLAG           0                  /* Fixed flag value           */
#define CSPSFLAG            0                  /* CSPS flag value            */
#define SYSTEMVIDEOLOCKFLAG 1                  /* SVL flag value             */
#define SYSTEMAUDIOLOCKFLAG 1                  /* SAL flag value             */
#define RESERVEDBYTE        0xff               /* Structure of reserve byte  */
#define READSIZE            8192               /* Max. read size for lread   */
#define MINPADPACKET        10                 /* min. # of bytes on stuffing*/
                                               /* packet                     */

/* Special #defines for -CDROM */
#define CDPACK              2324               /* CDROM pack size            */
#define CDNUMPACKETS        1                  /* CDROM packets per pack     */
#define CDPACKET            2250               /* CDROM packet size          */
#define CDRATE              174300             /* CDROM bitrate              */

#include <sys/types.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
