/**************************************************************************
* Copyright (c) 1994 The Multimedia Communications Lab, Boston University.
* All rights reserved.
*
* Permission to use, copy, modify, and distribute this software and its
* documentation for any purpose, without fee, and without written agreement is
* hereby granted, provided that the above copyright notice and the following
* two paragraphs appear in all copies of this software.
*
* IN NO EVENT SHALL BOSTON UNIVERSITY BE LIABLE TO ANY PARTY FOR
* DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
* OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF BOSTON
* UNIVERSITY HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*
* BOSTON UNIVERSITY SPECIFICALLY DISCLAIMS ANY WARRANTIES,
* INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
* AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
* ON AN "AS IS" BASIS, AND BOSTON UNIVERSITY HAS NO OBLIGATION TO
* PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
*
**************************************************************************/

/*************************************************************************
*  File Name:     list.h
*  Creation Date: 12 Aug 1994
*  Author:        Ziv Yaar
*                 email  zyaar@bu.edu
*                 Multimedia Communications Lab, Boston University
*                  Professor T.D.C. Little tdcl@flash.bu.edu
*  Usage:         header file
*
*  Description:   This header file contains the data structures for list.c
**************************************************************************/

#include <sys/types.h>
#include "defines.h"

#ifndef NULL
  #define NULL 0 /* linear list header file */
#endif

struct wait_list {
  INT wait_time;
  struct wait_list *next;
};

typedef struct wait_list WAIT_ELEMENT;
typedef WAIT_ELEMENT *WAIT_LINK;

struct sub_list {
  INT offset;
  CHAR frame_type;
  struct sub_list *next;
};

typedef struct sub_list SUB_ELEMENT;
typedef SUB_ELEMENT *SUB_LINK;

struct linked_list {
  INT isvideo;
  INT isfinished;
  INT newframe;
  INT buffer_change;
  CHAR filename[MAXFILESIZE];
  CHAR stream_id;
  FLOAT startime;
  unsigned INT next_frame_time;
  CHAR last_pts[5];
  FLOAT rate;
  FLOAT scsr;                                /* System Clock Stream Rate    */
  unsigned INT no_frames;
  INT max_frame_size;
  INT stream_mux_rate;
  INT framewritten;
  off_t current_offset;
  SUB_LINK offsets;
  WAIT_LINK waits;
  struct linked_list *next;
};

typedef struct linked_list ELEMENT;
typedef ELEMENT *LINK;
