/**************************************************************************
* Copyright (c) 1994 The Multimedia Communications Lab, Boston University.
* All rights reserved.
*
* Permission to use, copy, modify, and distribute this software and its
* documentation for any purpose, without fee, and without written agreement is
* hereby granted, provided that the above copyright notice and the following
* two paragraphs appear in all copies of this software.
*
* IN NO EVENT SHALL BOSTON UNIVERSITY BE LIABLE TO ANY PARTY FOR
* DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
* OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF BOSTON
* UNIVERSITY HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*
* BOSTON UNIVERSITY SPECIFICALLY DISCLAIMS ANY WARRANTIES,
* INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
* AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
* ON AN "AS IS" BASIS, AND BOSTON UNIVERSITY HAS NO OBLIGATION TO
* PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
*
**************************************************************************/

/*************************************************************************
*  File Name:     lread.c
*  Creation Date: 12 Aug 1994
*  Author:        Ziv Yaar
*                 email  zyaar@bu.edu
*                 Multimedia Communications Lab, Boston University
*                  Professor T.D.C. Little tdcl@flash.bu.edu
*  Usage:         function calls
*
*  Description:   This file holds functions to do large reads from disk
*  to memory.
**************************************************************************/

#include <sys/stat.h>
#include "defines.h"

/*************************************************************************
*  Function:      large_read()
*  Creation Date: 12 Aug 1994
*  Author:        Ziv Yaar
*                 email  zyaar@bu.edu
*                 Multimedia Communications Lab, Boston University
*                  Professor T.D.C. Little tdcl@flash.bu.edu
*  Input:         input file, buffer
*
*  Effects:       returns number of bytes read
*
*  Description:   This function reads a large buffer's worth of data from
*  an input file and returns the amount of bytes read
**************************************************************************/

INT large_read(INT input, CHAR *buffer)
{
  INT n;

  if((n = read(input, buffer, READSIZE))<0) /* read READSIZE bytes from input*/
  {
    printf("Error reading input file");     /* on error, print error message */
    exit(1);                                /* and exit                      */
  }

  return n;                                 /* return # bytes read           */
}

/*************************************************************************
*  Function:      update_buffer()
*  Creation Date: 12 Aug 1994
*  Author:        Ziv Yaar
*                 email  zyaar@bu.edu
*                 Multimedia Communications Lab, Boston University
*                  Professor T.D.C. Little tdcl@flash.bu.edu
*  Input:         amount read, buffer size, input file, buffer
*
*  Effects:       none
*
*  Description:   This function checks to see if enough of the buffer has
*  been read to require new data in the buffer, if that is the case, it
*  reads the data into the buffer and resets the amount read.
**************************************************************************/

void update_buffer(size_t *i, size_t *readsize, INT fd, CHAR *readbuffer)
{
  if (*i >= *readsize)                      /* if at end of buffer           */
  {
    *readsize = large_read(fd, readbuffer); /* read into read buffer         */
    *i = 0;                                 /* reset read buffer counter     */
  }

}

/*************************************************************************
*  Function:      read_bytes()
*  Creation Date: 12 Aug 1994
*  Author:        Ziv Yaar
*                 email  zyaar@bu.edu
*                 Multimedia Communications Lab, Boston University
*                  Professor T.D.C. Little tdcl@flash.bu.edu
*  Input:         amount read, buffer size, input file, small buffer,
*                 large buffer, number of bytes to be read
*
*  Effects:       none
*
*  Description:   This function reads a number of bytes from a large buffer
*  into a smaller buffer, keeping track it's position in the large buffer.
*  If during the read, the end of the large buffer is reached, new data
*  is read into the large buffer and the position in the large buffer is
*  reset.
**************************************************************************/

void read_bytes(size_t *i, size_t *readsize, INT fd, CHAR *readbuffer, 
		CHAR *buffer, INT n)
{
  INT j;

  for (j = 0; j < n; j++)
  {
    update_buffer(i,readsize, fd, readbuffer);
    buffer[j] = readbuffer[(*i)++];
  }
}
