/**************************************************************************
* Copyright (c) 1994 The Multimedia Communications Lab, Boston University.
* All rights reserved.
*
* Permission to use, copy, modify, and distribute this software and its
* documentation for any purpose, without fee, and without written agreement is
* hereby granted, provided that the above copyright notice and the following
* two paragraphs appear in all copies of this software.
*
* IN NO EVENT SHALL BOSTON UNIVERSITY BE LIABLE TO ANY PARTY FOR
* DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
* OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF BOSTON
* UNIVERSITY HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*
* BOSTON UNIVERSITY SPECIFICALLY DISCLAIMS ANY WARRANTIES,
* INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
* AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
* ON AN "AS IS" BASIS, AND BOSTON UNIVERSITY HAS NO OBLIGATION TO
* PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
*
**************************************************************************/

/*************************************************************************
*  File Name:     main.c
*  Creation Date: 12 Aug 1994
*  Author:        Ziv Yaar
*                 email  zyaar@bu.edu
*                 Multimedia Communications Lab, Boston University
*                  Professor T.D.C. Little tdcl@flash.bu.edu
*  Usage:         program
*
*  Description:   This file contains the main routine for system_encode
**************************************************************************/

#include "defines.h"
#include <sys/stat.h>
#include <fcntl.h>
#include "list.h"
#include "mta.h"

/* function prototypes */
LINK create_list(void);
LINK parse_list(INT, CHAR **, INT *, INT *, CHAR *, INT *, LINK, 
		unsigned INT *);
LINK check_streams(LINK, INT *, INT *);
void check_param(INT, INT, INT, INT, INT, unsigned INT);
LINK find_offsets(LINK, INT *, INT *);
void print_list(LINK);
MTA_LINK create_mta(void);
void make_mux(CHAR *, INT);
MTA_LINK pick_streams(MTA_LINK, LINK);
MTA_LINK write_pack(MTA_LINK, LINK, INT, CHAR *, INT, INT, INT, INT *,
		    INT *, INT);
void scr_reset(CHAR *);
void stamp_add(CHAR *, unsigned INT);
MTA_LINK write_packet(MTA_LINK, INT, INT, CHAR *, unsigned INT);
MTA_LINK update_mta(MTA_LINK, INT);
void write_pad(INT, INT);
void write_end(INT);

/* system encode main routine */
int main(INT argc, CHAR *argv[])
{
  INT num_audio = 0, num_video = 0;
  INT fd;
  INT isfirst = 1;
  INT i;
  INT max_mux_rate=0, max_buff_size=0;
  INT packet_size=PACKETSIZE;
  INT pack_size=PACKSIZE;
  INT pack_bytes_left;
  INT packets_per_pack=PACKETSPERPACK;
  CHAR output_file[MAXFILESIZE]=DEFAULTOUTPUTFILE;
  LINK system_stream /* , current_node */ ;
  MTA_LINK mta;
  CHAR scr[5]={0x21,0x00,0x01,0x00,0x01};
  CHAR mux_rate[3];
  unsigned INT num_packs = 1;
  unsigned INT bitrate = 0;

  printf("MPEG SYSTEM ENCODER ver. %s\n",VERSION);     /* print version num  */

/* PASS 1 */
  system_stream = create_list();                       /* Create structure to*/
                                                       /* hold stream info.  */

  system_stream = parse_list(argc, argv,               /* Parse args list    */
			     &packet_size,             /* into data struct.  */
			     &pack_size,
			     output_file,
			     &packets_per_pack, 
			     system_stream,
			     &bitrate);

  system_stream = check_streams(system_stream,         /* Get header info    */
				&num_video,            /* from each input    */
				&num_audio);           /* stream.            */

  check_param(packet_size,                             /* Check each encoding*/
	      packets_per_pack,                        /* parameter to make  */
	      pack_size,                               /* sure they are      */
	      num_video,                               /* workable           */
	      num_audio,
	      bitrate);

  system_stream = find_offsets(system_stream,          /* Find frame offsets */
			       &max_mux_rate,          /* for each input     */
			       &max_buff_size);        /* stream.            */

  if(num_video == 0 && num_audio == 0)                 /* if no streams to   */
  {                                                    /* process            */
    printf("No streams to process.\n");                /* print error msg    */
    exit(1);                                           /* and exit           */
  }

  printf("\nResults of PASS 1\n");                     /* print general info */
  printf("# Video Streams : %d\n",num_video);
  printf("# Audio Streams : %d\n",num_audio);
  if (pack_size)
    printf("Fixed Pack Size : %d\n",pack_size);
  if (bitrate)
    printf("Constant bitrate: %u\n",bitrate);
  printf("Packets Per Pack: %d\n",packets_per_pack);
  printf("Packet Size     : %d\n",packet_size);
  printf("Output File     : %s\n",output_file);

  print_list(system_stream);                           /* print indiv. stream*/
                                                       /* info               */

  /* PASS 2 */
  packet_size = packet_size - (18 + NUMSTUFFBYTES);   /* calculate packet_   */
                                                      /* data_byte size      */

  printf("\nPASS 2: Writing %s\n",output_file);           

  if ((fd = creat(output_file,O_TRUNC|S_IRWXU))<0)    /* Create output file */
  {
    printf("Error creating %s\n",output_file);            
    exit(1);
  }

  mta = create_mta();                                  /* Create MTA         */
  make_mux(mux_rate, max_mux_rate);                    /* Calc mux_rate      */
  mta = pick_streams(mta, system_stream);              /* Pick highest       */
                                                       /* priority streams   */

  do
  {
    pack_bytes_left = pack_size;                       /* set p_b_l          */

    mta = write_pack(mta,                              /* write pack header  */
                     system_stream, 
		     fd, 
		     scr, 
		     max_mux_rate,
		     num_audio, 
		     num_video, 
		     &isfirst,
		     &pack_bytes_left,
		     pack_size);

    if(!bitrate)                                       /* if variable bitrate*/
      scr_reset(scr);                                  /* reset SCR          */
    else                                               /* else               */
      stamp_add(scr,(bitrate*pack_size)/CLOCKFREQUENCY); /* update SCR       */

    for (i=0; i < packets_per_pack; i++)               /* write p_p_p packets*/
    {
      mta = write_packet(mta,                          /* write packet       */
			 fd,
			 packet_size,
			 scr,
			 bitrate);

      if(pack_size) pack_bytes_left = 
	pack_bytes_left-(packet_size+(18+NUMSTUFFBYTES)); /* update          */
                                                       /* bytes left in pack */

      mta = update_mta(mta,                            /* update frames and  */
		       packet_size);                   /* streams read       */

      if (mta == NULL)                                 /* if MTA empty get   */
	mta = pick_streams(mta,system_stream);         /* next, highest      */
                                                       /* priority streams   */

      if (mta == NULL)                                 /* if MTA still empty */
	break;                                         /* no more streams    */
                                                       /* left, so break out */
                                                       /* of loop            */
    }

    if(pack_size) write_pad(fd,pack_bytes_left);       /* fill pack with     */
                                                       /* padding bytes      */

    printf("\r%u packs written",num_packs++);          /* update display     */
    fflush(stdout);
  }while (mta != NULL);                                /* loop, while MTA    */
                                                       /* isn't empty        */
  printf("\n");

  write_end(fd);                                       /* write iso_end_code */
                                                      
  close(fd);                                           /* Close output file. */
  printf("\n");                                        /* Print CRLF         */
  return 0;
}

  
