/**************************************************************************
* Copyright (c) 1994 The Multimedia Communications Lab, Boston University.
* All rights reserved.
*
* Permission to use, copy, modify, and distribute this software and its
* documentation for any purpose, without fee, and without written agreement is
* hereby granted, provided that the above copyright notice and the following
* two paragraphs appear in all copies of this software.
*
* IN NO EVENT SHALL BOSTON UNIVERSITY BE LIABLE TO ANY PARTY FOR
* DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
* OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF BOSTON
* UNIVERSITY HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*
* BOSTON UNIVERSITY SPECIFICALLY DISCLAIMS ANY WARRANTIES,
* INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
* AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
* ON AN "AS IS" BASIS, AND BOSTON UNIVERSITY HAS NO OBLIGATION TO
* PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
*
**************************************************************************/

/*************************************************************************
*  File Name:     mta.c
*  Creation Date: 12 Aug 1994
*  Author:        Ziv Yaar
*                 email  zyaar@bu.edu
*                 Multimedia Communications Lab, Boston University
*                  Professor T.D.C. Little tdcl@flash.bu.edu
*  Usage:         function file
*
*  Description:   This file contains the functions that create and control
*  a Multiplex Timing Array
**************************************************************************/

#include <stdlib.h>
#include "list.h"
#include "mta.h"

/*************************************************************************
*  Function:      create_mta()
*  Creation Date: 12 Aug 1994
*  Author:        Ziv Yaar
*                 email  zyaar@bu.edu
*                 Multimedia Communications Lab, Boston University
*                  Professor T.D.C. Little tdcl@flash.bu.edu
*  Input:         none
*
*  Effects:       returns a multiplex timing array (mta) linked list
*
*  Description:   This function initializes an mta linked list, the
*  controlling structure of the priority encoding scheme of the encoder.
**************************************************************************/

MTA_LINK create_mta()
{
  MTA_LINK head;

  head = malloc(sizeof(MTA_ELEMENT));
  head = NULL;
  return head;
}

/*************************************************************************
*  Function:      add_stream()
*  Creation Date: 12 Aug 1994
*  Author:        Ziv Yaar
*                 email  zyaar@bu.edu
*                 Multimedia Communications Lab, Boston University
*                  Professor T.D.C. Little tdcl@flash.bu.edu
*  Input:         mta linked list, streams linked list
*
*  Effects:       returns an update mta linked list
*
*  Description:   This function creates a node in the mta linked list that
*  points to the current stream in the streams linked list.
**************************************************************************/

MTA_LINK add_stream(MTA_LINK mta_head,LINK current_stream)
{
  MTA_LINK new_node;

  new_node = malloc(sizeof(MTA_ELEMENT));
  new_node->stream = current_stream;
  new_node->next = mta_head;
  mta_head = new_node;

  return mta_head;
}

/*************************************************************************
*  Function:      del_mta()
*  Creation Date: 12 Aug 1994
*  Author:        Ziv Yaar
*                 email  zyaar@bu.edu
*                 Multimedia Communications Lab, Boston University
*                  Professor T.D.C. Little tdcl@flash.bu.edu
*  Input:         mta linked list
*
*  Effects:       returns an update mta linked list
*
*  Description:   This function deletes the first node in the mta linked
*  list.
**************************************************************************/

MTA_LINK del_mta(MTA_LINK mta_head)
{
  MTA_LINK temp_ptr;

  temp_ptr = mta_head;
  if(mta_head->next != NULL)
    mta_head = mta_head->next;

  else
    mta_head = NULL;

  free(temp_ptr);
  
  return mta_head;
}
