/**************************************************************************
* Copyright (c) 1994 The Multimedia Communications Lab, Boston University.
* All rights reserved.
*
* Permission to use, copy, modify, and distribute this software and its
* documentation for any purpose, without fee, and without written agreement is
* hereby granted, provided that the above copyright notice and the following
* two paragraphs appear in all copies of this software.
*
* IN NO EVENT SHALL BOSTON UNIVERSITY BE LIABLE TO ANY PARTY FOR
* DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
* OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF BOSTON
* UNIVERSITY HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*
* BOSTON UNIVERSITY SPECIFICALLY DISCLAIMS ANY WARRANTIES,
* INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
* AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
* ON AN "AS IS" BASIS, AND BOSTON UNIVERSITY HAS NO OBLIGATION TO
* PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
*
**************************************************************************/

/*************************************************************************
*  File Name:     pack.h
*  Creation Date: 12 Aug 1994
*  Author:        Ziv Yaar
*                 email  zyaar@bu.edu
*                 Multimedia Communications Lab, Boston University
*                  Professor T.D.C. Little tdcl@flash.bu.edu
*  Usage:         header file
*
*  Description:   This header file contains the data structures for pack.c
**************************************************************************/

#include "defines.h"

#if LITTLE_ENDIAN
  struct data1 {
    unsigned CHAR csps_flag   : 1,
                  fixed_flag  : 1,
                  audio_bound : 6;
  };

  struct data2 {
    unsigned CHAR video_bound            : 5,
                  marker_bit             : 1,
                  system_video_lock_flag : 1,
                  system_audio_lock_flag : 1;
  };

  struct buffer {
    unsigned SHORT std_buffer_size_bound  : 13,
                   std_buffer_bound_scale : 1,
                   flag                   : 2;
  };

#else
  struct data1 {
    unsigned CHAR audio_bound : 6, 
                   fixed_flag : 1, 
                    csps_flag : 1;
  };

  struct data2 {
    unsigned CHAR system_audio_lock_flag : 1,
                  system_video_lock_flag : 1,
                  marker_bit             : 1,
                  video_bound            : 5;
  };

  struct buffer {
    unsigned SHORT flag                   : 2,
                   std_buffer_bound_scale : 1,
                   std_buffer_size_bound  : 13;
  };
#endif
