/**************************************************************************
* Copyright (c) 1994 The Multimedia Communications Lab, Boston University.
* All rights reserved.
*
* Permission to use, copy, modify, and distribute this software and its
* documentation for any purpose, without fee, and without written agreement is
* hereby granted, provided that the above copyright notice and the following
* two paragraphs appear in all copies of this software.
*
* IN NO EVENT SHALL BOSTON UNIVERSITY BE LIABLE TO ANY PARTY FOR
* DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
* OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF BOSTON
* UNIVERSITY HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*
* BOSTON UNIVERSITY SPECIFICALLY DISCLAIMS ANY WARRANTIES,
* INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
* AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
* ON AN "AS IS" BASIS, AND BOSTON UNIVERSITY HAS NO OBLIGATION TO
* PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
*
**************************************************************************/

/*************************************************************************
*  File Name:     pad.c
*  Creation Date: 12 Aug 1994
*  Author:        Ziv Yaar
*                 email  zyaar@bu.edu
*                 Multimedia Communications Lab, Boston University
*                  Professor T.D.C. Little tdcl@flash.bu.edu
*  Usage:         function file
*
*  Description:   This file contains the function write_pad
**************************************************************************/

#include "defines.h"
#include "pad.h"

void itostr(CHAR *, void *, INT);

/*************************************************************************
*  Function:      write_pad()
*  Creation Date: 12 Aug 1994
*  Author:        Ziv Yaar
*                 email  zyaar@bu.edu
*                 Multimedia Communications Lab, Boston University
*                  Professor T.D.C. Little tdcl@flash.bu.edu
*  Input:         output file, packet size
*
*  Effects:       none
*
*  Description:   This function writes a padding stream packet to the
*  output file that is packet size large.
**************************************************************************/

void write_pad (INT output, INT packet_size)
{
  CHAR packet_start_code_prefix[3] = {0x00,0x00,0x01};
  CHAR stream_id = 0xbe;
  unsigned SHORT packet_length;
  CHAR packet_length_data[2];
  struct buffer buff;
#if LITTLE_ENDIAN
  CHAR buff_data[2];
#endif
  CHAR no_pts = 0x0f;
  INT i;
  CHAR stuffing_byte = 0xff;
  CHAR packetbuffer[MAXPACK];
  
  packet_length = packet_size;                        /* set packet_length   */

/* write packet_start_code */
  if(write(output,packet_start_code_prefix,3) != 3)   /* write packet_start_ */
  {                                                   /* code_prefix         */
    printf("Error writing to output\n");              /* on error, print     */
    exit(1);                                          /* err msg and exit    */
  }

  packet_length = packet_length - 3;                  /* subt. for p_s_c     */

/* write stream_id */
  if(write(output,&stream_id,1) != 1)                 /* write stream_id     */
  {
    printf("Error writing to output\n");              /* on error, print     */
    exit(1);                                          /* err msg and exit    */
  }

  --packet_length;                                    /* subt. for stream_id */
  
/* write packet_length */
  packet_length = packet_length - 2;                  /* subt. packet_length */

  itostr(packet_length_data,&packet_length,2);         /* SHORT to string     */

  if(write(output,packet_length_data,2) != 2)         /* write packet_length */
  {
    printf("Error writing to output\n");              /* on error, print     */
    exit(1);                                          /* err msg and exit    */
  }

/* write STD_buffer_scale */
  buff.flag = 1;                                      /* set flag to 0x01    */
  buff.std_buffer_scale = 1;                          /* set s_b_s = 1       */
  buff.std_buffer_size = (packet_size/1024)+1;        /* set s_b_s to        */
                                                      /* packet_size         */
#if LITTLE_ENDIAN
  itostr(buff_data,&buff,2);                           /* SHORT to string     */
  
  if(write(output,buff_data,2) != 2)                  /* write buff info     */
  {
    printf("Error writing to output\n");              /* on error            */
    exit(1);                                          /* print err msg, exit */
  }

#else    
  if(write(output,&buff,2) != 2)                      /* write buff info     */
  {
    printf("Error writing to output\n");              /* on error            */
    exit(1);                                          /* print err msg, exit */
  }
#endif

  packet_length = packet_length - 2;                  /* subt. for STD's     */

/* write no_pts */
  if(write(output,&no_pts,1) != 1)                    /* write no_pts        */
  {
    printf("Error writing to output\n");              /* on error, print     */
    exit(1);                                          /* err msg and exit    */
  }

  --packet_length;                                    /* subtract for no_pts */


  for (i=0;i<packet_length;i++)                       /* write into buffer   */
    packetbuffer[i] = stuffing_byte;                  /* all stuffing bytes  */

  if(write(output,packetbuffer,packet_length) != packet_length)
  {                                                   /* write stuffing_byte */
    printf("Error writing to output\n");              /* on error, print     */
    exit(1);                                          /* err msg and exit    */
  }
}


