/**************************************************************************
* Copyright (c) 1994 The Multimedia Communications Lab, Boston University.
* All rights reserved.
*
* Permission to use, copy, modify, and distribute this software and its
* documentation for any purpose, without fee, and without written agreement is
* hereby granted, provided that the above copyright notice and the following
* two paragraphs appear in all copies of this software.
*
* IN NO EVENT SHALL BOSTON UNIVERSITY BE LIABLE TO ANY PARTY FOR
* DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
* OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF BOSTON
* UNIVERSITY HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*
* BOSTON UNIVERSITY SPECIFICALLY DISCLAIMS ANY WARRANTIES,
* INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
* AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
* ON AN "AS IS" BASIS, AND BOSTON UNIVERSITY HAS NO OBLIGATION TO
* PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
*
**************************************************************************/

/*************************************************************************
*  File Name:     parse.c
*  Creation Date: 12 Aug 1994
*  Author:        Ziv Yaar
*                 email  zyaar@bu.edu
*                 Multimedia Communications Lab, Boston University
*                  Professor T.D.C. Little tdcl@flash.bu.edu
*  Usage:         function calls
*
*  Description:   This file hold the function parse_list
**************************************************************************/

#include "list.h"

/* function prototypes */
LINK add_node(LINK head);

/*************************************************************************
*  Function:      parse_list()
*  Creation Date: 12 Aug 1994
*  Author:        Ziv Yaar
*                 email  zyaar@bu.edu
*                 Multimedia Communications Lab, Boston University
*                  Professor T.D.C. Little tdcl@flash.bu.edu
*  Input:         number of arguments, list of arguments, packet size,
*                 pack size, output file, packets per pack, stream linked
*                 list, bitrate
*
*  Effects:       returns all the parameter changes
*
*  Description:   This function takes the argc/argv argument list and
*  processes it.  It creates a stream node for an A/V stream, it changes
*  default parameters and adds start times.
**************************************************************************/

LINK parse_list(INT n_args, CHAR *args[], INT *packet_size, INT *pack_size,
		CHAR *output_file, INT *packets_per_pack, LINK streams_list,
		unsigned INT *bitrate)
{
  INT i, special=0;

  if (n_args == 1)                                   /* if no arguments      */
  {
                                                     /* print online help    */
    printf("Usage: system_encode [options] file1 start_time1 ");
    printf("file2 start_time2...\n");
    printf("Options:\n");
    printf("        -r byterate: specify constant byterate\n");
    printf("        -k pack_size: set size of system packs\n");
    printf("        -p packet_size: set size of system packets\n");
    printf("        -o outputfilename: save stream as outputfilename\n");
    printf("        -s packets_per_pack: set number of packets per pack\n");
    printf("\n        -CDROM: optimizes all parameters for 1x CDROM\n");
    exit(1);                                         /* exit program         */
  }

  for(i=1; i<n_args; i++)
  { /* go from first to last arguments */

/* Set bitrate */
    if (!strcmp(args[i],"-r"))                       /* if arg = "-r"        */
    {
      *bitrate = (unsigned INT)atol(args[i+1]);      /* next arg = bitrate   */
      special = 1;                                   /* flag next argument   */
                                                     /* so it will be ignored*/
    }

/* Set packet_size */
    else if (!strcmp(args[i],"-p"))
    {                                                /* else if arg = "-p"   */
      *packet_size = atoi(args[i+1]);                /* next arg=packet size */
      special = 1;                                   /* flag next argument   */
                                                     /* so it will be ignored*/
    }

/* Set output file name */
    else if (!strcmp(args[i],"-o"))
    {                                                /* else if arg = "-o"   */
      strcpy(output_file,args[i+1]);                 /* next arg=output_file */
      special = 1;                                   /* flag next argument   */
                                                     /* so it will be ignored*/
    }
  
/* Set packets per pack */
    else if (!strcmp(args[i], "-s"))
    {                                                /* else if arg = "-s"   */
      *packets_per_pack = atoi(args[i+1]);           /* nextarg=packetsperpac*/
      special = 1;                                   /* flag next argument   */
                                                     /* so it will be ignored*/
    }

/* Set pack size        */
    else if (!strcmp(args[i], "-k"))
    {                                                /* else if arg = "-k"   */
      *pack_size = atoi(args[i+1]);                  /* next arg=pack size   */
      special = 1;                                   /* flag next argument   */
                                                     /* so it will be ignored*/
    }
      
/* Set CDROM switch     */
    else if (!strcmp(args[i], "-CDROM"))             /* else if arg ="-CDROM"*/
    {
      *pack_size = CDPACK;                           /* set pack_size        */
      *packets_per_pack = CDNUMPACKETS;              /* set packets_per_pack */
      *packet_size = CDPACKET;                       /* set packet size      */
      *bitrate = CDRATE;                             /* set bitrate          */
    }

/* Set mpeg stream and start time */
    else if (!special)
    {                                                /* else if arg is stream*/
      streams_list=add_node(streams_list);           /* copy args[i] to      */
      strcpy(streams_list->filename, args[i]);       /* node's filename      */

      if (i+1 >= n_args)                             /* if no next arg       */
      {
	printf("no start time specified for %s\n",streams_list->filename);
	exit(1);                                     /* print err msg, exit  */
      }

      streams_list->startime = (FLOAT)atof(args[i+1]); /* store start time   */
      special = 1;                                   /* flag next argument   */
                                                     /* so it will be ignored*/
    }

    else special = 0;
  }

  return streams_list;
}
