/**************************************************************************
* Copyright (c) 1994 The Multimedia Communications Lab, Boston University.
* All rights reserved.
*
* Permission to use, copy, modify, and distribute this software and its
* documentation for any purpose, without fee, and without written agreement is
* hereby granted, provided that the above copyright notice and the following
* two paragraphs appear in all copies of this software.
*
* IN NO EVENT SHALL BOSTON UNIVERSITY BE LIABLE TO ANY PARTY FOR
* DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
* OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF BOSTON
* UNIVERSITY HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*
* BOSTON UNIVERSITY SPECIFICALLY DISCLAIMS ANY WARRANTIES,
* INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
* AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
* ON AN "AS IS" BASIS, AND BOSTON UNIVERSITY HAS NO OBLIGATION TO
* PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
*
**************************************************************************/

/*************************************************************************
*  File Name:     pick.c
*  Creation Date: 12 Aug 1994
*  Author:        Ziv Yaar
*                 email  zyaar@bu.edu
*                 Multimedia Communications Lab, Boston University
*                  Professor T.D.C. Little tdcl@flash.bu.edu
*  Usage:         function calls
*
*  Description:   This file contains the function pick_streams
**************************************************************************/

#include <limits.h>
#include "list.h"
#include "mta.h"

/* function prototypes */
MTA_LINK add_stream(MTA_LINK, LINK);

/*************************************************************************
*  Function:      pick_streams()
*  Creation Date: 12 Aug 1994
*  Author:        Ziv Yaar
*                 email  zyaar@bu.edu
*                 Multimedia Communications Lab, Boston University
*                  Professor T.D.C. Little tdcl@flash.bu.edu
*  Input:         multiplex timing array, streams linked list
*
*  Effects:       returns an updated multiplex timing array
*
*  Description:   This function searches for the streams with the highest
*  encoding priority, and places all those with the same (and highest)
*  priority in the multiplex timing array.
**************************************************************************/

MTA_LINK pick_streams(MTA_LINK mta, LINK streams)
{
  unsigned INT earliest_time = UINT_MAX;
  LINK current = streams;

  if (current != NULL)
  {
/* find the earliest start time */
    while (current != NULL)                             /* go through list   */
    {
      if ((current->next_frame_time < earliest_time)    /* if stream's start */
	  && !(current->isfinished))
	earliest_time = current->next_frame_time;       /* is earlier, store */
      current = current->next;                          /* goto next stream  */
    }

/* place all frames that have the earliest time in the MTA */
    current = streams;                                  /* reset current     */
    do                                                  /* cycle streams     */
    {
      if ((current->next_frame_time == earliest_time)   /* if stream matches */
	  && !(current->isfinished))
	mta = add_stream(mta,current);                  /* add stream to mta */

      current = current->next;                          /* goto next stream  */
    } while (current != NULL);                          /* until end         */
  }

  else mta = NULL;                                      /* if no streams left*/

  return mta;
}
