/**************************************************************************
* Copyright (c) 1994 The Multimedia Communications Lab, Boston University.
* All rights reserved.
*
* Permission to use, copy, modify, and distribute this software and its
* documentation for any purpose, without fee, and without written agreement is
* hereby granted, provided that the above copyright notice and the following
* two paragraphs appear in all copies of this software.
*
* IN NO EVENT SHALL BOSTON UNIVERSITY BE LIABLE TO ANY PARTY FOR
* DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
* OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF BOSTON
* UNIVERSITY HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*
* BOSTON UNIVERSITY SPECIFICALLY DISCLAIMS ANY WARRANTIES,
* INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
* AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
* ON AN "AS IS" BASIS, AND BOSTON UNIVERSITY HAS NO OBLIGATION TO
* PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
*
**************************************************************************/

/*************************************************************************
*  File Name:     update.c
*  Creation Date: 12 Aug 1994
*  Author:        Ziv Yaar
*                 email  zyaar@bu.edu
*                 Multimedia Communications Lab, Boston University
*                  Professor T.D.C. Little tdcl@flash.bu.edu
*  Usage:         function file
*
*  Description:   This file contains the function update_mta
**************************************************************************/

#include "list.h"
#include "mta.h"

/* function prototypes */
SUB_LINK del_offset(SUB_LINK);
WAIT_LINK del_wait(WAIT_LINK);
MTA_LINK del_mta(MTA_LINK);
void stamp_add(CHAR *, unsigned INT);

/*************************************************************************
*  Function:      update_mta()
*  Creation Date: 12 Aug 1994
*  Author:        Ziv Yaar
*                 email  zyaar@bu.edu
*                 Multimedia Communications Lab, Boston University
*                  Professor T.D.C. Little tdcl@flash.bu.edu
*  Input:         mta linked list, packet size
*
*  Effects:       returns an updated mta linked list
*
*  Description:   This function determines how many frames of a certain
*  A/V stream were written in the last packet and updates the that stream
*  through the MTA.  It then removes the stream from the MTA.
**************************************************************************/

MTA_LINK update_mta(MTA_LINK mta, INT packet_size)
{
  INT current = 0 /*, skip = 0 */;
  INT remainder = 0, framewritten = 0;

  if (mta->stream->offsets->offset == 0)            /* del first node        */
    mta->stream->offsets = del_offset(mta->stream->offsets);

  framewritten=mta->stream->framewritten+packet_size; /* add packet worth to */
                                                    /* amount written so far */

  if (mta->stream->offsets->offset > framewritten)  /* if still not done     */
  {
    mta->stream->newframe = 0;                      /* unset newframe        */
    mta->stream->framewritten = framewritten;       /* update framewritten   */
  }

  else                                              /* else, find out how    */
  {                                                 /* man frames written    */
    mta->stream->newframe = 1;                      /* next frame is new     */
    current = mta->stream->offsets->offset;
    
    while (current < framewritten)                  /* while current<written */
    {
      remainder = framewritten - current;           /* set overflow value    */

      if(mta->stream->offsets->frame_type=='I' || 
	 mta->stream->offsets->frame_type=='P')
	mta->stream->waits = del_wait(mta->stream->waits);

      mta->stream->offsets = del_offset(mta->stream->offsets); /* del offset */

      if (mta->stream->offsets != NULL)             /* if frames to go       */
      {
	mta->stream->next_frame_time =              /* incr next frame time  */
	  (INT)(mta->stream->next_frame_time + mta->stream->scsr); /* by SCSR*/

	stamp_add(mta->stream->last_pts,(INT)mta->stream->scsr); /*add stamp */

	current = current+mta->stream->offsets->offset; /* add how much read */
      }

      else                                          /* else, end of stream   */
	break;                                      /* break out of loop     */

    }

    if (mta->stream->offsets != NULL)               /* if frames to go       */
      mta->stream->framewritten = remainder;        /* set amount written    */

    else                                            /* else, stream empty    */
      mta->stream->isfinished = 1;                  /* delete stream         */
  } 
	    
  mta = del_mta(mta);                               /* delete current entry  */
  return mta;
}
