/* Created by MIND V.3.0 (c), FLUX GbR Berlin, 1993-95   */ 

/*************************************************************************** 
 *************************************************************************** 
 * 
 * Projekt:		scan
 * 
 * 
 * Dokumentation:	Scanner Tool
 * 
 * Designer:		Ulrich Rhr
 * 
 * Datum:		Fri Dec 20 12:47:15 1996
 * 
 ***************************************************************************
 ***************************************************************************/

/* INCLUDES */

#include <Xm/XmAll.h>
#include <Xm/XMind.h>
#include <X11/xpm.h>



/*** PRIVATE HEADER ***/ 
#include <X11/cursorfont.h>

#include        <signal.h>
#include        <sys/wait.h>

/*   PRIVATE INCLUDE   */

/*   PRIVATE DEFINES   */

extern XtAppContext app_context;


Pixmap draw_pixmap=0;
GC     draw_gc;

Cursor cursor=0L;

XColor  color_marker;

int	mark_x=10;
int	mark_y=10;
int	mark_w=100;
int	mark_h=100;
int	offset_x;
int	offset_y;


pid_t	scan_pid=0;
pid_t	main_scan_pid=0;

int	fix_image_size=0;

float	dpi=50;
float	effective_dpi=50;
float	zoom=100;

int	scan_w=100;
int	scan_h=100;

int	scan_mode=1;			/* color is default */


int	brightness=0;
int	halftoning = 1;


int	scanner_reso[100];		/* available Resolutions */
int	scanner_anz_reso;		/* number of resolutions */
int	scanner_max_reso;		/* maximum resolution    */
int	scanner_max_w;
int	scanner_max_h;			/* maximum scan resolution */
int	scanner_level;			/* Command level of scanner */

char	conf_scan_app[255]="ep_scan";		/* scanning application		*/
char	conf_view_app[255]="xli -dispgamma 1 %s";		/* Image viewer			*/
int	conf_color_num=128;			/* muber of colors to use for prescan */

/***  END   HEADER   ***/

/* PROTOTYPES */

Widget scan_pre_Create(Widget parent);
static void scan_reload_cb(Widget parent, XtPointer data, XmPushButtonCallbackStruct *cbs);
static void scan_exit_cb(Widget parent, XtPointer data, XmPushButtonCallbackStruct *cbs);
static void scan_do_cb(Widget parent, XtPointer data, XmPushButtonCallbackStruct *cbs);
static void scan_pre_abort_cb(Widget parent, XtPointer data, XmPushButtonCallbackStruct *cbs);
static void scan_draw_red_cb(Widget parent, XtPointer data, XmDrawingAreaCallbackStruct *cbs);
static void scan_color_cb(Widget parent, XtPointer data, XmToggleButtonCallbackStruct *cbs);
static void scan_grayscale_cb(Widget parent, XtPointer data, XmToggleButtonCallbackStruct *cbs);
static void scan_bw_cb(Widget parent, XtPointer data, XmToggleButtonCallbackStruct *cbs);
static void scan_pre_ldpi_cb(Widget parent, XtPointer data, XmListCallbackStruct *cbs);
static void brightness_change_cb(Widget parent, XtPointer data, XmScaleCallbackStruct *cbs);
static void scan_pre_zoom_drag(Widget parent, XtPointer data, XmScaleCallbackStruct *cbs);
static void scan_pre_zoom_cb(Widget parent, XtPointer data, XmScaleCallbackStruct *cbs);
static void scan_fix_img_cb(Widget parent, XtPointer data, XmToggleButtonCallbackStruct *cbs);
static void scan_dither_list_cb(Widget parent, XtPointer data, XmListCallbackStruct *cbs);
static void menue_load_setup_cb(Widget parent, XtPointer data, XmPushButtonCallbackStruct *cbs);
static void menue_save_setup_cb(Widget parent, XtPointer data, XmPushButtonCallbackStruct *cbs);
static void menue_quit_cb(Widget parent, XtPointer data, XmPushButtonCallbackStruct *cbs);
static void menue_fulla4colorscan_cb(Widget parent, XtPointer data, XmPushButtonCallbackStruct *cbs);
static void menue_fax_cb(Widget parent, XtPointer data, XmPushButtonCallbackStruct *cbs);
static void menue_colorphoto_cb(Widget parent, XtPointer data, XmPushButtonCallbackStruct *cbs);
static void menue_opt_info_cb(Widget parent, XtPointer data, XmPushButtonCallbackStruct *cbs);
static void menue_settings_cb(Widget parent, XtPointer data, XmPushButtonCallbackStruct *cbs);
static Widget scannerinformation_Create(Widget parent);
static void info_ok_cb(Widget parent, XtPointer data, XmPushButtonCallbackStruct *cbs);
static Widget programsettings_Create(Widget parent);
static void programsettings_cancel_cb(Widget parent, XtPointer data, XmPushButtonCallbackStruct *cbs);
static void programsettings_ok_cb(Widget parent, XtPointer data, XmPushButtonCallbackStruct *cbs);
static Widget selectpreset_Create(Widget parent);
static void preset_close_cb(Widget parent, XtPointer data, XmPushButtonCallbackStruct *cbs);
static void preset_list_cb(Widget parent, XtPointer data, XmListCallbackStruct *cbs);
static void preset_list_dcb(Widget parent, XtPointer data, XmListCallbackStruct *cbs);
static Widget savesetupas_Create(Widget parent);
static void save_ok_CB(Widget parent, XtPointer data, XmPushButtonCallbackStruct *cbs);
static void save_exit_cb(Widget parent, XtPointer data, XmPushButtonCallbackStruct *cbs);
int reload_prescan(void);
/*-------------------------------------------------------------------*/
/* Cursor auf "warten" setzen                                        */
/*-------------------------------------------------------------------*/
void cursor_wait( void );
/*-------------------------------------------------------------------*/
/* Cursor auf "normal" setzen                                        */
/*-------------------------------------------------------------------*/
void cursor_normal( void );
void mark_klick(Widget widget, XEvent *event, String *args, int *num_args);
void scan_draw_mark(void);
int start_prescan(void);
int prescan_ende(void);
int set_sffective_dpi(void);
int poll_timer(void);
int set_image_size(void);
int poll_timer_main(void);
/*-------------------------------------------------------------*/
/* checking scanner Resolutions form status Block	       */
/*-------------------------------------------------------------*/

int test_ident(char *filename);
void profile_save(void);
void profile_load(void);
int set_all_values(void);


/* STATIC GLOBAL WIDGETS */

static Widget top_level;
static  Widget scan_pre_do;
static  Widget scan_main_do;
static  Widget scan_stat;
static Widget scan_draw;
static  Widget scan_pre_dpi;
static  Widget scan_val_x;
static  Widget scan_val_y;
static  Widget scan_brightness;
static  Widget scan_pre_zoom;
static  Widget scan_pre_fix;
static  Widget scan_eff_dpi;
static  Widget scan_dither_list;
static  Widget scan_color;
static  Widget scan_grayscale;
static  Widget scan_bw;
static  Widget info_reso;
static  Widget info_maxres;
static  Widget info_max_w;
static  Widget info_max_h;
static  Widget conf_view_app_str;
static  Widget conf_scan_app_str;
static  Widget conf_col_nr;
static  Widget preset_list;
static  Widget save_name;

/*************************************************************************** 
 * 
 * Funktionsname:	scan_pre_Create
 * 
 * 
 * Input:		Widget parent
 * 
 * Return:		Widget main
 * 
 * Dokumentation:		
 * 
 * 
 ***************************************************************************/

Widget scan_pre_Create(Widget parent)
{
  Arg args[40];
  Cardinal n;
  XmString tmpLabelString = NULL;
  Widget scan_pre_form12;
  Widget scan_pre_form12_form11;
  Widget scan_pre_form12_form11_frame10;
  Widget scan_exit;
  Widget scan_pre_abort;
  Widget scan_pre_form12_scrolledWindow12;
  Widget scan_pre_form12_form23;
  Widget scan_pre_form12_form23_frame30;
  Widget scan_pre_form12_form23_label12;
  Widget scan_pre_form12_form23_label23;
  Widget scan_pre_form12_form23_label312;
  Widget scan_pre_form12_form23_label416;
  Widget scan_pre_form12_form23_rowColumn114;
  Widget scan_pre_form12_form23_rowColumn114_frame10;
  Widget PulldownMenu;
  Widget scan_pre_PD_Menubar_file;
  Widget scan_pre_PD_Menubar_file_SubId;
  Widget menue_load_setup;
  Widget menue_save_setup;
  Widget scan_pre_PD_Menubar_file_SEP;
  Widget menue_quit;
  Widget scan_pre_PD_Menubar_presets;
  Widget scan_pre_PD_Menubar_presets_SubId;
  Widget menue_fulla4colorscan;
  Widget scan_pre_PD_Menubar_presets_fax;
  Widget menue_colorphoto;
  Widget scan_pre_PD_Menubar_options;
  Widget scan_pre_PD_Menubar_options_SubId;
  Widget scan_pre_PD_Menubar_options_scannerinfo;
  Widget menu_settings;

  n = 0;
  XtSetArg(args[n], XmNwidth, 613); n++;
  XtSetArg(args[n], XmNheight, 685); n++;
  top_level = XmCreateForm(parent, "form1", args, n);

  /*  CREATE PULLDOWN MENU */

  n = 0;
  XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n++;
  XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;
  XtSetArg(args[n], XmNy, 0); n++;
  PulldownMenu = XmCreateMenuBar(top_level, "menuBar", args, n);
  XtManageChild(PulldownMenu);


  n = 0;
  tmpLabelString = XmStringCreate("file", XmFONTLIST_DEFAULT_TAG);
  XtSetArg(args[n], XmNlabelString, tmpLabelString); n++;
  XtSetArg(args[n], XmNmnemonic, 'f'); n++;
  scan_pre_PD_Menubar_file = XmCreateCascadeButton(PulldownMenu, "cascadeButton1", args, n);
  scan_pre_PD_Menubar_file_SubId = XmCreatePulldownMenu(PulldownMenu, "cascadeButton1", args, n);

  n = 0;
  tmpLabelString = XmStringCreate("load setup ...", XmFONTLIST_DEFAULT_TAG);
  XtSetArg(args[n], XmNlabelString, tmpLabelString); n++;
  menue_load_setup = XmCreatePushButton(scan_pre_PD_Menubar_file_SubId, "cascadeButton6", args, n);
  XtManageChild(menue_load_setup);


  n = 0;
  tmpLabelString = XmStringCreate("save setup as ...", XmFONTLIST_DEFAULT_TAG);
  XtSetArg(args[n], XmNlabelString, tmpLabelString); n++;
  menue_save_setup = XmCreatePushButton(scan_pre_PD_Menubar_file_SubId, "cascadeButton7", args, n);
  XtManageChild(menue_save_setup);


  n = 0;
  scan_pre_PD_Menubar_file_SEP = XmCreateSeparator(scan_pre_PD_Menubar_file_SubId, "separator", args, n);
  XtManageChild(scan_pre_PD_Menubar_file_SEP);


  n = 0;
  tmpLabelString = XmStringCreate("quit", XmFONTLIST_DEFAULT_TAG);
  XtSetArg(args[n], XmNlabelString, tmpLabelString); n++;
  menue_quit = XmCreatePushButton(scan_pre_PD_Menubar_file_SubId, "cascadeButton8", args, n);
  XtManageChild(menue_quit);

  XtVaSetValues(scan_pre_PD_Menubar_file, XmNsubMenuId, scan_pre_PD_Menubar_file_SubId, NULL);
  XtManageChild(scan_pre_PD_Menubar_file);


  n = 0;
  tmpLabelString = XmStringCreate("presets", XmFONTLIST_DEFAULT_TAG);
  XtSetArg(args[n], XmNlabelString, tmpLabelString); n++;
  XtSetArg(args[n], XmNmnemonic, 'p'); n++;
  scan_pre_PD_Menubar_presets = XmCreateCascadeButton(PulldownMenu, "cascadeButton2", args, n);
  scan_pre_PD_Menubar_presets_SubId = XmCreatePulldownMenu(PulldownMenu, "cascadeButton2", args, n);

  n = 0;
  tmpLabelString = XmStringCreate("full a4 color scan", XmFONTLIST_DEFAULT_TAG);
  XtSetArg(args[n], XmNlabelString, tmpLabelString); n++;
  menue_fulla4colorscan = XmCreatePushButton(scan_pre_PD_Menubar_presets_SubId, "cascadeButton3", args, n);
  XtManageChild(menue_fulla4colorscan);


  n = 0;
  tmpLabelString = XmStringCreate("fax", XmFONTLIST_DEFAULT_TAG);
  XtSetArg(args[n], XmNlabelString, tmpLabelString); n++;
  scan_pre_PD_Menubar_presets_fax = XmCreatePushButton(scan_pre_PD_Menubar_presets_SubId, "cascadeButton4", args, n);
  XtManageChild(scan_pre_PD_Menubar_presets_fax);


  n = 0;
  tmpLabelString = XmStringCreate("color photo", XmFONTLIST_DEFAULT_TAG);
  XtSetArg(args[n], XmNlabelString, tmpLabelString); n++;
  menue_colorphoto = XmCreatePushButton(scan_pre_PD_Menubar_presets_SubId, "cascadeButton5", args, n);
  XtManageChild(menue_colorphoto);

  XtVaSetValues(scan_pre_PD_Menubar_presets, XmNsubMenuId, scan_pre_PD_Menubar_presets_SubId, NULL);
  XtManageChild(scan_pre_PD_Menubar_presets);


  n = 0;
  tmpLabelString = XmStringCreate("options", XmFONTLIST_DEFAULT_TAG);
  XtSetArg(args[n], XmNlabelString, tmpLabelString); n++;
  scan_pre_PD_Menubar_options = XmCreateCascadeButton(PulldownMenu, "cascadeButton9", args, n);
  scan_pre_PD_Menubar_options_SubId = XmCreatePulldownMenu(PulldownMenu, "cascadeButton9", args, n);

  n = 0;
  tmpLabelString = XmStringCreate("scanner info ...", XmFONTLIST_DEFAULT_TAG);
  XtSetArg(args[n], XmNlabelString, tmpLabelString); n++;
  scan_pre_PD_Menubar_options_scannerinfo = XmCreatePushButton(scan_pre_PD_Menubar_options_SubId, "cascadeButton10", args, n);
  XtManageChild(scan_pre_PD_Menubar_options_scannerinfo);


  n = 0;
  tmpLabelString = XmStringCreate("program settings ...", XmFONTLIST_DEFAULT_TAG);
  XtSetArg(args[n], XmNlabelString, tmpLabelString); n++;
  menu_settings = XmCreatePushButton(scan_pre_PD_Menubar_options_SubId, "cascadeButton11", args, n);
  XtManageChild(menu_settings);

  XtVaSetValues(scan_pre_PD_Menubar_options, XmNsubMenuId, scan_pre_PD_Menubar_options_SubId, NULL);
  XtManageChild(scan_pre_PD_Menubar_options);


  n = 0;
  XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n++;
  XtSetArg(args[n], XmNx, 0); n++;
  XtSetArg(args[n], XmNy, 32); n++;
  XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;
  XtSetArg(args[n], XmNwidth, 613); n++;
  XtSetArg(args[n], XmNbottomAttachment, XmATTACH_FORM); n++;
  XtSetArg(args[n], XmNheight, 653); n++;
  scan_pre_form12 = XmCreateForm(top_level, "form1", args, n);

  n = 0;
  XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n++;
  XtSetArg(args[n], XmNx, 0); n++;
  XtSetArg(args[n], XmNtopAttachment, XmATTACH_FORM); n++;
  XtSetArg(args[n], XmNy, 0); n++;
  XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;
  XtSetArg(args[n], XmNwidth, 613); n++;
  XtSetArg(args[n], XmNbottomAttachment, XmATTACH_NONE); n++;
  XtSetArg(args[n], XmNheight, 38); n++;
  XtSetArg(args[n], XmNheight, 38); n++;
  scan_pre_form12_form11_frame10 = XmCreateFrame(scan_pre_form12, "frame1", args, n);
  XtManageChild(scan_pre_form12_form11_frame10);

  n=0;
  XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n++;
  XtSetArg(args[n], XmNx, 0); n++;
  XtSetArg(args[n], XmNtopAttachment, XmATTACH_FORM); n++;
  XtSetArg(args[n], XmNy, 0); n++;
  XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;
  XtSetArg(args[n], XmNwidth, 613); n++;
  XtSetArg(args[n], XmNbottomAttachment, XmATTACH_NONE); n++;
  XtSetArg(args[n], XmNheight, 38); n++;
  XtSetArg(args[n], XmNheight, 38); n++;
  scan_pre_form12_form11 = XmCreateForm(scan_pre_form12_form11_frame10, "form1", args, n);

  n = 0;
  XtSetArg(args[n], XmNx, 0); n++;
  XtSetArg(args[n], XmNy, 0); n++;
  XtSetArg(args[n], XmNwidth, 80); n++;
  XtSetArg(args[n], XmNheight, 30); n++;
  tmpLabelString = XmStringCreateLtoR("prescan", XmFONTLIST_DEFAULT_TAG);
  XtSetArg(args[n], XmNlabelString, tmpLabelString); n++;

  /*  GENERATE RESOURCES FROM RESOURCE-EDITOR  */
  /* THIS WILL OVERWRITE PREVIOUS DECLARATIONS */

  XtSetArg(args[n], XmNtraversalOn, False); n++;
  scan_pre_do = XmCreatePushButton(scan_pre_form12_form11, "pushButton1", args, n);
  XtManageChild(scan_pre_do);


  n = 0;
  XtSetArg(args[n], XmNx, 260); n++;
  XtSetArg(args[n], XmNy, 0); n++;
  XtSetArg(args[n], XmNwidth, 80); n++;
  XtSetArg(args[n], XmNheight, 30); n++;
  tmpLabelString = XmStringCreateLtoR("quit", XmFONTLIST_DEFAULT_TAG);
  XtSetArg(args[n], XmNlabelString, tmpLabelString); n++;

  /*  GENERATE RESOURCES FROM RESOURCE-EDITOR  */
  /* THIS WILL OVERWRITE PREVIOUS DECLARATIONS */

  XtSetArg(args[n], XmNtraversalOn, False); n++;
  scan_exit = XmCreatePushButton(scan_pre_form12_form11, "pushButton2", args, n);
  XtManageChild(scan_exit);


  n = 0;
  XtSetArg(args[n], XmNx, 90); n++;
  XtSetArg(args[n], XmNy, 0); n++;
  XtSetArg(args[n], XmNwidth, 80); n++;
  XtSetArg(args[n], XmNheight, 30); n++;
  tmpLabelString = XmStringCreateLtoR("scan", XmFONTLIST_DEFAULT_TAG);
  XtSetArg(args[n], XmNlabelString, tmpLabelString); n++;

  /*  GENERATE RESOURCES FROM RESOURCE-EDITOR  */
  /* THIS WILL OVERWRITE PREVIOUS DECLARATIONS */

  XtSetArg(args[n], XmNtraversalOn, False); n++;
  scan_main_do = XmCreatePushButton(scan_pre_form12_form11, "pushButton3", args, n);
  XtManageChild(scan_main_do);


  n = 0;
  XtSetArg(args[n], XmNx, 340); n++;
  XtSetArg(args[n], XmNy, 0); n++;
  XtSetArg(args[n], XmNwidth, 270); n++;
  XtSetArg(args[n], XmNmaxLength, 256); n++;

  /*  GENERATE RESOURCES FROM RESOURCE-EDITOR  */
  /* THIS WILL OVERWRITE PREVIOUS DECLARATIONS */

  XtSetArg(args[n], XmNshadowThickness, 1); n++;
  XtSetArg(args[n], XmNcursorPositionVisible, False); n++;
  XtSetArg(args[n], XmNtraversalOn, False); n++;
  scan_stat = XmCreateTextField(scan_pre_form12_form11, "textField1", args, n);
  XtManageChild(scan_stat);


  n = 0;
  XtSetArg(args[n], XmNx, 180); n++;
  XtSetArg(args[n], XmNy, 0); n++;
  XtSetArg(args[n], XmNwidth, 70); n++;
  XtSetArg(args[n], XmNheight, 30); n++;
  tmpLabelString = XmStringCreateLtoR("abort", XmFONTLIST_DEFAULT_TAG);
  XtSetArg(args[n], XmNlabelString, tmpLabelString); n++;

  /*  GENERATE RESOURCES FROM RESOURCE-EDITOR  */
  /* THIS WILL OVERWRITE PREVIOUS DECLARATIONS */

  XtSetArg(args[n], XmNtraversalOn, False); n++;
  scan_pre_abort = XmCreatePushButton(scan_pre_form12_form11, "pushButton4", args, n);
  XtManageChild(scan_pre_abort);

  XtManageChild(scan_pre_form12_form11);


  n = 0;
  XtSetArg(args[n], XmNx, 158); n++;
  XtSetArg(args[n], XmNy, 38); n++;
  XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;
  XtSetArg(args[n], XmNwidth, 455); n++;
  XtSetArg(args[n], XmNbottomAttachment, XmATTACH_FORM); n++;
  XtSetArg(args[n], XmNheight, 615); n++;
  XtSetArg(args[n], XmNscrollingPolicy,XmAUTOMATIC); n++;
  XtSetArg(args[n], XmNscrollBarDisplayPolicy, XmSTATIC); n++;
  scan_pre_form12_scrolledWindow12 = XmCreateScrolledWindow(scan_pre_form12, "scrolledWindow1", args, n);

  n = 0;
  XtSetArg(args[n], XmNwidth, 424); n++;
  XtSetArg(args[n], XmNheight, 585); n++;
  XtSetArg(args[n], XmNresizePolicy, 0); n++;

  /*  GENERATE RESOURCES FROM RESOURCE-EDITOR  */
  /* THIS WILL OVERWRITE PREVIOUS DECLARATIONS */

  XtSetArg(args[n], XmNbackground, MGetPixel("White",parent)); n++;
  scan_draw = XmCreateDrawingArea(scan_pre_form12_scrolledWindow12, "drawingArea1", args, n);
  XtManageChild(scan_draw);

  XtManageChild(scan_pre_form12_scrolledWindow12);


  n = 0;
  XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n++;
  XtSetArg(args[n], XmNx, 0); n++;
  XtSetArg(args[n], XmNy, 38); n++;
  XtSetArg(args[n], XmNrightAttachment, XmATTACH_NONE); n++;
  XtSetArg(args[n], XmNwidth, 158); n++;
  XtSetArg(args[n], XmNwidth, 158); n++;
  XtSetArg(args[n], XmNbottomAttachment, XmATTACH_FORM); n++;
  XtSetArg(args[n], XmNheight, 615); n++;
  scan_pre_form12_form23_frame30 = XmCreateFrame(scan_pre_form12, "frame3", args, n);
  XtManageChild(scan_pre_form12_form23_frame30);

  n=0;
  XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n++;
  XtSetArg(args[n], XmNx, 0); n++;
  XtSetArg(args[n], XmNy, 38); n++;
  XtSetArg(args[n], XmNrightAttachment, XmATTACH_NONE); n++;
  XtSetArg(args[n], XmNwidth, 158); n++;
  XtSetArg(args[n], XmNwidth, 158); n++;
  XtSetArg(args[n], XmNbottomAttachment, XmATTACH_FORM); n++;
  XtSetArg(args[n], XmNheight, 615); n++;
  scan_pre_form12_form23 = XmCreateForm(scan_pre_form12_form23_frame30, "form2", args, n);

  n = 0;
  XtSetArg(args[n], XmNx, 3); n++;
  XtSetArg(args[n], XmNy, 27); n++;
  XtSetArg(args[n], XmNwidth, 150); n++;
  XtSetArg(args[n], XmNheight, 96); n++;
  XtSetArg(args[n], XmNselectionPolicy, 0); n++;
  XtSetArg(args[n], XmNlistSizePolicy, XmCONSTANT); n++;
  scan_pre_dpi = XmCreateScrolledList(scan_pre_form12_form23, "list1", args, n);
  XtManageChild(scan_pre_dpi);


  n = 0;
  XtSetArg(args[n], XmNx, 9); n++;
  XtSetArg(args[n], XmNy, 4); n++;
  tmpLabelString = XmStringCreateLtoR("Resolution (dpi)", XmFONTLIST_DEFAULT_TAG);
  XtSetArg(args[n], XmNlabelString, tmpLabelString); n++;
  XtSetArg(args[n], XmNrecomputeSize, TRUE ); n++;
  XtSetArg(args[n], XmNalignment, 1 ); n++;
  scan_pre_form12_form23_label12 = XmCreateLabel(scan_pre_form12_form23, "label1", args, n);
  XtManageChild(scan_pre_form12_form23_label12);


  n = 0;
  XtSetArg(args[n], XmNx, 10); n++;
  XtSetArg(args[n], XmNy, 187); n++;
  tmpLabelString = XmStringCreateLtoR("image size x & y", XmFONTLIST_DEFAULT_TAG);
  XtSetArg(args[n], XmNlabelString, tmpLabelString); n++;
  XtSetArg(args[n], XmNrecomputeSize, TRUE ); n++;
  XtSetArg(args[n], XmNalignment, 1 ); n++;
  scan_pre_form12_form23_label23 = XmCreateLabel(scan_pre_form12_form23, "label2", args, n);
  XtManageChild(scan_pre_form12_form23_label23);


  n = 0;
  XtSetArg(args[n], XmNx, 3); n++;
  XtSetArg(args[n], XmNy, 211); n++;
  XtSetArg(args[n], XmNwidth, 68); n++;
  XtSetArg(args[n], XmNmaxLength, 6); n++;

  /*  GENERATE RESOURCES FROM RESOURCE-EDITOR  */
  /* THIS WILL OVERWRITE PREVIOUS DECLARATIONS */

  XtSetArg(args[n], XmNbackground, MGetPixel("White",parent)); n++;
  scan_val_x = XmCreateTextField(scan_pre_form12_form23, "textField1", args, n);
  XtManageChild(scan_val_x);


  n = 0;
  XtSetArg(args[n], XmNx, 78); n++;
  XtSetArg(args[n], XmNy, 211); n++;
  XtSetArg(args[n], XmNwidth, 66); n++;
  XtSetArg(args[n], XmNmaxLength, 6); n++;

  /*  GENERATE RESOURCES FROM RESOURCE-EDITOR  */
  /* THIS WILL OVERWRITE PREVIOUS DECLARATIONS */

  XtSetArg(args[n], XmNbackground, MGetPixel("White",parent)); n++;
  scan_val_y = XmCreateTextField(scan_pre_form12_form23, "textField2", args, n);
  XtManageChild(scan_val_y);


  n = 0;
  XtSetArg(args[n], XmNx, 5); n++;
  XtSetArg(args[n], XmNy, 322); n++;
  XtSetArg(args[n], XmNwidth, 140); n++;
  XtSetArg(args[n], XmNheight, 50); n++;
  tmpLabelString = XmStringCreate("Brightness", XmFONTLIST_DEFAULT_TAG);
  XtSetArg(args[n], XmNtitleString, tmpLabelString); n++;
  XtSetArg(args[n], XmNorientation, XmHORIZONTAL); n++;
  XtSetArg(args[n], XmNminimum, -3); n++;
  XtSetArg(args[n], XmNmaximum, 3); n++;
  XtSetArg(args[n], XmNshowValue, TRUE); n++;
  XtSetArg(args[n], XmNvalue, 0); n++;
  XtSetArg(args[n], XmNscaleMultiple, 1); n++;

  /*  GENERATE RESOURCES FROM RESOURCE-EDITOR  */
  /* THIS WILL OVERWRITE PREVIOUS DECLARATIONS */

  XtSetArg(args[n], XmNy, 322); n++;
  XtSetArg(args[n], XmNheight, 50); n++;
  XtSetArg(args[n], XmNwidth, 140); n++;
  XtSetArg(args[n], XmNx, 5); n++;
  scan_brightness = XmCreateScale(scan_pre_form12_form23, "scale1", args, n);
  XtManageChild(scan_brightness);


  n = 0;
  XtSetArg(args[n], XmNx, 5); n++;
  XtSetArg(args[n], XmNy, 260); n++;
  XtSetArg(args[n], XmNwidth, 140); n++;
  XtSetArg(args[n], XmNheight, 50); n++;
  tmpLabelString = XmStringCreate("Zoom", XmFONTLIST_DEFAULT_TAG);
  XtSetArg(args[n], XmNtitleString, tmpLabelString); n++;
  XtSetArg(args[n], XmNorientation, XmHORIZONTAL); n++;
  XtSetArg(args[n], XmNminimum, 50); n++;
  XtSetArg(args[n], XmNmaximum, 200); n++;
  XtSetArg(args[n], XmNshowValue, TRUE); n++;
  XtSetArg(args[n], XmNvalue, 100); n++;
  XtSetArg(args[n], XmNscaleMultiple, 1); n++;

  /*  GENERATE RESOURCES FROM RESOURCE-EDITOR  */
  /* THIS WILL OVERWRITE PREVIOUS DECLARATIONS */

  XtSetArg(args[n], XmNy, 260); n++;
  XtSetArg(args[n], XmNheight, 50); n++;
  XtSetArg(args[n], XmNwidth, 140); n++;
  XtSetArg(args[n], XmNx, 5); n++;
  scan_pre_zoom = XmCreateScale(scan_pre_form12_form23, "scale2", args, n);
  XtManageChild(scan_pre_zoom);


  n = 0;
  XtSetArg(args[n], XmNx, 10); n++;
  XtSetArg(args[n], XmNy, 158); n++;
  tmpLabelString = XmStringCreate("fix image size", XmFONTLIST_DEFAULT_TAG);
  XtSetArg(args[n], XmNlabelString, tmpLabelString); n++;
  XtSetArg(args[n], XmNrecomputeSize, TRUE ); n++;
  scan_pre_fix = XmCreateToggleButton(scan_pre_form12_form23, "toggleButton1", args, n);
  XtManageChild(scan_pre_fix);


  n = 0;
  XtSetArg(args[n], XmNx, 10); n++;
  XtSetArg(args[n], XmNy, 134); n++;
  tmpLabelString = XmStringCreateLtoR("effektive", XmFONTLIST_DEFAULT_TAG);
  XtSetArg(args[n], XmNlabelString, tmpLabelString); n++;
  XtSetArg(args[n], XmNrecomputeSize, TRUE ); n++;
  XtSetArg(args[n], XmNalignment, 1 ); n++;
  scan_pre_form12_form23_label312 = XmCreateLabel(scan_pre_form12_form23, "label3", args, n);
  XtManageChild(scan_pre_form12_form23_label312);


  n = 0;
  XtSetArg(args[n], XmNx, 72); n++;
  XtSetArg(args[n], XmNy, 132); n++;
  XtSetArg(args[n], XmNwidth, 39); n++;
  XtSetArg(args[n], XmNeditable, FALSE ); n++;
  XtSetArg(args[n], XmNmaxLength, 4); n++;

  /*  GENERATE RESOURCES FROM RESOURCE-EDITOR  */
  /* THIS WILL OVERWRITE PREVIOUS DECLARATIONS */

  XtSetArg(args[n], XmNcursorPositionVisible, False); n++;
  XtSetArg(args[n], XmNshadowThickness, 0); n++;
  XtSetArg(args[n], XmNtraversalOn, False); n++;
  XtSetArg(args[n], XmNmarginHeight, 0); n++;
  scan_eff_dpi = XmCreateTextField(scan_pre_form12_form23, "textField3", args, n);
  XtManageChild(scan_eff_dpi);

  XmTextSetString(scan_eff_dpi, "50");


  n = 0;
  XtSetArg(args[n], XmNx, 5); n++;
  XtSetArg(args[n], XmNy, 483); n++;
  XtSetArg(args[n], XmNwidth, 142); n++;
  XtSetArg(args[n], XmNheight, 96); n++;
  XtSetArg(args[n], XmNselectionPolicy, 0); n++;
  XtSetArg(args[n], XmNlistSizePolicy, XmCONSTANT); n++;
  scan_dither_list = XmCreateScrolledList(scan_pre_form12_form23, "list2", args, n);
  XtVaSetValues(scan_dither_list,
    XtVaTypedArg, XmNitems, XmRString, 
      "no halftoning,hard tone,soft tone,net-screen,4x4 Bayer,4x4 spiral,4x4 net screen,8x4 net screen", 96, 
    XmNitemCount, 8,
    NULL);
  XtManageChild(scan_dither_list);


  n = 0;
  XtSetArg(args[n], XmNx, 118); n++;
  XtSetArg(args[n], XmNy, 132); n++;
  tmpLabelString = XmStringCreateLtoR("dpi", XmFONTLIST_DEFAULT_TAG);
  XtSetArg(args[n], XmNlabelString, tmpLabelString); n++;
  XtSetArg(args[n], XmNrecomputeSize, TRUE ); n++;
  XtSetArg(args[n], XmNalignment, 1 ); n++;
  scan_pre_form12_form23_label416 = XmCreateLabel(scan_pre_form12_form23, "label4", args, n);
  XtManageChild(scan_pre_form12_form23_label416);


  n = 0;
  XtSetArg(args[n], XmNx, 5); n++;
  XtSetArg(args[n], XmNy, 386); n++;
  XtSetArg(args[n], XmNwidth, 145); n++;
  XtSetArg(args[n], XmNheight, 91); n++;
  scan_pre_form12_form23_rowColumn114_frame10 = XmCreateFrame(scan_pre_form12_form23, "frame1", args, n);
  XtManageChild(scan_pre_form12_form23_rowColumn114_frame10);

  n=0;
  XtSetArg(args[n], XmNx, 5); n++;
  XtSetArg(args[n], XmNy, 386); n++;
  XtSetArg(args[n], XmNwidth, 145); n++;
  XtSetArg(args[n], XmNheight, 91); n++;
  XtSetArg(args[n], XmNorientation, 0 ); n++;
  XtSetArg(args[n], XmNresizeWidth, FALSE); n++;
  XtSetArg(args[n], XmNresizeHeight, FALSE); n++;
  scan_pre_form12_form23_rowColumn114 = XmCreateRadioBox(scan_pre_form12_form23_rowColumn114_frame10, "rowColumn1", args, n);

  n = 0;
  tmpLabelString = XmStringCreate("color", XmFONTLIST_DEFAULT_TAG);
  XtSetArg(args[n], XmNlabelString, tmpLabelString); n++;
  XtSetArg(args[n], XmNset, TRUE ); n++;
  XtSetArg(args[n], XmNrecomputeSize, TRUE ); n++;
  scan_color = XmCreateToggleButton(scan_pre_form12_form23_rowColumn114, "toggleButton1", args, n);
  XtManageChild(scan_color);


  n = 0;
  tmpLabelString = XmStringCreate("grayscale", XmFONTLIST_DEFAULT_TAG);
  XtSetArg(args[n], XmNlabelString, tmpLabelString); n++;
  XtSetArg(args[n], XmNrecomputeSize, TRUE ); n++;
  scan_grayscale = XmCreateToggleButton(scan_pre_form12_form23_rowColumn114, "toggleButton2", args, n);
  XtManageChild(scan_grayscale);


  n = 0;
  tmpLabelString = XmStringCreate("b/w Image", XmFONTLIST_DEFAULT_TAG);
  XtSetArg(args[n], XmNlabelString, tmpLabelString); n++;
  XtSetArg(args[n], XmNrecomputeSize, TRUE ); n++;
  scan_bw = XmCreateToggleButton(scan_pre_form12_form23_rowColumn114, "toggleButton3", args, n);
  XtManageChild(scan_bw);

  XtManageChild(scan_pre_form12_form23_rowColumn114);

  XtManageChild(scan_pre_form12_form23);

  XtManageChild(scan_pre_form12);

  XtAddCallback(scan_pre_do, XmNactivateCallback, (XtCallbackProc) scan_reload_cb, (XtPointer)NULL);
  XtAddCallback(scan_exit, XmNactivateCallback, (XtCallbackProc) scan_exit_cb, (XtPointer)NULL);
  XtAddCallback(scan_main_do, XmNactivateCallback, (XtCallbackProc) scan_do_cb, (XtPointer)NULL);
  XtAddCallback(scan_pre_abort, XmNactivateCallback, (XtCallbackProc) scan_pre_abort_cb, (XtPointer)NULL);
  XtAddCallback(scan_draw, XmNexposeCallback, (XtCallbackProc) scan_draw_red_cb, (XtPointer)NULL);
  XtAddCallback(scan_pre_dpi, XmNsingleSelectionCallback, (XtCallbackProc) scan_pre_ldpi_cb, (XtPointer)NULL);
  XtAddCallback(scan_brightness, XmNvalueChangedCallback, (XtCallbackProc) brightness_change_cb, (XtPointer)NULL);
  XtAddCallback(scan_pre_zoom, XmNdragCallback, (XtCallbackProc) scan_pre_zoom_drag, (XtPointer)NULL);
  XtAddCallback(scan_pre_zoom, XmNvalueChangedCallback, (XtCallbackProc) scan_pre_zoom_cb, (XtPointer)NULL);
  XtAddCallback(scan_pre_fix, XmNvalueChangedCallback, (XtCallbackProc) scan_fix_img_cb, (XtPointer)NULL);
  XtAddCallback(scan_dither_list, XmNsingleSelectionCallback, (XtCallbackProc) scan_dither_list_cb, (XtPointer)NULL);
  XtAddCallback(scan_color, XmNvalueChangedCallback, (XtCallbackProc) scan_color_cb, (XtPointer)NULL);
  XtAddCallback(scan_grayscale, XmNvalueChangedCallback, (XtCallbackProc) scan_grayscale_cb, (XtPointer)NULL);
  XtAddCallback(scan_bw, XmNvalueChangedCallback, (XtCallbackProc) scan_bw_cb, (XtPointer)NULL);
  XtAddCallback(menue_load_setup, XmNactivateCallback, (XtCallbackProc) menue_load_setup_cb, (XtPointer)NULL);
  XtAddCallback(menue_save_setup, XmNactivateCallback, (XtCallbackProc) menue_save_setup_cb, (XtPointer)NULL);
  XtAddCallback(menue_quit, XmNactivateCallback, (XtCallbackProc) menue_quit_cb, (XtPointer)NULL);
  XtAddCallback(menue_fulla4colorscan, XmNactivateCallback, (XtCallbackProc) menue_fulla4colorscan_cb, (XtPointer)NULL);
  XtAddCallback(scan_pre_PD_Menubar_presets_fax, XmNactivateCallback, (XtCallbackProc) menue_fax_cb, (XtPointer)NULL);
  XtAddCallback(menue_colorphoto, XmNactivateCallback, (XtCallbackProc) menue_colorphoto_cb, (XtPointer)NULL);
  XtAddCallback(scan_pre_PD_Menubar_options_scannerinfo, XmNactivateCallback, (XtCallbackProc) menue_opt_info_cb, (XtPointer)NULL);
  XtAddCallback(menu_settings, XmNactivateCallback, (XtCallbackProc) menue_settings_cb, (XtPointer)NULL);

  /* GENERATE ADDITIONAL ATTACHMENTS */
  n=0;
  XtSetArg(args[n], XmNleftAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(args[n], XmNleftWidget, scan_pre_form12_form23); n++;
  XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(args[n], XmNtopWidget, scan_pre_form12_form11); n++;
  XtSetValues(scan_pre_form12_scrolledWindow12, args, n);

  /* GENERATE ADDITIONAL ATTACHMENTS */
  n=0;
  XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(args[n], XmNtopWidget, scan_pre_form12_form11); n++;
  XtSetValues(scan_pre_form12_form23_frame30, args, n);

  /* GENERATE ADDITIONAL ATTACHMENTS */
  n=0;
  XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(args[n], XmNtopWidget, scan_pre_PD_Menubar_file); n++;
  XtSetValues(scan_pre_form12, args, n);
  /* Finit-functions */
{
  int		i;
  char		str[100];

  XColor              unused;
  XtActionsRec        actions;
  String translations = "<Btn1Down>: mark_klick(down) ManagerGadgetArm() \n<Btn1Up>: mark_klick(up) ManagerGadgetActivate() \n<Btn1Motion>: mark_klick(motion) ManagerGadgetButtonMotion() ";

  profile_load();

  actions.string = "mark_klick";
  actions.proc   =  (XtActionProc) mark_klick;
  XtAppAddActions(app_context,&actions,1);
  XtVaSetValues(scan_draw,XmNtranslations,XtParseTranslationTable(translations),NULL);


  draw_gc = XCreateGC(XtDisplay(scan_draw),RootWindowOfScreen (XtScreen (scan_draw)),0,NULL);


  XAllocNamedColor(XtDisplay(scan_draw), 
                 DefaultColormapOfScreen(XtScreen(scan_draw)),
                 "white",
                 &color_marker,&unused);


  set_image_size();

/*  reload_prescan(); */
  XmTextSetString(scan_stat,"ready");
    XtSetSensitive(scan_dither_list,False);

  sprintf(str,"%s -q /tmp/scan.ident",conf_scan_app);
  system(str);
  test_ident("/tmp/scan.ident");
  unlink("/tmp/scan.ident");

  for(i=0;i<scanner_anz_reso;i++)
  {
    sprintf(str,"%d dpi",scanner_reso[i]);
    MListAddString(scan_pre_dpi, str);
  }
}

  if(tmpLabelString) XmStringFree(tmpLabelString);
  return top_level;
}


/*************************************************************************** 
 * 
 * Funktionsname:	scannerinformation_Create
 * 
 * 
 * Input:		Widget parent
 * 
 * Return:		Widget main
 * 
 * Dokumentation:		
 * 
 * 
 ***************************************************************************/

static Widget scannerinformation_Create(Widget parent)
{
  Arg args[40];
  Cardinal n;
  Widget MainShell;
  XmString tmpLabelString = NULL;
  Widget scannerinformation;
  Widget scannerinformation_label11;
  Widget info_level;
  Widget scannerinformation_label23;
  Widget scannerinformation_label35;
  Widget scannerinformation_label47;
  Widget scannerinformation_label510;
  Widget scannerinformation_separator111;
  Widget scannerinformation_label612;
  Widget scannerinformation_pushButton10;


  n = 0;
  XtSetArg(args[n], XmNwidth, 408); n++;
  XtSetArg(args[n], XmNheight, 222); n++;
  XtSetArg(args[n], XmNtitle, "scanner information"); n++;
  MainShell = (Widget)XmCreateDialogShell(parent,"form2_Dialog",args, n);


  n = 0;
  XtSetArg(args[n], XmNwidth, 408); n++;
  XtSetArg(args[n], XmNheight, 222); n++;
  XtSetArg(args[n], XmNautoUnmanage, FALSE); n++;
  XtSetArg(args[n], XmNnoResize, TRUE); n++;
  scannerinformation = XmCreateForm(MainShell, "form2", args, n);

  n = 0;
  XtSetArg(args[n], XmNx, 24); n++;
  XtSetArg(args[n], XmNy, 24); n++;
  tmpLabelString = XmStringCreateLtoR("scanner features level", XmFONTLIST_DEFAULT_TAG);
  XtSetArg(args[n], XmNlabelString, tmpLabelString); n++;
  XtSetArg(args[n], XmNrecomputeSize, TRUE ); n++;
  XtSetArg(args[n], XmNalignment, 1 ); n++;
  scannerinformation_label11 = XmCreateLabel(scannerinformation, "label1", args, n);
  XtManageChild(scannerinformation_label11);


  n = 0;
  XtSetArg(args[n], XmNx, 228); n++;
  XtSetArg(args[n], XmNy, 12); n++;
  XtSetArg(args[n], XmNwidth, 60); n++;
  XtSetArg(args[n], XmNeditable, FALSE ); n++;
  XtSetArg(args[n], XmNmaxLength, 256); n++;

  /*  GENERATE RESOURCES FROM RESOURCE-EDITOR  */
  /* THIS WILL OVERWRITE PREVIOUS DECLARATIONS */

  XtSetArg(args[n], XmNcursorPositionVisible, False); n++;
  XtSetArg(args[n], XmNtraversalOn, False); n++;
  info_level = XmCreateTextField(scannerinformation, "textField1", args, n);
  XtManageChild(info_level);


  n = 0;
  XtSetArg(args[n], XmNx, 24); n++;
  XtSetArg(args[n], XmNy, 60); n++;
  tmpLabelString = XmStringCreateLtoR("number of available resolutions", XmFONTLIST_DEFAULT_TAG);
  XtSetArg(args[n], XmNlabelString, tmpLabelString); n++;
  XtSetArg(args[n], XmNrecomputeSize, TRUE ); n++;
  XtSetArg(args[n], XmNalignment, 1 ); n++;
  scannerinformation_label23 = XmCreateLabel(scannerinformation, "label2", args, n);
  XtManageChild(scannerinformation_label23);


  n = 0;
  XtSetArg(args[n], XmNx, 228); n++;
  XtSetArg(args[n], XmNy, 48); n++;
  XtSetArg(args[n], XmNwidth, 60); n++;
  XtSetArg(args[n], XmNeditable, FALSE ); n++;
  XtSetArg(args[n], XmNmaxLength, 256); n++;

  /*  GENERATE RESOURCES FROM RESOURCE-EDITOR  */
  /* THIS WILL OVERWRITE PREVIOUS DECLARATIONS */

  XtSetArg(args[n], XmNcursorPositionVisible, False); n++;
  XtSetArg(args[n], XmNtraversalOn, False); n++;
  info_reso = XmCreateTextField(scannerinformation, "textField2", args, n);
  XtManageChild(info_reso);


  n = 0;
  XtSetArg(args[n], XmNx, 24); n++;
  XtSetArg(args[n], XmNy, 96); n++;
  tmpLabelString = XmStringCreateLtoR("maximum scanner resolution", XmFONTLIST_DEFAULT_TAG);
  XtSetArg(args[n], XmNlabelString, tmpLabelString); n++;
  XtSetArg(args[n], XmNrecomputeSize, TRUE ); n++;
  XtSetArg(args[n], XmNalignment, 1 ); n++;
  scannerinformation_label35 = XmCreateLabel(scannerinformation, "label3", args, n);
  XtManageChild(scannerinformation_label35);


  n = 0;
  XtSetArg(args[n], XmNx, 228); n++;
  XtSetArg(args[n], XmNy, 84); n++;
  XtSetArg(args[n], XmNwidth, 60); n++;
  XtSetArg(args[n], XmNeditable, FALSE ); n++;
  XtSetArg(args[n], XmNmaxLength, 256); n++;

  /*  GENERATE RESOURCES FROM RESOURCE-EDITOR  */
  /* THIS WILL OVERWRITE PREVIOUS DECLARATIONS */

  XtSetArg(args[n], XmNcursorPositionVisible, False); n++;
  XtSetArg(args[n], XmNtraversalOn, False); n++;
  info_maxres = XmCreateTextField(scannerinformation, "textField3", args, n);
  XtManageChild(info_maxres);


  n = 0;
  XtSetArg(args[n], XmNx, 24); n++;
  XtSetArg(args[n], XmNy, 132); n++;
  tmpLabelString = XmStringCreateLtoR("maximum scan area in pixel", XmFONTLIST_DEFAULT_TAG);
  XtSetArg(args[n], XmNlabelString, tmpLabelString); n++;
  XtSetArg(args[n], XmNrecomputeSize, TRUE ); n++;
  XtSetArg(args[n], XmNalignment, 1 ); n++;
  scannerinformation_label47 = XmCreateLabel(scannerinformation, "label4", args, n);
  XtManageChild(scannerinformation_label47);


  n = 0;
  XtSetArg(args[n], XmNx, 228); n++;
  XtSetArg(args[n], XmNy, 120); n++;
  XtSetArg(args[n], XmNwidth, 60); n++;
  XtSetArg(args[n], XmNeditable, FALSE ); n++;
  XtSetArg(args[n], XmNmaxLength, 256); n++;

  /*  GENERATE RESOURCES FROM RESOURCE-EDITOR  */
  /* THIS WILL OVERWRITE PREVIOUS DECLARATIONS */

  XtSetArg(args[n], XmNcursorPositionVisible, False); n++;
  XtSetArg(args[n], XmNtraversalOn, False); n++;
  info_max_w = XmCreateTextField(scannerinformation, "textField4", args, n);
  XtManageChild(info_max_w);


  n = 0;
  XtSetArg(args[n], XmNx, 324); n++;
  XtSetArg(args[n], XmNy, 120); n++;
  XtSetArg(args[n], XmNwidth, 60); n++;
  XtSetArg(args[n], XmNeditable, FALSE ); n++;
  XtSetArg(args[n], XmNmaxLength, 256); n++;

  /*  GENERATE RESOURCES FROM RESOURCE-EDITOR  */
  /* THIS WILL OVERWRITE PREVIOUS DECLARATIONS */

  XtSetArg(args[n], XmNtraversalOn, False); n++;
  XtSetArg(args[n], XmNcursorPositionVisible, False); n++;
  info_max_h = XmCreateTextField(scannerinformation, "textField5", args, n);
  XtManageChild(info_max_h);


  n = 0;
  XtSetArg(args[n], XmNx, 300); n++;
  XtSetArg(args[n], XmNy, 132); n++;
  tmpLabelString = XmStringCreateLtoR("x", XmFONTLIST_DEFAULT_TAG);
  XtSetArg(args[n], XmNlabelString, tmpLabelString); n++;
  XtSetArg(args[n], XmNrecomputeSize, TRUE ); n++;
  XtSetArg(args[n], XmNalignment, 1 ); n++;
  scannerinformation_label510 = XmCreateLabel(scannerinformation, "label5", args, n);
  XtManageChild(scannerinformation_label510);


  n = 0;
  XtSetArg(args[n], XmNx, 0); n++;
  XtSetArg(args[n], XmNy, 160); n++;
  XtSetArg(args[n], XmNwidth, 410); n++;
  XtSetArg(args[n], XmNmargin, 0 ); n++;
  scannerinformation_separator111 = XmCreateSeparator(scannerinformation, "separator1", args, n);
  XtManageChild(scannerinformation_separator111);


  n = 0;
  XtSetArg(args[n], XmNx, 300); n++;
  XtSetArg(args[n], XmNy, 95); n++;
  tmpLabelString = XmStringCreateLtoR("dpi", XmFONTLIST_DEFAULT_TAG);
  XtSetArg(args[n], XmNlabelString, tmpLabelString); n++;
  XtSetArg(args[n], XmNrecomputeSize, TRUE ); n++;
  XtSetArg(args[n], XmNalignment, 1 ); n++;
  scannerinformation_label612 = XmCreateLabel(scannerinformation, "label6", args, n);
  XtManageChild(scannerinformation_label612);


  n = 0;
  XtSetArg(args[n], XmNx, 295); n++;
  XtSetArg(args[n], XmNy, 175); n++;
  XtSetArg(args[n], XmNwidth, 105); n++;
  XtSetArg(args[n], XmNheight, 30); n++;
  tmpLabelString = XmStringCreateLtoR("OK", XmFONTLIST_DEFAULT_TAG);
  XtSetArg(args[n], XmNlabelString, tmpLabelString); n++;
  scannerinformation_pushButton10 = XmCreatePushButton(scannerinformation, "pushButton1", args, n);
  XtManageChild(scannerinformation_pushButton10);

  XtAddCallback(scannerinformation_pushButton10, XmNactivateCallback, (XtCallbackProc) info_ok_cb, (XtPointer)NULL);
  /* Finit-functions */

MTextSetInt(info_level,scanner_level);
MTextSetInt(info_reso,scanner_anz_reso);
MTextSetInt(info_maxres,scanner_max_reso);
MTextSetInt(info_max_w,scanner_max_w);
MTextSetInt(info_max_h,scanner_max_h);

XtVaSetValues(scannerinformation,XmNdefaultButton,scannerinformation_pushButton10,0);
XtVaSetValues(scannerinformation_pushButton10,XmNdefaultButtonShadowThickness,0,0);

  XtManageChild(scannerinformation);


  if(tmpLabelString) XmStringFree(tmpLabelString);
  return scannerinformation;
}


/*************************************************************************** 
 * 
 * Funktionsname:	programsettings_Create
 * 
 * 
 * Input:		Widget parent
 * 
 * Return:		Widget main
 * 
 * Dokumentation:		
 * 
 * 
 ***************************************************************************/

static Widget programsettings_Create(Widget parent)
{
  Arg args[40];
  Cardinal n;
  Widget MainShell;
  XmString tmpLabelString = NULL;
  Widget programsettings;
  Widget programsettings_label10;
  Widget programsettings_label22;
  Widget programsettings_label34;
  Widget programsettings_label46;
  Widget programsettings_separator210;
  Widget programsettings_form112;
  Widget programsettings_cancel;
  Widget programsettings_ok;


  n = 0;
  XtSetArg(args[n], XmNwidth, 598); n++;
  XtSetArg(args[n], XmNheight, 191); n++;
  XtSetArg(args[n], XmNtitle, "program settings"); n++;
  MainShell = (Widget)XmCreateDialogShell(parent,"form3_Dialog",args, n);


  n = 0;
  XtSetArg(args[n], XmNwidth, 598); n++;
  XtSetArg(args[n], XmNheight, 191); n++;
  XtSetArg(args[n], XmNautoUnmanage, FALSE); n++;
  XtSetArg(args[n], XmNnoResize, TRUE); n++;
  programsettings = XmCreateForm(MainShell, "form3", args, n);

  n = 0;
  XtSetArg(args[n], XmNx, 256); n++;
  XtSetArg(args[n], XmNy, 144); n++;
  XtSetArg(args[n], XmNwidth, 336); n++;
  XtSetArg(args[n], XmNheight, 44); n++;
  programsettings_form112 = XmCreateForm(programsettings, "form1", args, n);

  n = 0;
  XtSetArg(args[n], XmNleftAttachment, XmATTACH_SELF); n++;
  XtSetArg(args[n], XmNx, 38); n++;
  XtSetArg(args[n], XmNtopAttachment, XmATTACH_SELF); n++;
  XtSetArg(args[n], XmNy, 5); n++;
  XtSetArg(args[n], XmNrightAttachment, XmATTACH_SELF); n++;
  XtSetArg(args[n], XmNwidth, 120); n++;
  XtSetArg(args[n], XmNbottomAttachment, XmATTACH_SELF); n++;
  XtSetArg(args[n], XmNheight, 30); n++;
  tmpLabelString = XmStringCreateLtoR("    cancel    ", XmFONTLIST_DEFAULT_TAG);
  XtSetArg(args[n], XmNlabelString, tmpLabelString); n++;
  programsettings_cancel = XmCreatePushButton(programsettings_form112, "pushButton2", args, n);
  XtManageChild(programsettings_cancel);


  n = 0;
  XtSetArg(args[n], XmNleftAttachment, XmATTACH_SELF); n++;
  XtSetArg(args[n], XmNx, 185); n++;
  XtSetArg(args[n], XmNtopAttachment, XmATTACH_SELF); n++;
  XtSetArg(args[n], XmNy, 0); n++;
  XtSetArg(args[n], XmNrightAttachment, XmATTACH_SELF); n++;
  XtSetArg(args[n], XmNwidth, 120); n++;
  XtSetArg(args[n], XmNbottomAttachment, XmATTACH_SELF); n++;
  XtSetArg(args[n], XmNheight, 29); n++;
  tmpLabelString = XmStringCreateLtoR("OK", XmFONTLIST_DEFAULT_TAG);
  XtSetArg(args[n], XmNlabelString, tmpLabelString); n++;
  XtSetArg(args[n], XmNshowAsDefault, TRUE); n++;
  programsettings_ok = XmCreatePushButton(programsettings_form112, "pushButton1", args, n);
  XtManageChild(programsettings_ok);

  XtManageChild(programsettings_form112);


  n = 0;
  XtSetArg(args[n], XmNx, 100); n++;
  XtSetArg(args[n], XmNy, 70); n++;
  tmpLabelString = XmStringCreateLtoR("Image view application", XmFONTLIST_DEFAULT_TAG);
  XtSetArg(args[n], XmNlabelString, tmpLabelString); n++;
  XtSetArg(args[n], XmNrecomputeSize, TRUE ); n++;
  XtSetArg(args[n], XmNalignment, 2 ); n++;
  programsettings_label10 = XmCreateLabel(programsettings, "label1", args, n);
  XtManageChild(programsettings_label10);


  n = 0;
  XtSetArg(args[n], XmNx, 250); n++;
  XtSetArg(args[n], XmNy, 60); n++;
  XtSetArg(args[n], XmNwidth, 330); n++;
  XtSetArg(args[n], XmNmaxLength, 256); n++;
  conf_view_app_str = XmCreateTextField(programsettings, "textField1", args, n);
  XtManageChild(conf_view_app_str);


  n = 0;
  XtSetArg(args[n], XmNx, 140); n++;
  XtSetArg(args[n], XmNy, 30); n++;
  tmpLabelString = XmStringCreateLtoR("scan application", XmFONTLIST_DEFAULT_TAG);
  XtSetArg(args[n], XmNlabelString, tmpLabelString); n++;
  XtSetArg(args[n], XmNrecomputeSize, TRUE ); n++;
  XtSetArg(args[n], XmNalignment, 2 ); n++;
  programsettings_label22 = XmCreateLabel(programsettings, "label2", args, n);
  XtManageChild(programsettings_label22);


  n = 0;
  XtSetArg(args[n], XmNx, 250); n++;
  XtSetArg(args[n], XmNy, 20); n++;
  XtSetArg(args[n], XmNwidth, 330); n++;
  XtSetArg(args[n], XmNmaxLength, 256); n++;
  conf_scan_app_str = XmCreateTextField(programsettings, "textField2", args, n);
  XtManageChild(conf_scan_app_str);


  n = 0;
  XtSetArg(args[n], XmNx, 20); n++;
  XtSetArg(args[n], XmNy, 110); n++;
  tmpLabelString = XmStringCreateLtoR("number of colors to use for prescan", XmFONTLIST_DEFAULT_TAG);
  XtSetArg(args[n], XmNlabelString, tmpLabelString); n++;
  XtSetArg(args[n], XmNrecomputeSize, TRUE ); n++;
  XtSetArg(args[n], XmNalignment, 2 ); n++;
  programsettings_label34 = XmCreateLabel(programsettings, "label3", args, n);
  XtManageChild(programsettings_label34);


  n = 0;
  XtSetArg(args[n], XmNx, 250); n++;
  XtSetArg(args[n], XmNy, 100); n++;
  XtSetArg(args[n], XmNwidth, 70); n++;
  XtSetArg(args[n], XmNmaxLength, 256); n++;
  conf_col_nr = XmCreateTextField(programsettings, "textField3", args, n);
  XtManageChild(conf_col_nr);


  n = 0;
  XtSetArg(args[n], XmNx, 340); n++;
  XtSetArg(args[n], XmNy, 110); n++;
  tmpLabelString = XmStringCreateLtoR("(max 256)", XmFONTLIST_DEFAULT_TAG);
  XtSetArg(args[n], XmNlabelString, tmpLabelString); n++;
  XtSetArg(args[n], XmNrecomputeSize, TRUE ); n++;
  XtSetArg(args[n], XmNalignment, 1 ); n++;
  programsettings_label46 = XmCreateLabel(programsettings, "label4", args, n);
  XtManageChild(programsettings_label46);


  n = 0;
  XtSetArg(args[n], XmNx, 0); n++;
  XtSetArg(args[n], XmNy, 140); n++;
  XtSetArg(args[n], XmNwidth, 600); n++;
  XtSetArg(args[n], XmNmargin, 0 ); n++;
  programsettings_separator210 = XmCreateSeparator(programsettings, "separator2", args, n);
  XtManageChild(programsettings_separator210);

  XtAddCallback(programsettings_cancel, XmNactivateCallback, (XtCallbackProc) programsettings_cancel_cb, (XtPointer)NULL);
  XtAddCallback(programsettings_ok, XmNactivateCallback, (XtCallbackProc) programsettings_ok_cb, (XtPointer)NULL);
  /* Finit-functions */
XmTextSetString(conf_scan_app_str,conf_scan_app);
XmTextSetString(conf_view_app_str,conf_view_app);
MTextSetInt(conf_col_nr,conf_color_num);

XtVaSetValues(programsettings,XmNdefaultButton,programsettings_ok,0);

  XtManageChild(programsettings);


  if(tmpLabelString) XmStringFree(tmpLabelString);
  return programsettings;
}


/*************************************************************************** 
 * 
 * Funktionsname:	selectpreset_Create
 * 
 * 
 * Input:		Widget parent
 * 
 * Return:		Widget main
 * 
 * Dokumentation:		
 * 
 * 
 ***************************************************************************/

static Widget selectpreset_Create(Widget parent)
{
  Arg args[40];
  Cardinal n;
  Widget MainShell;
  XmString tmpLabelString = NULL;
  Widget selectpreset;
  Widget selectpreset_form12;
  Widget selectpreset_form12_frame10;
  Widget preset_close;


  n = 0;
  XtSetArg(args[n], XmNwidth, 301); n++;
  XtSetArg(args[n], XmNheight, 315); n++;
  XtSetArg(args[n], XmNtitle, "select preset"); n++;
  MainShell = (Widget)XmCreateDialogShell(parent,"form4_Dialog",args, n);


  n = 0;
  XtSetArg(args[n], XmNwidth, 301); n++;
  XtSetArg(args[n], XmNheight, 315); n++;
  XtSetArg(args[n], XmNautoUnmanage, FALSE); n++;
  XtSetArg(args[n], XmNdialogStyle, XmDIALOG_FULL_APPLICATION_MODAL); n++;
  selectpreset = XmCreateForm(MainShell, "form4", args, n);

  n = 0;
  XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n++;
  XtSetArg(args[n], XmNx, 0); n++;
  XtSetArg(args[n], XmNtopAttachment, XmATTACH_NONE); n++;
  XtSetArg(args[n], XmNy, 264); n++;
  XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;
  XtSetArg(args[n], XmNwidth, 301); n++;
  XtSetArg(args[n], XmNbottomAttachment, XmATTACH_FORM); n++;
  XtSetArg(args[n], XmNheight, 51); n++;
  selectpreset_form12_frame10 = XmCreateFrame(selectpreset, "frame1", args, n);
  XtManageChild(selectpreset_form12_frame10);

  n=0;
  XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n++;
  XtSetArg(args[n], XmNx, 0); n++;
  XtSetArg(args[n], XmNtopAttachment, XmATTACH_NONE); n++;
  XtSetArg(args[n], XmNy, 264); n++;
  XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;
  XtSetArg(args[n], XmNwidth, 301); n++;
  XtSetArg(args[n], XmNbottomAttachment, XmATTACH_FORM); n++;
  XtSetArg(args[n], XmNheight, 51); n++;
  selectpreset_form12 = XmCreateForm(selectpreset_form12_frame10, "form1", args, n);

  n = 0;
  XtSetArg(args[n], XmNleftAttachment, XmATTACH_SELF); n++;
  XtSetArg(args[n], XmNx, 154); n++;
  XtSetArg(args[n], XmNtopAttachment, XmATTACH_SELF); n++;
  XtSetArg(args[n], XmNy, 7); n++;
  XtSetArg(args[n], XmNrightAttachment, XmATTACH_SELF); n++;
  XtSetArg(args[n], XmNwidth, 135); n++;
  XtSetArg(args[n], XmNbottomAttachment, XmATTACH_SELF); n++;
  XtSetArg(args[n], XmNheight, 31); n++;
  tmpLabelString = XmStringCreateLtoR("close", XmFONTLIST_DEFAULT_TAG);
  XtSetArg(args[n], XmNlabelString, tmpLabelString); n++;
  preset_close = XmCreatePushButton(selectpreset_form12, "pushButton1", args, n);
  XtManageChild(preset_close);

  XtManageChild(selectpreset_form12);


  n = 0;
  XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n++;
  XtSetArg(args[n], XmNx, 0); n++;
  XtSetArg(args[n], XmNtopAttachment, XmATTACH_FORM); n++;
  XtSetArg(args[n], XmNy, 0); n++;
  XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;
  XtSetArg(args[n], XmNwidth, 301); n++;
  XtSetArg(args[n], XmNheight, 264); n++;
  XtSetArg(args[n], XmNselectionPolicy, 0); n++;
  XtSetArg(args[n], XmNlistSizePolicy, XmCONSTANT); n++;
  preset_list = XmCreateScrolledList(selectpreset, "list1", args, n);
  XtManageChild(preset_list);

  XtAddCallback(preset_list, XmNsingleSelectionCallback, (XtCallbackProc) preset_list_cb, (XtPointer)NULL);
  XtAddCallback(preset_list, XmNdefaultActionCallback, (XtCallbackProc) preset_list_dcb, (XtPointer)NULL);
  XtAddCallback(preset_close, XmNactivateCallback, (XtCallbackProc) preset_close_cb, (XtPointer)NULL);

  /* GENERATE ADDITIONAL ATTACHMENTS */
  n=0;
  XtSetArg(args[n], XmNbottomAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(args[n], XmNbottomWidget, selectpreset_form12); n++;
  XtSetValues(XtParent(preset_list), args, n);
  /* Finit-functions */
{
  FILE	*fil;
  char	str[255];

  XtVaSetValues(selectpreset,XmNdefaultButton,preset_close,0);

  fil = fopen(".scan","r");
  if(fil)
  {
    while(fgets(str,255,fil))
      if(strncmp(str,"[set]",5) == 0)
      {
	MListAddString(preset_list,&str[6]);
      }

    fclose(fil);
  }





}
  XtManageChild(selectpreset);


  if(tmpLabelString) XmStringFree(tmpLabelString);
  return selectpreset;
}


/*************************************************************************** 
 * 
 * Funktionsname:	savesetupas_Create
 * 
 * 
 * Input:		Widget parent
 * 
 * Return:		Widget main
 * 
 * Dokumentation:		
 * 
 * 
 ***************************************************************************/

static Widget savesetupas_Create(Widget parent)
{
  Arg args[40];
  Cardinal n;
  Widget MainShell;
  XmString tmpLabelString = NULL;
  Widget savesetupas;
  Widget savesetupas_separator12;
  Widget save_ok;
  Widget save_exit;


  n = 0;
  XtSetArg(args[n], XmNwidth, 326); n++;
  XtSetArg(args[n], XmNheight, 112); n++;
  XtSetArg(args[n], XmNtitle, "save setup as"); n++;
  MainShell = (Widget)XmCreateDialogShell(parent,"form5_Dialog",args, n);


  n = 0;
  XtSetArg(args[n], XmNwidth, 326); n++;
  XtSetArg(args[n], XmNheight, 112); n++;
  XtSetArg(args[n], XmNautoUnmanage, FALSE); n++;
  XtSetArg(args[n], XmNnoResize, TRUE); n++;
  savesetupas = XmCreateForm(MainShell, "form5", args, n);

  n = 0;
  XtSetArg(args[n], XmNx, 9); n++;
  XtSetArg(args[n], XmNy, 9); n++;
  XtSetArg(args[n], XmNwidth, 312); n++;
  XtSetArg(args[n], XmNmaxLength, 256); n++;
  save_name = XmCreateTextField(savesetupas, "textField1", args, n);
  XtManageChild(save_name);


  n = 0;
  XtSetArg(args[n], XmNx, 0); n++;
  XtSetArg(args[n], XmNy, 57); n++;
  XtSetArg(args[n], XmNwidth, 328); n++;
  XtSetArg(args[n], XmNmargin, 0 ); n++;
  savesetupas_separator12 = XmCreateSeparator(savesetupas, "separator1", args, n);
  XtManageChild(savesetupas_separator12);


  n = 0;
  XtSetArg(args[n], XmNx, 213); n++;
  XtSetArg(args[n], XmNy, 63); n++;
  XtSetArg(args[n], XmNwidth, 93); n++;
  XtSetArg(args[n], XmNheight, 30); n++;
  tmpLabelString = XmStringCreateLtoR("save", XmFONTLIST_DEFAULT_TAG);
  XtSetArg(args[n], XmNlabelString, tmpLabelString); n++;
  save_ok = XmCreatePushButton(savesetupas, "pushButton1", args, n);
  XtManageChild(save_ok);


  n = 0;
  XtSetArg(args[n], XmNx, 93); n++;
  XtSetArg(args[n], XmNy, 63); n++;
  XtSetArg(args[n], XmNwidth, 102); n++;
  XtSetArg(args[n], XmNheight, 30); n++;
  tmpLabelString = XmStringCreateLtoR("cancel", XmFONTLIST_DEFAULT_TAG);
  XtSetArg(args[n], XmNlabelString, tmpLabelString); n++;
  save_exit = XmCreatePushButton(savesetupas, "pushButton2", args, n);
  XtManageChild(save_exit);

  XtAddCallback(save_ok, XmNactivateCallback, (XtCallbackProc) save_ok_CB, (XtPointer)NULL);
  XtAddCallback(save_exit, XmNactivateCallback, (XtCallbackProc) save_exit_cb, (XtPointer)NULL);
  /* Finit-functions */
  XtVaSetValues(savesetupas,XmNdefaultButton,save_ok,0);

  XtManageChild(savesetupas);


  if(tmpLabelString) XmStringFree(tmpLabelString);
  return savesetupas;
}


static void  scan_reload_cb(Widget parent,  XtPointer data,  XmPushButtonCallbackStruct *cbs)
{
start_prescan();
}


static void  scan_exit_cb(Widget parent,  XtPointer data,  XmPushButtonCallbackStruct *cbs)
{
  exit(0);
}


static void  scan_do_cb(Widget parent,  XtPointer data,  XmPushButtonCallbackStruct *cbs)
{
char kommand[1000];
  struct   sigaction aktion;

  if(scan_pid || main_scan_pid)
  {
    printf("scan already running\n");
    return;
  }

  XtSetSensitive(scan_pre_do,False);
  XtSetSensitive(scan_main_do,False);

  cursor_wait( );

  aktion.sa_handler 	= (void *) prescan_ende;
  aktion.sa_mask 	= SA_NOMASK;
  aktion.sa_flags 	= SA_RESTART;

  if (sigaction (SIGCHLD, &aktion, NULL) != 0)
  { 
    #ifdef DEBUG
      printf("%ld: Kann Signal Handler (SIGCHLD) nicht installieren\n", hole_zeit ());
    #endif
    exit(0);
  }

  if((main_scan_pid = fork())==0)
  {
    char more[100]="";
    int  tone;

    switch(scan_mode)
    {
      case 1:
        break;
      case 2:
        strcat(more," -m");
        break;
      case 3:
        switch(halftoning)
        {
          case 1: tone = 1;   break;
          case 2: tone = 0x00;   break;
          case 3: tone = 0x10;   break;
          case 4: tone = 0x20;   break;
          case 5: tone = 0x80;   break;
          case 6: tone = 0x90;   break;
          case 7: tone = 0xa0;   break;
          case 8: tone = 0xb0;   break;
          case 9: tone = 0xc0;   break;
          case 10:tone = 0xd0;   break;
        }
        sprintf(&more[strlen(more)]," -i -a%d",tone);
        break;
    }

    sprintf(kommand,"exec %s -o output.ppm -x %d -y %d -h %d -w %d -r %d -z %d -b %d %s",
				conf_scan_app,
				(int)(mark_x*effective_dpi/50),
				(int)(mark_y*effective_dpi/50),
				scan_h,
				((scan_w+8)/8) * 8,
				(int)dpi,
				(int)zoom,
				brightness,
				more
							);

    system(kommand);
    sprintf(kommand,conf_view_app,"output.ppm");
    system(kommand);
    exit(0);
  }

  XtAppAddTimeOut(app_context,100,(XtTimerCallbackProc)poll_timer_main,NULL);
  XmTextSetString(scan_stat,"doing mainscan ...");

}


static void  scan_pre_abort_cb(Widget parent,  XtPointer data,  XmPushButtonCallbackStruct *cbs)
{
  system("killall ep_scan");
}


static void  scan_draw_red_cb(Widget parent,  XtPointer data,  XmDrawingAreaCallbackStruct *cbs)
{
  Display   *dpy;

  dpy = XtDisplay(scan_draw);

  if(dpy && XtWindow(scan_draw) && draw_pixmap)  
  {

  XCopyArea(XtDisplay(scan_draw),draw_pixmap,
            XtWindow(scan_draw),
            draw_gc,
      0,0,424,585,0,0);
  }

  if(dpy && XtWindow(scan_draw))  
  {
    if(!draw_pixmap)
    {
      XSetForeground(dpy,draw_gc,color_marker.pixel);
      XFillRectangle(dpy,XtWindow(scan_draw),draw_gc,0,0,424,585);
    }
    scan_draw_mark();
  }
}


static void  scan_color_cb(Widget parent,  XtPointer data,  XmToggleButtonCallbackStruct *cbs)
{
  if(cbs->set)
  {
    XtSetSensitive(scan_dither_list,False);
    scan_mode = 1;
  }
}


static void  scan_grayscale_cb(Widget parent,  XtPointer data,  XmToggleButtonCallbackStruct *cbs)
{
  if(cbs->set)
  {
    XtSetSensitive(scan_dither_list,False);
    scan_mode = 2;
  }
}


static void  scan_bw_cb(Widget parent,  XtPointer data,  XmToggleButtonCallbackStruct *cbs)
{
  if(cbs->set)
  {
    XtSetSensitive(scan_dither_list,True);
    scan_mode = 3;
  }
}


static void  scan_pre_ldpi_cb(Widget parent,  XtPointer data,  XmListCallbackStruct *cbs)
{
char *str;

str = MListGetString(scan_pre_dpi);
if(str)
  {
  dpi = atoi(str);
  set_sffective_dpi();

  free(str);
  }
}


static void  brightness_change_cb(Widget parent,  XtPointer data,  XmScaleCallbackStruct *cbs)
{
  brightness = cbs->value;
}


static void  scan_pre_zoom_drag(Widget parent,  XtPointer data,  XmScaleCallbackStruct *cbs)
{

zoom = cbs->value;

set_sffective_dpi();

}


static void  scan_pre_zoom_cb(Widget parent,  XtPointer data,  XmScaleCallbackStruct *cbs)
{
zoom = cbs->value;

set_sffective_dpi();
}


static void  scan_fix_img_cb(Widget parent,  XtPointer data,  XmToggleButtonCallbackStruct *cbs)
{
if(cbs->set)
  {
  fix_image_size = 1;
  scan_w = MTextGetInt(scan_val_x);
  scan_h = MTextGetInt(scan_val_y);
  set_image_size();
  }
else
  fix_image_size = 0;
}


static void  scan_dither_list_cb(Widget parent,  XtPointer data,  XmListCallbackStruct *cbs)
{
  if(MListGetPosition(scan_dither_list))
  {
    halftoning = MListGetPosition(scan_dither_list);
  }
}


static void  menue_load_setup_cb(Widget parent,  XtPointer data,  XmPushButtonCallbackStruct *cbs)
{
selectpreset_Create(XtParent(parent));
}


static void  menue_save_setup_cb(Widget parent,  XtPointer data,  XmPushButtonCallbackStruct *cbs)
{
savesetupas_Create(XtParent(parent));
}


static void  menue_quit_cb(Widget parent,  XtPointer data,  XmPushButtonCallbackStruct *cbs)
{
  exit(0);
}


static void  menue_fulla4colorscan_cb(Widget parent,  XtPointer data,  XmPushButtonCallbackStruct *cbs)
{
scan_draw_mark();

brightness = 2;
mark_x=0;
mark_y=0;
mark_w=423;
mark_h=584;
dpi=100;
scan_mode=1;
zoom=100;
halftoning=1;
fix_image_size=0;


set_all_values();
scan_draw_mark();
}


static void  menue_fax_cb(Widget parent,  XtPointer data,  XmPushButtonCallbackStruct *cbs)
{
scan_draw_mark();

brightness = -3;
mark_x=0;
mark_y=0;
mark_w=423;
mark_h=584;
dpi=200;
scan_mode=3;
zoom=99;
halftoning=1;
fix_image_size=0;


set_all_values();
scan_draw_mark();

}


static void  menue_colorphoto_cb(Widget parent,  XtPointer data,  XmPushButtonCallbackStruct *cbs)
{
scan_draw_mark();

brightness = 0;
mark_x=15;
mark_y=6;
mark_w=213;
mark_h=160;
dpi=150;
scan_mode=1;
zoom=100;
halftoning=1;
fix_image_size=1;
scan_w = 640;
scan_h = 480;

set_all_values();
scan_draw_mark();

}


static void  menue_opt_info_cb(Widget parent,  XtPointer data,  XmPushButtonCallbackStruct *cbs)
{
scannerinformation_Create(XtParent(parent));
}


static void  menue_settings_cb(Widget parent,  XtPointer data,  XmPushButtonCallbackStruct *cbs)
{
programsettings_Create(XtParent(parent));
}


static void  info_ok_cb(Widget parent,  XtPointer data,  XmPushButtonCallbackStruct *cbs)
{
MCloseDialog(parent);
}


static void  programsettings_cancel_cb(Widget parent,  XtPointer data,  XmPushButtonCallbackStruct *cbs)
{
MCloseDialog(parent);
}


static void  programsettings_ok_cb(Widget parent,  XtPointer data,  XmPushButtonCallbackStruct *cbs)
{
char	*str;

str = XmTextGetString(conf_scan_app_str);
strcpy(conf_scan_app,str);
XtFree(str);

str = XmTextGetString(conf_view_app_str);
strcpy(conf_view_app,str);
XtFree(str);

conf_color_num = MTextGetInt(conf_col_nr);

profile_save();

MCloseDialog(parent);
}


static void  preset_close_cb(Widget parent,  XtPointer data,  XmPushButtonCallbackStruct *cbs)
{
MCloseDialog(parent);
}


static void  preset_list_cb(Widget parent,  XtPointer data,  XmListCallbackStruct *cbs)
{
  char *str;

  str = MListGetString(parent);
  if(str)
  {
    FILE 	*fil;
    char	str1[255];
  
    fil = fopen(".scan","r");
    if(fil)
    {
      while(fgets(str1,255,fil))
        if(strncmp(str1,"[set]",5) == 0)
        {
    	  if(strcmp(str,&str1[6]) == 0)
          {
            fgets(str1,255,fil);
	    scan_draw_mark();
            sscanf(str1,"%f %f %d %d %d %d %d %d %d %d %d %d\n",
		    &dpi,
		       &zoom,
			  &scan_mode,
			     &brightness,
			        &halftoning,
				    &fix_image_size,
				       &scan_w,
					  &scan_h,
					     &mark_x,
					  	&mark_y,
						   &mark_w,
						      &mark_h
		);

            set_all_values();            
	    scan_draw_mark();
            break;
          }
        }

      fclose(fil);
    }



    XtFree(str);
  }
}


static void  preset_list_dcb(Widget parent,  XtPointer data,  XmListCallbackStruct *cbs)
{
MCloseDialog(parent);
}


static void  save_ok_CB(Widget parent,  XtPointer data,  XmPushButtonCallbackStruct *cbs)
{
  FILE *fil;
  char	*str;


  fil = fopen(".scan","a");
  if(fil)
  {
    str = XmTextGetString(save_name);
    if(str)
    {
       fprintf(fil,"[set] %s\n",str);
       fprintf(fil,"%f %f %d %d %d %d %d %d %d %d %d %d\n",
		    dpi,
		       zoom,
			  scan_mode,
			     brightness,
			        halftoning,
				    fix_image_size,
				       scan_w,
					  scan_h,
					     mark_x,
					  	mark_y,
						   mark_w,
						      mark_h
		);
       XtFree(str);
    }
    fclose(fil);
  }



  MCloseDialog(parent);
}


static void  save_exit_cb(Widget parent,  XtPointer data,  XmPushButtonCallbackStruct *cbs)
{
MCloseDialog(parent);
}

int reload_prescan(void) 
{

  if(draw_pixmap)
  {
/*    XFreePixmap(draw_pixmap); */
    draw_pixmap = 0L;
  }

  XmTextSetString(scan_stat,"reading prescan image ...");
  draw_pixmap = MLoadXPM(scan_draw,"/tmp/prescan.xpm");
  if(draw_pixmap)
  {
    scan_draw_red_cb(scan_draw,NULL,NULL);
  }

  cursor_normal( );
  XmTextSetString(scan_stat,"ready");
  return 1;
}

/*-------------------------------------------------------------------*/
/* Cursor auf "warten" setzen                                        */
/*-------------------------------------------------------------------*/
void cursor_wait( void )
{
Widget widget;

widget = scan_draw;
if(widget && XtWindow(widget))
  {
  cursor = XCreateFontCursor(XtDisplay(widget), XC_watch);
  XDefineCursor(XtDisplay(widget),XtWindow(widget),cursor);
  XFlush(XtDisplay(widget));
  }
}

/*-------------------------------------------------------------------*/
/* Cursor auf "normal" setzen                                        */
/*-------------------------------------------------------------------*/
void cursor_normal( void )
{
Widget widget;

widget = scan_draw;
if(cursor && widget && XtWindow(widget))
  {
  XUndefineCursor(XtDisplay(widget),XtWindow(widget));
  XFreeCursor(XtDisplay(widget),cursor);
  cursor = 0L;
  }
}

void mark_klick(Widget widget, XEvent *event, String *args, int *num_args)
{
  static int mode=0;   /* welche Ecke hat er gefasst */
  int	x,y;

  x = event->xbutton.x;
  y = event->xbutton.y;
  if(strcmp(args[0],"down") == 0)
  {
    if( x > mark_x -10 && x <= mark_x && y > mark_y-10 && y <= mark_y)
    {
      mode=1;
      offset_x = mark_x - x;
      offset_y = mark_y - y;
    }
    if( x > mark_x+mark_w && x <= mark_x+mark_w+10 && y > mark_y-10 && y <= mark_y)
    {
      mode=2;
      offset_x = mark_x+mark_w - x;
      offset_y = mark_y - y;
    }
    if( x > mark_x+mark_w && x <= mark_x+mark_w+10 && y > mark_y+mark_h && y <= mark_y+mark_h+10)
    {
      mode=3;
      offset_x = mark_x+mark_w - x;
      offset_y = mark_y+mark_h - y;
    }
    if( x > mark_x -10 && x <= mark_x && y > mark_y+mark_h  && y <= mark_y+mark_h+10)
    {
      mode=4;
      offset_x = mark_x - x;
      offset_y = mark_y+mark_h - y;
    }

    if( x > mark_x && x <= mark_x+mark_w && y > mark_y  && y <= mark_y+mark_h)
    {
      mode=5;
      offset_x = mark_x - x;
      offset_y = mark_y - y;
    }

	/* if Image ist fixed, no resize is allowed */
  if(fix_image_size && mode != 5)
    {
      mode=5;
      offset_x = mark_x - x;
      offset_y = mark_y - y;
    }


  }

  if(strcmp(args[0],"up") == 0)
    mode = 0;

  if(strcmp(args[0],"motion") == 0)
  {
    scan_draw_mark();

    switch(mode)
    {
      case 1:
        mark_w = mark_x + mark_w - (x + offset_x);
        mark_h = mark_y + mark_h - (y + offset_y);
        mark_x = x + offset_x;
        mark_y = y + offset_y;
        break;

      case 2:
        mark_h = mark_y + mark_h - (y + offset_y);
        mark_y = y + offset_y;
        mark_w = x + offset_x - mark_x;
        break;

      case 3:
        mark_w = x + offset_x - mark_x;
        mark_h = y + offset_y - mark_y;
        break;

      case 4:
        mark_w = mark_x + mark_w - (x + offset_x);
        mark_x = x + offset_x;
        mark_h = y + offset_y - mark_y;
        break;

      case 5:
        mark_x = x + offset_x;
        mark_y = y + offset_y;
        break;
    }

  if(mark_x + mark_w > 424)   
     mark_x = 424 - mark_w; 
  if(mark_y + mark_h > 585)   
     mark_y = 585 - mark_h;  

  if(mark_x < 0)
    mark_x = 0;
  if(mark_y < 0)
    mark_y = 0;

    scan_draw_mark();  
    if(mode != 5 && mode != 0)
    {
      set_image_size();
    }
  }
}

void scan_draw_mark(void) 
{ 
  Display   *dpy;

  dpy = XtDisplay(scan_draw);

  XSetForeground(dpy,draw_gc,color_marker.pixel);

  XSetFunction(dpy,draw_gc,GXxor);

  XDrawLine(dpy,XtWindow(scan_draw),draw_gc,mark_x,mark_y,mark_x+mark_w,mark_y);
  XDrawLine(dpy,XtWindow(scan_draw),draw_gc,mark_x+mark_w,mark_y,mark_x+mark_w,mark_y+mark_h);
  XDrawLine(dpy,XtWindow(scan_draw),draw_gc,mark_x+mark_w,mark_y+mark_h,mark_x,mark_y+mark_h);
  XDrawLine(dpy,XtWindow(scan_draw),draw_gc,mark_x,mark_y+mark_h,mark_x,mark_y);
  XFillRectangle(dpy,XtWindow(scan_draw),draw_gc,mark_x-10,mark_y-10,10,10);
  XFillRectangle(dpy,XtWindow(scan_draw),draw_gc,mark_x+mark_w,mark_y-10,10,10);
  XFillRectangle(dpy,XtWindow(scan_draw),draw_gc,mark_x-10,mark_y+mark_h,10,10);
  XFillRectangle(dpy,XtWindow(scan_draw),draw_gc,mark_x+mark_w,mark_y+mark_h,10,10);

  XSetFunction(dpy,draw_gc,GXcopy);

}

int start_prescan(void) 
{  
  struct   sigaction aktion;

  if(scan_pid || main_scan_pid)
  {
    printf("es laeuft bereits ein Scan !\n");
    return;
  }

  XtSetSensitive(scan_pre_do,False);
  XtSetSensitive(scan_main_do,False);

  cursor_wait( );

  aktion.sa_handler 	= (void *) prescan_ende;
  aktion.sa_mask 	= SA_NOMASK;
  aktion.sa_flags 	= SA_RESTART;

  if (sigaction (SIGCHLD, &aktion, NULL) != 0)
  { 
    #ifdef DEBUG
      printf("%ld: Kann Signal Handler (SIGCHLD) nicht installieren\n", hole_zeit ());
    #endif
    exit(0);
  }

  if((scan_pid = fork())==0)
  {
    char kommand[1000];

    sprintf(kommand,"%s -r 50 -w 424 -h 585 -f -o /tmp/prescan.ppm -b %d",
				conf_scan_app,
				brightness);

    system(kommand);
    sprintf(kommand,"cat /tmp/prescan.ppm | ppmquant %d | ppmtoxpm >/tmp/prescan.xpm",conf_color_num);
    system(kommand);
    unlink("/tmp/prescan.ppm"); 
    exit(0);
  }

  XtAppAddTimeOut(app_context,100,(XtTimerCallbackProc)poll_timer,NULL);
  XmTextSetString(scan_stat,"doing prescan ...");
}

int prescan_ende(void)
{
int	erg,status;

  if(scan_pid)  
  {
  erg = waitpid(scan_pid,&status, WNOHANG);
  if(erg > 0)
    {
      scan_pid = 0;
    }
  }

  if(main_scan_pid)  
  {
    erg = waitpid(main_scan_pid,&status, WNOHANG);
    if(erg > 0)
    {
      main_scan_pid = 0;
    }
  }
}

int set_sffective_dpi(void) 
{

effective_dpi = zoom * dpi / 100.0;

MTextSetInt(scan_eff_dpi, (int)effective_dpi);

if(fix_image_size)
  ;

set_image_size();
}

int poll_timer(void) 
{
 if(scan_pid)
   XtAppAddTimeOut(app_context,100,(XtTimerCallbackProc)poll_timer,NULL);
 else
 {
   XtSetSensitive(scan_pre_do,True);
   XtSetSensitive(scan_main_do,True);
   reload_prescan();
 }
}

int set_image_size(void) 
{

  if(fix_image_size)
  {
    scan_draw_mark();
    mark_w = (int)((float)scan_w / (effective_dpi/50));
    mark_h = (int)((float)scan_h / (effective_dpi/50));
    scan_draw_mark();

  }
  else
  {
    scan_w = (int)mark_w*effective_dpi/50;
    scan_h = (int)mark_h*effective_dpi/50;
    MTextSetInt(scan_val_x, scan_w);
    MTextSetInt(scan_val_y, scan_h);
  }

}

int poll_timer_main(void) {

 if(main_scan_pid)
   XtAppAddTimeOut(app_context,100,(XtTimerCallbackProc)poll_timer_main,NULL);
 else
  {
   XtSetSensitive(scan_pre_do,True);
   XtSetSensitive(scan_main_do,True);
  cursor_normal( );
  XmTextSetString(scan_stat,"ready");
  }
}

/*-------------------------------------------------------------*/
/* checking scanner Resolutions form status Block	       */
/*-------------------------------------------------------------*/

int test_ident(char *filename) 
{

unsigned char buffer[1000];
char str[100];
int		ptr,anz;
FILE		*fil;


fil = fopen(filename,"r");
if(!fil)
  {
  printf("unable to read Scanner ID block from %s\n",filename);
  return;
  }
anz = fread(buffer,1,1000,fil);
ptr = 0;
scanner_anz_reso = 0;

while(ptr < anz)
  {
  switch(buffer[ptr])
    {
    case 'B' :
      scanner_level = buffer[ptr+1]-'0';  /* Level einlesen */
      ptr +=2;			/* ID Level */
      break;

    case 'R' :          /* resolution */
      scanner_reso[scanner_anz_reso] = buffer[ptr+1] + 256 * buffer[ptr+2];
      scanner_anz_reso++;
      ptr+=3;           /* 3 Bytes    */
      break;

    case 'A' :          /* resolution */
      scanner_max_w = buffer[ptr+1] + 256 * buffer[ptr+2];
      scanner_max_h = buffer[ptr+3] + 256 * buffer[ptr+4];
      ptr+=5;           /* 5 Bytes    */
      break;

    default:
      ptr++;
      break;
    }
  }

scanner_max_reso = 10;
for(anz=0;anz<scanner_anz_reso;anz++)
  if(scanner_reso[anz] > scanner_max_reso)
    scanner_max_reso = scanner_reso[anz];
}

void profile_save(void) 
{
  FILE *fil,*fil1;
  char	str[256];

  fil = fopen(".scan~","w");
  if(!fil)
  {
    printf("unable to save profile\n");
    return;
  }
  fprintf(fil,"%s\n",conf_scan_app);
  fprintf(fil,"%s\n",conf_view_app);
  fprintf(fil,"%d\n",conf_color_num);

  fprintf(fil,"[presets]\n");
  fil1 = fopen(".scan","r");
  if(fil1)
  {
    while(fgets(str,255,fil1))
      if(strncmp(str,"[presets]",9) == 0) break;
    while(fgets(str,255,fil1))
      fputs(str,fil);
    fclose(fil1);	/* leave all other lines untouched */
  }
  fclose(fil);
  system("mv -f .scan~ .scan");
}

void profile_load(void) 
{
  FILE *fil;
  char	str[255];

  fil = fopen(".scan","r");
  if(!fil)
  {
    printf("unable to read profile\n");
    return;
  }
  fgets(str,255,fil);
  sscanf(str,"%[^\n]s",conf_scan_app);
  fgets(str,255,fil);
  sscanf(str,"%[^\n]s",conf_view_app);
  fscanf(fil,"%d",&conf_color_num);
  fclose(fil);

}

int set_all_values(void) 
{
  char	str[20];
  XmString xm_str;

  XmScaleSetValue(scan_pre_zoom,(int)zoom);
  XmScaleSetValue(scan_brightness,brightness);

  XtVaSetValues(scan_color,XmNset,False,NULL);
  XtVaSetValues(scan_grayscale,XmNset,False,NULL);
  XtVaSetValues(scan_bw,XmNset,False,NULL);
  switch(scan_mode)
  {
    case 1:
      XtSetSensitive(scan_dither_list,False);
      XtVaSetValues(scan_color,XmNset,True,NULL);
      break;
    case 2:
      XtSetSensitive(scan_dither_list,False);
      XtVaSetValues(scan_grayscale,XmNset,True,NULL);
      break;
     case 3:
      XtSetSensitive(scan_dither_list,True);
      XtVaSetValues(scan_bw,XmNset,True,NULL);
      XmListSelectPos(scan_dither_list,halftoning,True);
      break;
  }

  sprintf(str,"%d dpi",(int)dpi);
  xm_str = MStringCreate(str);
  XmListSelectItem(scan_pre_dpi,xm_str,True);
  XmStringFree(xm_str);

  set_image_size();
  MTextSetInt(scan_val_x, scan_w);
  MTextSetInt(scan_val_y, scan_h);

  if(fix_image_size)
    XtVaSetValues(scan_pre_fix,XmNset,True,NULL);
  else
    XtVaSetValues(scan_pre_fix,XmNset,False,NULL);

  set_sffective_dpi();

}

