# This file is a part of TkFax.
# TkFax Configuration

#
# Directories and files

set fax(curdir)		[pwd]
set fax(userdir)	$env(HOME)/.tkfax
set fax(tmpdir)		$fax(userdir)/tmp
set fax(pbookdir)	$fax(userdir)/pbook
set fax(texdir)		$fax(userdir)/tex
set fax(systexdir)	$fax(libdir)/tex
set fax(spooldir)	/var/spool/fax
set fax(incomingdir)	/var/spool/fax/incoming
set fax(outgoingdir)	/var/spool/fax/outgoing

set fax(userconfigfile)	$fax(userdir)/config.tcl
set fax(pbookgroupfile)	$fax(pbookdir)/group.pbd

#
# external commands

set fax(convert)	{convert}
set fax(editcmd)	{xterm -e vi}
set fax(dvips)		{dvips}
set fax(faxspool)	{faxspool}
set fax(faxqueue)	{faxq}
set fax(g32pbm)		{g32pbm}
set fax(ghostscript)	{gs}
set fax(gstextfont)	{Courier-Bold10}
set fax(latex)		{latex}
set fax(pbm2g3)		{pbm2g3}
set fax(pbm2ps)		{pbmtolps}
set fax(pbmscale)	{pnmscale -xysize 2479 3508 2>/dev/null | pgmtopbm -fs}
set fax(pbmtolj)	{pbmtolj -resolution 300}
set fax(printcmd)	{lpr -Plp}
# printertype: lj, ljs, ps
set fax(printertype)	{lj}
set fax(sendfax)	{/usr/sbin/sendfax -v}
set fax(viewer)		{viewfax}
set fax(xterm)		{xterm}

#
# Initial settings

set fax(spooling) 0
set fax(queueautoupdate) 1
set fax(queueautoupdateperiod) 30
set fax(queueshowjobs) w
set fax(receivedcollectpages) 1
set fax(cleartmpdiratexit) 1

#
# Custom styles

set fax(custom) {
    { {Cov(en)} cover-en.tex }
    { {Cov(kr)} cover-kr.tex }
    { {Plain}   plain.tex }
    { {Text}    text.tex }
}
set fax(customstyle) 0

#
# Fonts and colors

set fax(f1) "-adobe-helvetica-bold-r-*--12-120-*-*-*-*-*-*"
set fax(f2) "-adobe-helvetica-bold-r-*--14-140-*-*-*-*-*-*"
set fax(f3) "-adobe-helvetica-bold-r-*--16-160-*-*-*-*-*-*"

set fax(c1) "blue"

#
# Window configurations

option add *background		#dfdfdf
option add *foreground		#000000
option add *activeBackground 	#ffc0cb
option add *activeForeground	#000000
option add *selectBackground	#ffc0cb
option add *selectForeground	#000000

