# This file is a part of TkFax.
#

#
# Main window of TkFax
#

proc fax_main_window { wn } {
    global fax

    #
    # Principal frames -- three horizontal frames

    set fax(mwn) $wn
    frame $wn.t -bd 1 -relief ridge
    frame $wn.m -bd 1
    frame $wn.b -bd 2 -relief groove
    pack $wn.t $wn.m $wn.b -side top -fill both

    #
    # Top frame: menus ===============================

    set w $wn.t
    button $w.1 -text Quit -command fax_exit -width 8 -relief groove
    menubutton $w.2 -text Config  -menu $w.2.m -width 8 -underline 0
    menubutton $w.4 -text Help    -menu $w.4.m -width 8 -underline 0
    label $w.l -text "$fax(progname) $fax(version)" \
          -pady 0 -fg red -font -*-times-bold-r-*--14-140-*
    pack $w.1 $w.2 $w.4 -side left
    pack $w.l -side right
    menu $w.2.m -tearoff false
    menu $w.4.m -tearoff false
    $w.2.m add command -label {Edit config file} -command fax_edit_config
    $w.4.m add command -label About  -command fax_about
    $w.4.m add command -label Guide  -command fax_guide

    #
    # Main (or middle) frame ===============================
    # Three vertical frames:
    # Page List + Page manipulation buttons + Dialing & queuing

    set wm $wn.m
    frame $wm.1 -bd 5
    frame $wm.2 -bd 5
    frame $wm.3 -bd 5
    pack $wm.1 $wm.2 $wm.3 -side left -fill y -expand yes

    #
    # Page List -----------------

    set wl $wm.1
    label $wl.1 -text "Page List"
    listbox $wl.2 -width 20 -height 9 -font $fax(f1) -fg $fax(c1) \
            -yscrollcommand "$wl.3 set" -xscrollcommand "$wl.4 set"
    scrollbar $wl.3 -orient vertical   -command "$wl.2 yview"
    scrollbar $wl.4 -orient horizontal -command "$wl.2 xview"
    label $wl.5 -text "" -padx 7 -pady 0 -relief sunken
    grid $wl.1 -row 0 -column 0 -rowspan 1 -columnspan 1 -sticky news
    grid $wl.2 -row 1 -column 0 -rowspan 1 -columnspan 1 -sticky news
    grid $wl.3 -row 1 -column 1 -rowspan 1 -columnspan 1 -sticky news
    grid $wl.4 -row 2 -column 0 -rowspan 1 -columnspan 1 -sticky news
    grid $wl.5 -row 2 -column 1 -rowspan 1 -columnspan 1

    #
    # Page Operations -----------------
    # Label and Buttons for page operations

    set wo $wm.2
    label $wo.0 -text "Page Manipulation"
    button $wo.1 -text "Custom"     -command fax_mkpg_custom \
           -width 5 -pady 4 -background \#66cdaa
    set slabel [lindex [lindex $fax(custom) $fax(customstyle)] 0]
    menubutton $wo.2 -text $slabel -menu $wo.2.m \
           -width 7 -padx 3 -pady 5 -relief raised -background \#66cdaa
    menu $wo.2.m -tearoff false
    for {set i 0} {$i < [llength $fax(custom)]} {incr i} {
        set slabel [lindex [lindex $fax(custom) $i] 0]
        $wo.2.m add command -label $slabel -command \
            "set fax(customstyle) $i; $wo.2 configure -text \"$slabel\""
    }
    button $wo.3 -text "File"       -command fax_file_window \
           -width 5 -pady 4 -background \#66cdaa
    button $wo.4 -text "Scan"       -command fax_scan_window \
           -width 5 -pady 4 -background \#66cdaa
    button $wo.5 -text "Up"         -command fax_up_page \
           -width 5 -pady 0 -background \#20b2aa
    button $wo.6 -text "Down"       -command fax_down_page \
           -width 5 -pady 0 -background \#20b2aa
    button $wo.7 -text "View"       -command fax_view_page \
           -width 5 -pady 0 -background \#20b2aa
    button $wo.8 -text "View All"   -command fax_view_all \
           -width 5 -pady 0 -background \#20b2aa
    button $wo.9 -text "Save"       -command fax_save_page \
           -width 5 -pady 0 -background \#20b2aa
    button $wo.a -text "Save All"   -command fax_save_all \
           -width 5 -pady 0 -background \#20b2aa
    button $wo.b -text "Print"      -command fax_print_page \
           -width 5 -pady 0 -background \#20b2aa
    button $wo.c -text "Print All"  -command fax_print_all \
           -width 5 -pady 0 -background \#20b2aa
    button $wo.d -text "Delete"     -command fax_delete_page \
           -width 5 -pady 0 -background \#20b2aa
    button $wo.e -text "Delete All" -command fax_delete_all \
           -width 5 -pady 0 -background \#20b2aa
    grid $wo.0 -row 0 -column 0 -rowspan 1 -columnspan 2 -sticky news -pady 1
    grid $wo.1 -row 1 -column 0 -rowspan 1 -columnspan 1 -sticky news -pady 1
    grid $wo.2 -row 1 -column 1 -rowspan 1 -columnspan 1              -pady 1
    grid $wo.3 -row 2 -column 0 -rowspan 1 -columnspan 1 -sticky news -pady 1
    grid $wo.4 -row 2 -column 1 -rowspan 1 -columnspan 1 -sticky news -pady 1
    grid $wo.5 -row 3 -column 0 -rowspan 1 -columnspan 1 -sticky news -pady 1
    grid $wo.6 -row 3 -column 1 -rowspan 1 -columnspan 1 -sticky news -pady 1
    grid $wo.7 -row 4 -column 0 -rowspan 1 -columnspan 1 -sticky news -pady 1
    grid $wo.8 -row 4 -column 1 -rowspan 1 -columnspan 1 -sticky news -pady 1
    grid $wo.9 -row 5 -column 0 -rowspan 1 -columnspan 1 -sticky news -pady 1
    grid $wo.a -row 5 -column 1 -rowspan 1 -columnspan 1 -sticky news -pady 1
    grid $wo.b -row 6 -column 0 -rowspan 1 -columnspan 1 -sticky news -pady 1
    grid $wo.c -row 6 -column 1 -rowspan 1 -columnspan 1 -sticky news -pady 1
    grid $wo.d -row 7 -column 0 -rowspan 1 -columnspan 1 -sticky news -pady 1
    grid $wo.e -row 7 -column 1 -rowspan 1 -columnspan 1 -sticky news -pady 1

    #
    # Dialing  & Queuing -----------------
    # horizontal frames

    set wd $wm.3
    frame $wd.1 -bd 0
    frame $wd.2 -bd 0
    frame $wd.3 -bd 2 -relief groove
    frame $wd.4 -bd 0
    pack $wd.1 $wd.3 $wd.2 $wd.4 -side top -expand yes -fill x

    #
    # Label Dialing & Queuing

    label $wd.1.1 -text "Dialing & Queuing"
    pack $wd.1.1 -side left -fill x -expand yes

    #
    # Numeric buttons, Phone book, Fax queuing and received buttons

    set wb $wd.2

    foreach i { 1 2 3 4 5 6 7 8 9 0 - < } {
        button $wb._$i -text $i -command "fax_dial $i" \
               -width 1 -padx 4 -pady 0 -background #87ceeb
    }
    button $wb._C -text Clear -command "fax_dial C" \
           -width 5 -padx 2 -pady 0 -background #add8e6
    button $wb._R -text Regist -command "fax_dial R" \
           -width 5 -padx 2 -pady 0 -background #add8e6
    button $wb.pb -text "Phone Book"   -command fax_phonebook \
           -width 12 -padx 0 -pady 0 -background #b0c4de
    button $wb.fr -text "Fax Received" -command fax_received_window \
           -width 12 -padx 0 -pady 0 -background \#afeeee
    frame $wb.sf -bd 2 -relief groove
    label $wb.sf.fs -text "Fax Spool" -width 12 -padx 1 -pady 0
    checkbutton $wb.sf.pd -text "Spooling" -variable fax(spooling) \
           -width 9 -padx 1 -pady 2
    button $wb.sf.fo -text "Fax Outgoing" -command fax_queue_window \
           -width 12 -padx 0 -pady 0 -background \#afeeee
    pack $wb.sf.fs $wb.sf.pd $wb.sf.fo -side top
    grid $wb._1  -row 2 -column 0 -rowspan 1 -columnspan 1
    grid $wb._2  -row 2 -column 1 -rowspan 1 -columnspan 1
    grid $wb._3  -row 2 -column 2 -rowspan 1 -columnspan 1
    grid $wb._4  -row 3 -column 0 -rowspan 1 -columnspan 1
    grid $wb._5  -row 3 -column 1 -rowspan 1 -columnspan 1
    grid $wb._6  -row 3 -column 2 -rowspan 1 -columnspan 1
    grid $wb._7  -row 4 -column 0 -rowspan 1 -columnspan 1
    grid $wb._8  -row 4 -column 1 -rowspan 1 -columnspan 1
    grid $wb._9  -row 4 -column 2 -rowspan 1 -columnspan 1
    grid $wb._0  -row 5 -column 0 -rowspan 1 -columnspan 1
    grid $wb._-  -row 4 -column 3 -rowspan 1 -columnspan 1
    grid $wb._<  -row 4 -column 4 -rowspan 1 -columnspan 1
    grid $wb._C  -row 2 -column 3 -rowspan 1 -columnspan 2
    grid $wb._R  -row 3 -column 3 -rowspan 1 -columnspan 2
    grid $wb.pb  -row 5 -column 1 -rowspan 1 -columnspan 5
    grid $wb.sf  -row 3 -column 6 -rowspan 3 -columnspan 1
    grid $wb.fr  -row 2 -column 6 -rowspan 1 -columnspan 1

    label $wd.3.1 -text "Number"    -width 8 -anchor w
    entry $wd.3.2 -textvariable fax(number) \
          -width 20 -font $fax(f1) -fg $fax(c1)
    label $wd.3.3 -text "Recipient" -width 8 -anchor w
    entry $wd.3.4 -textvariable fax(recipient) \
          -width 20 -font $fax(f1) -fg $fax(c1)
    grid $wd.3.1 -row 1 -column 1 -rowspan 1 -columnspan 1 -sticky news
    grid $wd.3.2 -row 1 -column 2 -rowspan 1 -columnspan 1 -sticky news
    grid $wd.3.3 -row 2 -column 1 -rowspan 1 -columnspan 1 -sticky news
    grid $wd.3.4 -row 2 -column 2 -rowspan 1 -columnspan 1 -sticky news

    #
    # SEND button

    button $wd.4.1 -text "SEND" -command fax_SEND \
           -width 10 -pady 4 -background #4682b4
    pack $wd.4.1 -side left -fill x -expand yes

    # ===============================

    #
    # Dialog channel

    label $wn.b.0 -text "Message:" -pady 4
    label $wn.b.1 -anchor w -fg red -wraplength 6i -justify left
    pack $wn.b.0 $wn.b.1 -side left

    #
    # For global window calling

    set fax(pagelist) $wl.2
    set fax(messagewin) $wn.b.1

    #
    # Mouse button binding and tagging on Window

    bind $fax(pagelist) <Double-Button-1> fax_view_page

    #
    # Initialization

    fax_update_pagelist
}

#
# Procedures for Page Operations
#

proc fax_up_page {} {
    global fax
    if {[set t [$fax(pagelist) curselection]] != {} && $t > 0} {
        set u [expr $t-1]
        set tmp $fax($u)
        set fax($u) $fax($t)
        set fax($t) $tmp
        fax_update_pagelist
        $fax(pagelist) selection set $u
    }
}

proc fax_down_page {} {
    global fax
    if {[set t [$fax(pagelist) curselection]] != {}
        && $t < [expr $fax(c)-1]} {
        set u [expr $t+1]
        set tmp $fax($u)
        set fax($u) $fax($t)
        set fax($t) $tmp
        fax_update_pagelist
        $fax(pagelist) selection set $u
    }
}

proc fax_view_page {} {
    global fax
    if {[set t [$fax(pagelist) curselection]] != {}} {
        fax_exec_bg "$fax(viewer) $fax(tmpdir)/$fax($t)"
    }
}

proc fax_view_all {} {
    global fax
    if $fax(c) {
        for {set pages ""; set i 0} {$i < $fax(c)} {incr i} {
            append pages " $fax(tmpdir)/$fax($i)"
        }
        fax_exec_bg "$fax(viewer) $pages"
    }
}

proc fax_save_page {} {
    global fax
    if {[set t [$fax(pagelist) curselection]] != {}} {

        set wn $fax(mwn).sp
        if [winfo exist $wn] { return }
        toplevel $wn
        wm title $wn "TkFax: Save"

        set fax(spwn) $wn
        set fax(sppn) $fax($t)
        set fax(spfn) $fax(curdir)/$fax($t)
        label $wn.0 -text "Save a fax page $fax($t) as" -pady 5
        entry $wn.1 -textvariable fax(spfn) \
              -width 40 -font $fax(f1) -fg $fax(c1)
        button $wn.2 -text OK     -width 10 -command {
            fax_exec "cp $fax(tmpdir)/$fax(sppn) $fax(spfn)"
            destroy $fax(spwn)
            fax_message "Save: The page $fax(sppn) was save as $fax(spfn)."
        }
        button $wn.3 -text Cancel -width 10 -command {
            destroy $fax(spwn)
        }
      grid $wn.0 -row 0 -column 0 -rowspan 1 -columnspan 2 -sticky news
      grid $wn.1 -row 1 -column 0 -rowspan 1 -columnspan 2 -sticky news
      grid $wn.2 -row 2 -column 0 -rowspan 1 -columnspan 1 -sticky news -pady 4
      grid $wn.3 -row 2 -column 1 -rowspan 1 -columnspan 1 -sticky news -pady 4

    }
}

proc fax_save_all {} {
    global fax
    if $fax(c) {

        set wn $fax(mwn).sp
        if [winfo exist $wn] { return }
        toplevel $wn
        wm title $wn "TkFax: Save"

        set fax(spwn) $wn
        set fax(sppf) $fax(curdir)/fax
        label $wn.0 -text "Save all fax pages with prefix" -pady 5
        entry $wn.1 -textvariable fax(sppf) \
              -width 40 -font $fax(f1) -fg $fax(c1)
        button $wn.2 -text OK     -width 10 -command {
            for {set i 0} {$i < $fax(c)} {incr i} {
                set fn $fax(sppf)-[format "%02d" $i].g3
                fax_exec "cp $fax(tmpdir)/$fax($i) $fn"
            }
            destroy $fax(spwn)
            fax_message "Save: All pages were saved as $fax(sppf)-##.g3"
        }
        button $wn.3 -text Cancel -width 10 -command {
            destroy $fax(spwn)
        }
      grid $wn.0 -row 0 -column 0 -rowspan 1 -columnspan 2 -sticky news
      grid $wn.1 -row 1 -column 0 -rowspan 1 -columnspan 2 -sticky news
      grid $wn.2 -row 2 -column 0 -rowspan 1 -columnspan 1 -sticky news -pady 4
      grid $wn.3 -row 2 -column 1 -rowspan 1 -columnspan 1 -sticky news -pady 4
    }
}

proc fax_print_page {} {
    global fax
    if {[set i [$fax(pagelist) curselection]] != {}} {
        fax_print_fax "$fax(tmpdir)/$fax($i)"
        fax_message "Print: The page $fax($i) was sent to printer."
    }
}

proc fax_print_all {} {
    global fax
    if $fax(c) {
        for {set i 0} {$i < $fax(c)} {incr i} {
            fax_print_fax "$fax(tmpdir)/$fax($i)"
        }
        fax_message "Print: All pages were sent to printer."
    }
}

proc fax_delete_page {} {
    global fax
    if {[set t [$fax(pagelist) curselection]] != {}} {
        set k [tk_dialog .dialog "TkFax Page Delete" \
        "Delete a page $fax($t)?" {} 0 {Confirm} {Cancel}]
        if {$k==1} { return }
        exec rm -f $fax(tmpdir)/$fax($t)
        for {set i $t} {$i < [expr $fax(c)-1]} {incr i} {
            set fax($i) $fax([expr $i+1])
        }
        incr fax(c) -1
        fax_update_pagelist
        if {$t < $fax(c)} {
            $fax(pagelist) selection set $t
        } else {
            $fax(pagelist) selection set [expr $t-1]
        }
        fax_message "Delete: The page $fax($i) was deleted."
    }
}

proc fax_delete_all {} {
    global fax
    if {$fax(c)==0} { return }
    set k [tk_dialog .dialog "TkFax Page Delete" \
    "Delete all pages?" {} 0 {Confirm} {Cancel}]
    if {$k==1} { return }
    for {set i 0} {$i<$fax(c)} {incr i} {
        exec rm -f $fax(tmpdir)/$fax($i)
    }
    set fax(c) 0
    $fax(pagelist) delete 0 end
    fax_message "Delete: All pages were deleted."
}

proc fax_dial { i } {
    global fax
    if {$i=="R"} {
        if { $fax(number) != {} } {
            set line "$fax(number)\t$fax(recipient)\t\t"
            lappend fax(group-Misc) $line
            fax_message \
                "Regist: The current faxnumber is registered in Misc group."
        }
    } elseif {$i=="<"} {
        set fax(number) [string range $fax(number) 0 \
                            [expr [string length $fax(number)]-2]]
    } elseif {$i=="C"} {
        fax_number_clear
    } else {
        append fax(number) $i
    }
}

proc fax_number_clear {} {
    global fax
    set fax(number) ""
    set fax(recipient) ""
    set fax(reference) ""
    set fax(description) ""
}
