# This file is a part of TkFax.
# fax-init.tcl
# This tcl script initiates TkFax.

# Read fax source files
source $fax(libdir)/fax-about.tcl
source $fax(libdir)/fax-conf.tcl
source $fax(libdir)/fax-faxwin.tcl
source $fax(libdir)/fax-lib.tcl
source $fax(libdir)/fax-file.tcl
source $fax(libdir)/fax-mkpg.tcl
source $fax(libdir)/fax-scan.tcl
source $fax(libdir)/fax-pbook.tcl
source $fax(libdir)/fax-queue.tcl
source $fax(libdir)/fax-received.tcl

# Read scan source files
source $c(libdir)/scan-about.tcl
source $c(libdir)/scan-drivers/$scanner_driver.tcl
source $c(libdir)/scan-conf.tcl
source $c(libdir)/scan-lib.tcl
source $c(libdir)/scan-scan.tcl
source $c(libdir)/scan-out.tcl
source $c(libdir)/scan-scanwin.tcl
source $c(libdir)/scan-file.tcl
source $c(libdir)/scan-win.tcl

# Check if userdir exists. If not, create it.
fax_userdir_check

# Read user configuration file in if exists.
fax_read_userconfig

# Build up phone book database
fax_pbook_read_faxnumberlist

# Initialize some variables
set fax(c) 0
fax_number_clear

# Launch the main window
set arg1 [lindex $argv 0]
switch -- $arg1 {
    -r fax_received_window
    -q fax_queue_window
    -s -
    default {fax_main_window {}}
}

# End
