# This file is a part of TkFax.
# fax-lib.tcl
# Here we collect procedures used in other parts
#

proc fax_SEND {} {
#
# Procedure for sending faxes.
#
    global fax

    # First check if fax page and fax number to be sent exist.

    if {$fax(c)<=0} {
        fax_message "Send: No page to send"
        return
    }

    if {$fax(number)=={}} {
        fax_message "Send: Fax number is empty."
        return
    }

    # Get a fax page list.

    for {set pages "" ; set i 0} {$i < $fax(c)} {incr i} {
        append pages " $fax(tmpdir)/$fax($i)"
    }

    # Run sendfax, or faxspool command if fax(spooling) is on.

    if $fax(spooling) {
        set command "$fax(faxspool) $fax(number) $pages;"
    } else {
        set command "$fax(sendfax) $fax(number) $pages;"
    }
    fax_exec_xterm_wait $command
}

proc fax_about {} {
#
# About TkFax window.
#
    global fax

    set wn $fax(mwn).about
    if [winfo exists $wn] return
    toplevel $wn
    wm title $wn "$fax(progname) $fax(version): About"
    image create photo hbkim -file $fax(libdir)/image/hbkim.gif

    label $wn.l -text $fax(about)
    label $wn.i -image hbkim
    label $wn.j -text $fax(license)
    button $wn.b -width 8 -text OK -command "destroy $wn"
    pack $wn.l $wn.i $wn.j $wn.b -side top
}

proc fax_addto_pagelist { faxes } {
#
# Add faxes to the fax page list.
#
    global fax
    foreach i $faxes {
        set fax($fax(c)) $i
        incr fax(c)
    }
    fax_update_pagelist
}

proc fax_clear_tmpdir {} {
#
# Delete all file in tmp dir.
#
    global fax
    fax_exec "rm -f $fax(tmpdir)/*"
}

proc fax_edit_config {} {
#
# Edit a user configuration file.
#
    global fax
    if ![file exist $fax(userconfigfile)] {
        exec cp $fax(libdir)/fax-conf.tcl $fax(userconfigfile)
    }
    fax_exec "$fax(editcmd) $fax(userconfigfile)"
    fax_message "Restart $fax(progname) to get the change of config file."
}

proc fax_exec { cmd } {
#
# Execute a command in shell in foreground.
#
    return [exec sh -c "$cmd"]
}

proc fax_exec_bg { cmd } {
#
# Execute a command in shell in background.
#
    exec sh -c "$cmd" &
}

proc fax_exec_fg { cmd } {
#
# Execute a command in shell in foreground.
#
  global fax
# $fax(textwindow) delete 1.0 end
  $fax(textwindow) insert end "$cmd\n" red
  set fax(pipe) [open "|/bin/sh -c \"$cmd\" 2>@stdout" r+]
# set fax(pid) [pid $fax(pipe)]
# lappend fax(processlist) [list $fax(pid) $cmd]
  fconfigure $fax(pipe) -buffering none -blocking 0
  fileevent $fax(pipe) readable fax_cmd_out
}

proc fax_exec_xterm { cmd } {
#
# Execute a command on xterm in foreground.
#
    global fax
    exec $fax(xterm) -e sh -c "$cmd"
}

proc fax_exec_xterm_wait { cmd } {
#
# Execute a command on xterm and wait until Return key is hit.
# cmd must contain `;' character.
#
    global fax
    set command "$cmd  echo ; echo Hit Return to finish ... ; read"
    exec $fax(xterm) -e sh -c "$command"
}

proc fax_exit {} {
#
# This is for exiting TkFax.
#
    global fax

    # Save back fax number list.
    fax_pbook_save_faxnumberlist

    # Clear tmp dir if fax(cleartmpdiratexit) is on.
    if $fax(cleartmpdiratexit) fax_clear_tmpdir

    exit
}

proc fax_guide {} {
#
# Text widget containing user guide of TkFax.
#
    global fax

    set wn $fax(mwn).guide
    if [winfo exists $wn] return
    toplevel $wn
    wm title $wn "$fax(progname): Guide"

    frame $wn.b
    pack $wn.b -side top -fill x
    label $wn.b.1 -text "$fax(progname) Guide" -width 15
    button $wn.b.2 -text Close -command "destroy $wn"
    pack $wn.b.1 $wn.b.2 -side left
    frame $wn.u
    pack $wn.u -side top -fill x
    text $wn.u.t -width 68 -height 20 -font $fax(f1) \
                     -yscrollcommand "$wn.u.s set"
    pack $wn.u.t -side left
    scrollbar $wn.u.s -command "$wn.u.t yview" -orient vertical
    pack $wn.u.s -side right -fill y
    $wn.u.t insert end $fax(guide)
}

proc fax_message { text } {
#
# Display message.
#
    global fax
    $fax(messagewin) configure -text $text
}

proc fax_print_fax { g3file } {
#
# Print a g3 format fax file.
#
    global fax
    switch $fax(printertype) {
        lj {set command "$fax(g32pbm) -l $g3file | $fax(printcmd)"}
        ljs {set command "$fax(g32pbm) $g3file | $fax(pbmscale) | pbmtolj -resolution 300 | $fax(printcmd)"}
        ps -
        default {set command "$fax(g32pbm) $g3file | $fax(pbmscale) | pbmtolps | $fax(printcmd)"}
    }
    fax_exec $command
}

proc fax_read_userconfig {} {
#
# Read a user configuration file
#
    global fax env
    if [file exist $fax(userconfigfile)] {
        source $fax(userconfigfile)
    }
}

proc fax_tex_char { string } {
#
# Convert a string to tex format.
#
    set converted ""
    for {set i 0} {$i < [string length $string]} {incr i} {
        set c [string index $string $i]
        case $c {
            / {append converted "\\/"}
            % {append converted "\\\\%"}
            \# {append converted "\\\\#"}
            default {append converted $c}
        }
    }
    return $converted
}

proc fax_update_pagelist {} {
#
# Update the fax page list.
#
    global fax
    $fax(pagelist) delete 0 end
    for {set i 0} {$i < $fax(c)} {incr i} {$fax(pagelist) insert end $fax($i)}
}

proc fax_userdir_check {} {
#
# Check if $fax(userdir) exists. If not, creates it properly.
#
    global fax
    if [file exist $fax(userdir)] {
        if [file isdirectory $fax(userdir)] {
            foreach dir {texdir pbookdir tmpdir} {
                if [file exist $fax($dir)] {
                    if [file isdirectory $fax($dir)] {
                    } else {
                        puts "$fax($dir) exists, but not a directory."
                    }
                } else {
                    exec mkdir $fax($dir)
                }
            }
        } else {
            puts "$fax(userdir) exists, but not a directory."
        }
    } else {
        foreach dir {userdir texdir pbookdir tmpdir} {
            exec mkdir $fax($dir)
        }
        exec echo -e "Misc\tMiscellaneous fax numbers" \
                  > $fax(pbookdir)/group.pbd
        exec touch $fax(pbookdir)/Misc.pbd
    }
}

proc fax_view_fax { files } {
#
# Launch a viewser for fax files in g3 format.
#
    global fax
    set command "$fax(viewer) $files"
    fax_exec_bg $command
}

proc get_prefix { fn } {
#
# Return prefix from a filename.
#
    set p [string last / $fn]
    set q [string last . $fn]
    if {$p < $q} {
        set prefix [string range $fn [expr $p+1] [expr $q-1]]
    } else {
        set prefix [string range $fn [expr $p+1] end]
    }
    return $prefix
}

