# This file is a part of TkFax.
#

#
# This make a cover page.

proc fax_mkpg_custom {} {
#
# This procedure generate custom style fax.
#
    global fax
    set file $fax(tmpdir)/custom$fax(customstyle).tex
    set styfile [lindex [lindex $fax(custom) $fax(customstyle)] 1]

    # If file already exists, ask whether to use old one or replace it
    set i 0
    if [file exist $file] {
        after idle {.dialog.msg configure -wraplength 4i}
        set i [tk_dialog .dialog "TkFax Dialog" \
        "The file $file already exists.  Will you use it or make new one?" \
            {} 0 {Make new one} {Use exsiting one} {Cancel}]
        update
    }

    # Making new file
    if {$i==0} {
        # If user or system format file exists, use it.
        # If not, generate bare format
        set styfile0 $fax(texdir)/$styfile
        set styfile1 $fax(systexdir)/$styfile
        if [file exist $styfile0] {
            set sty $styfile0
        } elseif [file exist $styfile1] {
            set sty $styfile1
        } else {
            fax_message "MkPg: Fax custom style file $styfile is not found."
            return
        }

        set LIBDIR	[fax_tex_char $fax(libdir)]
        set NUMBER	[fax_tex_char $fax(number)]
        set RECIPIENT	[fax_tex_char $fax(recipient)]
        set REFERENCE	[fax_tex_char $fax(reference)]
        set DESCRIPTION	[fax_tex_char $fax(description)]
        set command "sed \
                     -e s/TKFAXDIR/'$LIBDIR'/g \
                     -e s/FAXNUMBER/'$NUMBER'/g \
                     -e s/RECIPIENT/'$RECIPIENT'/g \
                     -e s/REFERENCE/'$REFERENCE'/g \
                     -e s/DESCRIPTION/'$DESCRIPTION'/g \
                     $sty > $file"
        fax_exec $command

    } elseif {$i==2} {
        return
    }

    # Edit file
    fax_exec "$fax(editcmd) $file"

    # Running LaTeX and converting to fax
    fax_tex2dvi $fax(tmpdir)/custom$fax(customstyle)
    fax_dvi2ps custom$fax(customstyle)
    fax_ps2fax custom$fax(customstyle)

}

