# This file is a part of TkFax.
#

proc fax_queue_window {} {
    global fax

    if [info exist fax(mwn)] {
        set wn $fax(mwn).faxq
        set wnn $wn
        if [winfo exist $wn] { return }
        toplevel $wn
        wm title $wn "TkFax: Fax Queue"
    } else {
        set wn {}
        set wnn .
        wm title . "TkFax: Fax Queue"
    }

    # Label
    frame $wn.0 -bd 5
    pack $wn.0 -side top -fill x
    label $wn.0.0 -text "TkFax: Fax Queue Window" \
          -padx 10 -pady 2 -relief ridge
    pack $wn.0.0 -side left -fill x -expand yes

    # List of fax jobs
    frame $wn.1
    pack $wn.1 -side top -fill x

    frame $wn.1.0
    label $wn.1.0.1 -text "Job List:" -anchor w -width 7 -padx 4
    radiobutton $wn.1.0.2 -command fax_queue_update \
                -variable fax(queueshowjobs) -value w -text "Wating"
    radiobutton $wn.1.0.3 -command fax_queue_update \
                -variable fax(queueshowjobs) -value o -text "Old"
    radiobutton $wn.1.0.4 -command fax_queue_update \
                -variable fax(queueshowjobs) -value s -text "Susp"
    radiobutton $wn.1.0.5 -command fax_queue_update \
                -variable fax(queueshowjobs) -value a -text "All"
    button $wn.1.0.a -text Update -command fax_queue_update -width 6 -pady 1
    label $wn.1.0.b -text sec -width 3 -anchor w
    entry $wn.1.0.c -textvariable fax(queueautoupdateperiod) -width 3 \
          -fg blue -font $fax(f1)
    checkbutton $wn.1.0.d -variable fax(queueautoupdate) -text "Update every"
    pack $wn.1.0.1 $wn.1.0.2 $wn.1.0.3 $wn.1.0.4 $wn.1.0.5 -side left
    pack $wn.1.0.a $wn.1.0.b $wn.1.0.c $wn.1.0.d -side right

    frame $wn.1.1
    label $wn.1.1.1 -text "Job ID"    -anchor w -width 10 -padx 3 -relief ridge
    label $wn.1.1.2 -text "Status"    -anchor w -width 10 -padx 3 -relief ridge
    label $wn.1.1.3 -text "Queued by" -anchor w -width 10 -padx 3 -relief ridge
    label $wn.1.1.4 -text "To"        -anchor w -width 17 -padx 3 -relief ridge
    label $wn.1.1.5 -text "Pages"     -anchor w -width 6  -padx 3 -relief ridge
    label $wn.1.1.6 -text "History"   -anchor w -width 12 -padx 3 -relief ridge
    pack $wn.1.1.1 $wn.1.1.2 $wn.1.1.3 $wn.1.1.4 $wn.1.1.5 $wn.1.1.6 \
         -side left -fill x

    text $wn.1.2 -width 72 -height 10 -state disabled \
         -xscroll "$wn.1.3 set" -yscroll "$wn.1.4 set" \
         -tabs {2.8c left 5.6c left 8.3c left 12.8c left 14.3c} \
         -wrap none -relief sunken -font $fax(f1)
    set fax(queuelist) $wn.1.2
    scrollbar $wn.1.3 -command "$wn.1.2 xview" -orient horizontal
    scrollbar $wn.1.4 -command "$wn.1.2 yview"

    label $wn.1.5 -text "" -padx 7 -pady 0 -relief sunken
    label $wn.1.6 -text "" -padx 7 -pady 0 -relief sunken

    grid $wn.1.0 -row 0 -column 0 -rowspan 1 -columnspan 2 -sticky news
    grid $wn.1.1 -row 1 -column 0 -rowspan 1 -columnspan 1 -sticky news
    grid $wn.1.2 -row 2 -column 0 -rowspan 1 -columnspan 1 -sticky news
    grid $wn.1.3 -row 3 -column 0 -rowspan 1 -columnspan 1 -sticky news
    grid $wn.1.4 -row 2 -column 1 -rowspan 1 -columnspan 1 -sticky news
    grid $wn.1.5 -row 3 -column 1 -rowspan 1 -columnspan 1
    grid $wn.1.6 -row 1 -column 1 -rowspan 1 -columnspan 1

    # Message
    label $wn.2 -width 72 -pady 4 -relief ridge -anchor w \
          -wraplength 7.2i -justify left
    set fax(queuemessage) $wn.2
    pack $wn.2 -side top -fill x

    # Buttons
    frame $wn.3 -bd 10
    pack $wn.3 -side top -fill x -expand yes
    button $wn.3.2 -text Delete -width 8 -command fax_queue_delete
    button $wn.3.3 -text View   -width 8 -command fax_queue_view
    button $wn.3.4 -text Close  -width 8 -command "destroy $wnn"
    pack $wn.3.2 $wn.3.3 $wn.3.4 -side left -fill x -expand yes

    # Mouse bindings
    bind $fax(queuelist) <Button> fax_queue_setcur
    bind $fax(queuelist) <Double-Button> fax_queue_view

    # Initialization
    fax_queue_autoupdate
}

proc fax_queue_update {} {
    global fax

    # Clear the job list window.
    $fax(queuelist) configure -state normal
    $fax(queuelist) delete 1.0 end

    # Get the job list from fax outgoing directory.
    switch $fax(queueshowjobs) {
        o {set jobopt "-o"}
        s {set jobopt "-s"}
        a {set jobopt "-a"}
        default {set jobopt ""}
    }
    set command "$fax(faxqueue) -v $jobopt"
    set faxq [open "|$command"]

    # Display the job list.
    set nj 0
    set jobid ""
    set status ""
    set queuedby ""
    set destination ""
    set pages ""
    set STATUS ""
    while 1 {
        set qline [gets $faxq]
        if {$qline=="no jobs."} {
            fax_queue_message "No jobs."
            break
        }
        if {$qline==""} {
            set iline \
            "$jobid\t$status\t$queuedby\t$destination\t$pages\t$STATUS"
            if {$nj && $status!="log"} { $fax(queuelist) insert end $iline\n }
            # Get the last run time of faxrunq.
            set qline [gets $faxq]
            fax_queue_message $qline
            break
        }
        if {[string index $qline 0]=="F"} {
            set iline \
            "$jobid\t$status\t$queuedby\t$destination\t$pages\t$STATUS"
            if {$nj && $status!="log"} { $fax(queuelist) insert end $iline\n }
            incr nj
            set jobid [string range $qline 0 6]
            set status [string range $qline 12 [expr [string last : $qline]-1]]
            if {$status==""} {set status wating}
            set queuedby ""
            set destination ""
            set pages ""
            set STATUS ""
        } else {
            set p [string first : $qline]
            set tag [string range $qline 0 [expr $p-1]]
            set con [string range $qline [expr $p+2] end]
            switch $tag {
                "        Queued by" -
                "\tQueued by" {set queuedby $con}
                "               to" -
                "\t       to" {set destination $con}
                "            Input" -
                "\t    Input" {}
                "            Pages" -
                "\t    Pages" {
                    set lastfile [lindex $con [expr [llength $con]-1]]
                    set pages [string range $lastfile 1 \
                                  [expr [string first .  $lastfile]-1]]
                }
                "           Status" -
                "\t   Status" {append STATUS "$con\t"}
                default {}
            }
        }
    }

    # Finished.
    close $faxq
    $fax(queuelist) delete {end -1 char}
    $fax(queuelist) configure -state disabled
    set fax(queue-jobid) ""
    set fax(queue-pages) ""
}

proc fax_queue_autoupdate {} {
    global fax
    if [winfo exist $fax(queuelist)] {
        fax_queue_update
    }
    if {[winfo exist $fax(queuelist)] && $fax(queueautoupdate)} {
        after [expr $fax(queueautoupdateperiod)*1000] fax_queue_autoupdate
    }
}

proc fax_queue_message { msg } {
    global fax
    $fax(queuemessage) configure -text $msg
}

proc fax_queue_setcur {} {
    global fax
    $fax(queuelist) tag delete cur
    $fax(queuelist) tag configure cur -foreground red -background skyblue
    $fax(queuelist) tag add cur {current linestart} {current lineend +1 char}
    set line [$fax(queuelist) get {current linestart} {current lineend}]
    set elements [split $line \t]
    set fax(queue-jobid) [lindex $elements 0]
    set fax(queue-pages) [lindex $elements 4]
    for {set status "";set i 5} {$i<[llength $elements]} {incr i} {
        append status "[lindex $elements $i]\n"
    }
    fax_queue_message [string range $status 0 [expr [string length $status]-2]]
}

proc fax_queue_delete {} {
#
# Delete a selected outgoing fax from spool area.
#
    global fax
    if {$fax(queue-jobid) != {}} {
        set k [tk_dialog .dialog "TkFax: Queue Delete" \
        "Delete a job $fax(queue-jobid)?" {} 0 {Confirm} {Cancel}]
        if {$k==1} { return }
        exec faxrm $fax(queue-jobid)
        fax_queue_update
    }
}

proc fax_queue_view {} {
#
# View a selected outgoing fax.
#
    global fax
    if {$fax(queue-jobid) != {}} {
        for {set faxes ""; set i 1} {$i<=$fax(queue-pages)} {incr i} {
            append  faxes " $fax(spooldir)/outgoing/$fax(queue-jobid)/f$i.g3"
        }
        fax_view_fax $faxes
    }
}

