# This file is a part of TkFax.
# fax-received.tcl

proc fax_received_window {} {
#
# --- Fax Received Window ---
#
    global fax

    if [info exist fax(mwn)] {
        set wn $fax(mwn).frw
        set wnn $wn
        if [winfo exist $wn] { return }
        toplevel $wn
        wm title $wn "TkFax: Fax Received"
    } else {
        set wn {}
        set wnn .
        wm title . "TkFax: Fax Received"
    }

    # Label of this window
    frame $wn.0 -bd 5
    pack $wn.0 -side top -fill x
    label $wn.0.1 -text "TkFax: Fax Received" \
          -padx 10 -pady 2 -relief ridge
    pack $wn.0.1 -side left -fill x -expand yes

    # Fax List
    frame $wn.4
    pack $wn.4 -side top

    frame $wn.4.0
    label $wn.4.0.0 -text "Received Fax List"
    checkbutton $wn.4.0.1 -variable fax(receivedcollectpages) \
                -text "Collect Pages" -width 15
    button $wn.4.0.2 -text Update -command fax_received_update \
           -width 8 -pady 2
    pack $wn.4.0.0 -side left
    pack $wn.4.0.2 $wn.4.0.1 -side right

    frame $wn.4.1
    label $wn.4.1.1 -text Time  -anchor w -width 12 -padx 3 -relief ridge
    label $wn.4.1.2 -text From  -anchor w -width 19 -padx 3 -relief ridge
    label $wn.4.1.3 -text Pages -anchor w -width  5 -padx 3 -relief ridge
    label $wn.4.1.4 -text Files -anchor w -width 32 -padx 3 -relief ridge
    pack $wn.4.1.1 $wn.4.1.2 $wn.4.1.3 $wn.4.1.4 -side left -fill x

    text $wn.4.2 -width 72 -height 10 -state disabled \
         -tabs {3.2c left 8.5c left 9.5c left} -wrap none \
         -xscroll "$wn.4.3 set" -yscroll "$wn.4.4 set" \
         -relief sunken -font $fax(f1)
    set fax(receivedlist) $wn.4.2
    scrollbar $wn.4.3 -command "$wn.4.2 xview" -orient horizontal
    scrollbar $wn.4.4 -command "$wn.4.2 yview"

    label $wn.4.5 -text "" -padx 7 -pady 0 -relief sunken
    label $wn.4.6 -text "" -padx 7 -pady 0 -relief sunken

    grid $wn.4.0  -row 0 -column 0 -rowspan 1 -columnspan 2 -sticky news
    grid $wn.4.1  -row 1 -column 0 -rowspan 1 -columnspan 1 -sticky news
    grid $wn.4.2  -row 2 -column 0 -rowspan 1 -columnspan 1 -sticky news
    grid $wn.4.3  -row 3 -column 0 -rowspan 1 -columnspan 1 -sticky news
    grid $wn.4.4  -row 2 -column 1 -rowspan 1 -columnspan 1 -sticky news
    grid $wn.4.5  -row 3 -column 1 -rowspan 1 -columnspan 1
    grid $wn.4.6  -row 1 -column 1 -rowspan 1 -columnspan 1

    # Message
    frame $wn.5 -bd 2
    pack $wn.5 -side top -fill x
    label $wn.5.1 -text "Selected File(s)" -width 72 -anchor w
    entry $wn.5.2 -textvariable fax(receivedfile) -width 72 \
          -font $fax(f1) -fg $fax(c1)
    label $wn.5.3 -width 72 -pady 4 -relief ridge -anchor w \
          -wraplength 7.2i -justify left
    set fax(receivedmessage) $wn.5.3
    pack $wn.5.1 $wn.5.2 $wn.5.3 -side top -expand yes -fill x

    # Buttons for fax file operations
    frame $wn.6 -bd 5
    pack $wn.6 -side top -fill x
    button $wn.6.1 -text View   -command fax_received_view   -width 6
    button $wn.6.2 -text Print  -command fax_received_print  -width 6
    button $wn.6.3 -text Save   -command fax_received_save   -width 6
    button $wn.6.4 -text Delete -command fax_received_delete -width 6
    button $wn.6.5 -text Attach -command fax_received_attach -width 6
    button $wn.6.6 -text Close  -command "destroy $wnn"      -width 6
    pack $wn.6.1 $wn.6.2 $wn.6.3 $wn.6.4 $wn.6.5 $wn.6.6 -side left -expand yes

    # When standalone, disable Attach button.
    if {$wn == {}} {
        $wn.6.5 configure -state disabled
    }

    # Mouse bindings
    bind $fax(receivedlist) <Button> fax_received_setcur
    bind $fax(receivedlist) <Double-Button> fax_received_view

    # Fill the received list
    fax_received_update

}

proc fax_received_setcur {} {
    global fax
    $fax(receivedlist) tag delete cur
    $fax(receivedlist) tag configure cur -foreground red -background skyblue
    $fax(receivedlist) tag add cur {current linestart} {current lineend +1 char}
    set line [$fax(receivedlist) get {current linestart} {current lineend}]
    set elements [split $line \t]
    set fax(receivedfile) [lindex $elements 3]
}

proc fax_received_update {} {
    global fax

    # Clear the received list window.
    $fax(receivedlist) configure -state normal
    $fax(receivedlist) delete 1.0 end

    # Get the received list from fax incoming directory.
    set faxr [open "|ls -l -t $fax(incomingdir)"]
    # Discard the first line.
    gets $faxr

    # Display the list.
    set rline [gets $faxr]
    while {"$rline" != {}} {

        set time "[lindex $rline 5] [lindex $rline 6] [lindex $rline 7]"
        set name [lindex $rline 8]
        set prefix [lindex [split $name '.'] 0]
        set pages 1
        set files $name

        if $fax(receivedcollectpages) {
            while 1 {
                set rline [gets $faxr]
                set nname [lindex $rline 8]
                set nprefix [lindex [split $nname '.'] 0]
                if {"$nprefix" == "$prefix" } {
                    incr pages
                    set files "$nname $files"
                } else {
                    break
                }
            }
        } else {
            set rline [gets $faxr]
        }

        set sender [lindex [split $prefix '_'] 1]
        $fax(receivedlist) insert end "$time\t$sender\t$pages\t$files\n"
    }

    close $faxr
    $fax(receivedlist) delete {end -1 char}
    $fax(receivedlist) configure -state disabled
    set fax(receivedfile) ""
}

proc fax_received_view {} {
    global fax
    if {$fax(receivedfile) == {}} {return}
    set files ""
    foreach file $fax(receivedfile) {
        set files "$files $fax(incomingdir)/$file"
    }
    fax_view_fax $files
    fax_received_message "View: $fax(receivedfile)"
}

proc fax_received_print {} {
    global fax
    if {$fax(receivedfile) == {}} {return}
    set wn .fp
    if [winfo exist $wn] { return }
    toplevel $wn
    wm title $wn "TkFax: Print"

    set fax(fpwn) $wn
    label $wn.0 -text "Print the fax \n$fax(receivedfile)\n" \
          -width 40 -wraplength 3.5i -pady 5
    button $wn.2 -text OK     -width 10 -command {
        foreach file $fax(receivedfile) {
            fax_print_fax "$fax(incomingdir)/$file"
        }
        destroy $fax(fpwn)
        fax_received_message "Sent to printer: $fax(receivedfile)"
    }
    button $wn.3 -text Cancel -width 10 -command {
        destroy $fax(fpwn)
    }
    grid $wn.0 -row 0 -column 0 -rowspan 1 -columnspan 2 -sticky news
    grid $wn.2 -row 2 -column 0 -rowspan 1 -columnspan 1 -sticky news -pady 4
    grid $wn.3 -row 2 -column 1 -rowspan 1 -columnspan 1 -sticky news -pady 4
}

proc fax_received_save {} {
    global fax
    if {$fax(receivedfile) == {}} {return}
    set wn .sp
    if [winfo exist $wn] { return }
    toplevel $wn
    wm title $wn "TkFax: Save"

    set fax(spwn) $wn
    set fax(sppf) $fax(curdir)
    label $wn.0 -text "Save the fax \n$fax(receivedfile)\n in the directory" \
          -width 40 -wraplength 3.5i -pady 5
    entry $wn.1 -textvariable fax(sppf) \
          -width 40 -font $fax(f1) -fg $fax(c1)
    button $wn.2 -text OK     -width 10 -command {
        if [file isdirectory $fax(sppf)] {
            foreach i $fax(receivedfile) {
                fax_exec "cp $fax(incomingdir)/$i $fax(sppf)"
            }
            fax_received_message "Saved: $fax(receivedfile)"
        } else {
            fax_received_message "Error: $fax(sppf) is not a directory."
        }
        destroy $fax(spwn)
    }
    button $wn.3 -text Cancel -width 10 -command {
        destroy $fax(spwn)
    }
    grid $wn.0 -row 0 -column 0 -rowspan 1 -columnspan 2 -sticky news
    grid $wn.1 -row 1 -column 0 -rowspan 1 -columnspan 2 -sticky news
    grid $wn.2 -row 2 -column 0 -rowspan 1 -columnspan 1 -sticky news -pady 4
    grid $wn.3 -row 2 -column 1 -rowspan 1 -columnspan 1 -sticky news -pady 4
}

proc fax_received_delete {} {
    global fax
    if {$fax(receivedfile) == {}} {return}
    set files ""
    foreach file $fax(receivedfile) {
        set files "$files $fax(incomingdir)/$file"
    }
    set k [tk_dialog .dialog "TkFax Fax Delete" \
        "Delete the fax\n$fax(receivedfile)?" {} 0 {Confirm} {Cancel}]
    if {$k==1} { return }
    set command "rm -f $files"
    fax_exec $command
    fax_received_update
    fax_received_message "Deleted: $fax(receivedfile)"
}

proc fax_received_attach {} {
    global fax
    if {$fax(receivedfile) == {}} {return}
    foreach file $fax(receivedfile) {
        fax_exec "cp -f $fax(incomingdir)/$file $fax(tmpdir)"
    }
    fax_addto_pagelist $fax(receivedfile)
    fax_received_message "Attached to page list: $fax(receivedfile)"
}

proc fax_received_message { msg } {
    global fax
    $fax(receivedmessage) configure -text $msg
}

