#
# TkScan Version and Date

set c(progname)	"TkScan"
set c(version)	"0.9"
set c(date)	"October 1998"

#----------------------------------------------------------------
# About TkScan
#----------------------------------------------------------------

set c(about) "
$c(progname) Version $c(version), $c(date)
A tcl/tk GUI for command-line scanner driver
Copyright (C) 1997-1998 Hang-Bae Kim
(hbkim@muon.kaist.ac.kr)
\n"

set c(license) "
This is a free software and comes with no warranty.
See the GNU General Public License for details.
\n"

#----------------------------------------------------------------
# Usage of TkScan
#----------------------------------------------------------------

set c(usage) "
 This describes how to use $c(progname) Version $c(version).

 Contents

	1. Obtaining preview image
	2. Fixing a rectangle to be scanned
	3. Selection of scanning mode and resolution
	4. Output file specification
	5. Automatic output processing
	6. Scanning
	7. User Configuration
	8. Bug or Comment


 Section 1. Obtaining preview image

 * The preview mode and resolution can be chosen in Preference of File menu.
 * Click \[Preview\] button to start preview scanning.
   After scanning, preview image appears on the preview window.
 * Preview scanning can be interrupted by clicking \[Stop\] button.


 Section 2. Fixing a rectangle to be scanned

 * The selection of scanning regions on the preview image is done with the left
   mouse button. Press the left button at one corner of the rectangle you want
   to scan, move the mouse with left button pressed and release the button at
   the opposite corner of the rectangle.
 * You can finetune the rectangle using finetuning buttons (black triangles
   around blue rectangle on Geometry pannel).
 * While the blue rectagle on the preview window continuously shows a region
   to be scanned, Geometry pannel diplays coordinates of upper-left and
   lower-right coners, the width times height in the length unit chosen (Real
   Size) and in screen pixel (Screen Size), and the file size of the image in
   raw format (Data Size).  Screen Size and Data Size also vary as you change
   scanning mode and resolution.
 * The size of A4, Letter or others can be set using \[preset\] button.  You
   can add your own regions in configuration file (See Configuration section).
 * You can also select several regions on the preview image canvas.
   Fix a blue rectangle as described above and then click the middle mouse
   button with the mouse point inside the rectangle (or \[Regist\] button).
   The color of the rectangle becomes red and the number 1 appears at the
   center.  Then make another blue rectangle and press the middle
   button inside it.  Now the second rectangle is registered.  Repeat
   this as many times as you want.  Click of the right mouse button inside
   the red rectangle will remove it.  Double click of the right button (or
   click of the \[Clear\] button) deletes all rectangles.  TkScan will scan
   red rectangles one by one in order of their registration numbers.


 Section 3. Selection of scanning mode, resolution and options

 * This is transparent: Use mode \[Mode\] menubutton and \[Resolution\] scale.
   Screen Size and Data Size change accordingly as mode and resolution change.
 * If you want to adjust other options, press a small green button beside
   \[Mode\] menubutton.  Then the green button becomes red and the option
   manager window appears.  You can do it there.  Available options depend on
   the scanning mode.  Now clicking the button again makes the window disppear.
 * Several frequently used modes are preset in the configuration file and
   directly accessible via Mode munu.  You can define your own quick mode in
   the configuration file (See Configuration section.)


 Section 4. Output file specification

 * You can specify a filename for scanned image in \[Output to\] entry widget.
   If you use # and/or hhmmss in the filename, the last # is replaced with the
   retangle number(0 for blue rectangle, the number at the center for red
   rectangles) and hhmmss replaced with the time at which scanning started.
   The default filename is hhmmss-#.pnm. (You can change it in the configuration
   file.)
 * The file is written in the current directory, where you launched
   tkscan.  If you want to change the current directory, click the green button
   beside \[Output to\] entry widget.  Then the file manager window appears
   with the current directory name and the list of (image) files in the
   directory.  You can move to another directory by specifying the directory
   name in \[Directory\] entry widget or double clicking the directory name
   in the file list.


 Section 5. Automatic output processing

 $c(progname) can launch some application program to do necessary process on
 the image file after finishing scanning.  This is controlled in the file
 manager window which appears if the small green button beside
 \[Output to\] entry widget is pressed.  There are three check buttons
 to turn this feature on: View, Convert, Print.

 * View
   - If turned on, the image editor is automatically launched and show the
     scanned image after finishing scanning.
   - You can select image editor among XV, ImageMagic and GIMP in Preference.
   - There is also \[SW\] checkbutton in the preference window, which select
     that each scanned image appears in separate image editor or all images
     in one image editor when several red rectangles are scanned successively.

 * Convert
   - If turned on, the scanned image is converted to the file in the selected
     format, with the corresponding file surfix in the current directory.
     This is done by convert program from ImageMagic. So you need it.

 * Print
   - If turned on, the scanned image is converted to the postscript file and
     sent to the specified printer.  If you select gv as printer,
     gv(ghostview) will take up the postscript file.
   - You can adjust the size and position of the printed image using
     Zoom, X and Y entry widgets.

 \[Quick\] menu uses this automatic output processing to make the scanner
 be a copy machine (even though very poor, :-|), fax scanner.


 Section 6. Scanning

 This is done by pressing \[SCAN\] button. TkScan will scan the blue rectangle
 region. If you registered red rectangles, then red rectangle regions are
 scanned one by one and the blue rectangle is ignored even when it exists.
 As scanning is in progress, the progress report appears in the status bar.
 If you want to interrupt in the middle of scanning, press \[Stop\] button.
 It kill driver command and recover the state before scanning.
 If it does not work for some reason, double click \[Stop\] button. This
 surely stops scanning and recover TkScan for another scanning.
 Note that while \[Stop\] button kills scanning command immediately,
 it takes some time for scanner to respond.  Remember that scanner is a slowly
 responding peripharal.  I do not recommend frequent use of \[Stop\] button.


 Section 7. User Configuration

 If you select Preference in File menu, Preference Window appears.
 * Specify your scanner device if your scanner driver does not find the
   scanner device correctly without device option. Otherwise, to leave it
   blank is OK.
 * You can change the preview image mode and resolution to those you prefer.
   Press \[Apply\] button after selection.
 * Gamma correction can be done either by the driver itself or by the
   external programs like xv or ImageMagic's display or convert if it is
   not available in the driver. Choose what you prefer.
 * TkScan makes ~/.tkscan directory to keep its configuration files and
   scanned image files temporarily. You can delete those temporary files in
   this directory when exit or right now to free your hard disk.
 * If you select Save current config in File menu, the various configuration
   settings are stored in the ~/.tkscan/.conf file.  You can modify this file
   to fit your taste.  If you feel like doing more changes, look at the
   scan-conf.tcl script, copy necessary parts to ~/.tkscan/.conf file,
   and modify them.


 Section 8. Bug or Comment

 If you find a bug or have any comment on $c(progname) $c(version),
 please send a e-mail to hbkim@muon.kaist.ac.kr (Hang Bae Kim).

"

