#----------------------------------------------------------------
# Configuration
#----------------------------------------------------------------

# Period in miliseconds for checking scanning progress
set s(loopperiod)	1000

# Automatic output treatment
set c(autoview) 0
set c(autoconvert) 0
set c(autoprint) 0
set c(autofax) 0
set c(autofaxif) 0
set c(autodelete) 0

# Preview and Scan mode
set c(prefile)			preview
set s(preresolutionRange)       {15 40 1}
set s(premode)                  Gray
set s(preresolution)            27
set s(Defaultmode)		Color
set s(Defaultresolution)	150

# Quick mode description: unspecified options are set to Default.
set c(mode_quick_set) {
    { GrayCopy  { mode=Gray    resolution=144 } }
    { ColorCopy { mode=Color   resolution=144 } }
    { Fax       { mode=Lineart resolution=200 } } 
    { OCR       { mode=Lineart resolution=300 } }
    { Default   {} }
}

# Paper quick settings, length in inch.
set c(size_quick_set) {
    { Max     { 0.0  0.0    $s(scanwidth) $s(scanheight) } }
    { A4      { 0.0  0.0    8.268  11.6  } }
    { Letter  { 0.0  0.0    8.5    11.0  } }
    { Photo   { 0.0  0.0    5.906  3.937 } }
}

# Length units, their display formats and conversion factors
set s(unitList) {
    { mm    25.5  %0.0f }
    { cm    2.54  %0.1f }
    { inch   1.0  %0.2f }
    { pt    72.0  %0.0f }
}

# Define variables for later use
foreach i $s(optionList) {
    set variable [lindex $i 2]
    set default  [lindex $i 4]
    set s(Default$variable) $default
    set s(pre$variable) $default
}
foreach i $s(modeList) { set modename [lindex $i 0]
    set s([set modename]format) [lindex $i 1]
    set s([set modename]dsizefactor) [lindex $i 2]
    set s([set modename]option) [lindex $i 3]
}
foreach i $s(unitList) { set unitname [lindex $i 0]
    set s(c$unitname) [lindex $i 1]
    set s(f$unitname) [lindex $i 2]
}
foreach i $c(mode_quick_set) {
    set c(qmode[lindex $i 0]) [lindex $i 1]
}
foreach i $c(size_quick_set) {
    set c(qpaper[lindex $i 0]) [lindex $i 1]
}

# Adopted scanning mode options in this program
set s(settingList) "mode resolution"
foreach i $s(optionList) {lappend s(settingList) [lindex $i 2]}
foreach i $s(settingList) {set s($i) $s(Default$i)}

# Fonts
# entry font
set l(f1) -adobe-helvetica-bold-r-*--12-120-*-*-*-*-*-*
# fixed font
set l(f2) -bitstream-courier-bold-r-*--14-140-*-*-*-*-*-*

# Color
# entry color
set l(c1) blue
# primary rectangle
set l(c2) blue
# registed rectangle
set l(c3) red
# currently processed rectangle
set l(c5) blue
# scanning progress bar
set l(c6) blue
# window open and close button
set l(c7) green
set l(c8) red
option add *background          #dfdfdf
option add *foreground          #000000
option add *activeBackground    #ffc0cb
option add *activeForeground    #000000
option add *selectBackground    #ffc0cb
option add *selectForeground    #000000

#----------------------------------------------------------------
# Image Editor Configuration

set c(ImageEditorList) {
    { XV          xv      }
    { ImageMagic  display }
    { GIMP        gimp    }
}
set c(ImageEditor) XV

# ImageEditorWinmode: 0=in one window, 1=separate window
set c(ImageEditorWinmode) 1

foreach i $c(ImageEditorList) { set c([lindex $i 0]command) [lindex $i 1] }

#----------------------------------------------------------------
# Convert Configuration

set file(name) "hhmmss-#.pnm"
set file(dir) [pwd]
set c(pbmtofax) pbm2g3

set file(typeList) {
    { RAW  pnm  }
    { BMP  bmp  }
    { EPS  eps  }
    { GIF  gif  }
    { JPEG jpg  }
    { PCD  pcd  }
    { PCL  pcl  }
    { PCX  pcx  }
    { PDF  pdf  }
    { PNG  png  }
    { PS   ps   }
    { TIFF tiff }
    { XBM  xbm  }
    { XPM  xpm  }
}
set file(type) RAW
set file(imageonly) 1

foreach i $file(typeList) { set file(surfix_[lindex $i 0]) [lindex $i 1] }
set file(surfixList) "\\.pgm$|\\.ppm$"
foreach i $file(typeList) { append file(surfixList) "|\\.[lindex $i 1]$" }

#----------------------------------------------------------------
# Print Configuration

set pr(printerList) {
    { lp  { lpr -Plp1                } }
    { gv  { ghostview -geometry +0+0 } }
}
set pr(paperList) { A4 Letter }
set pr(printer) lp
set pr(paper) A4
set pr(zoom) 100
set pr(xoffset) X
set pr(yoffset) Y

foreach i $pr(printerList) { set pr([lindex $i 0]command) [lindex $i 1] }

#----------------------------------------------------------------
# User Configuration

# The directory where the configuration file and temporary files are kept
set c(tkscandir) $env(HOME)/.tkscan
if [file exists $c(tkscandir)] {
    if [file isdirectory $c(tkscandir)] {
    } else {
        puts "tkscan: ~/.tkscan exists but not a directory"
        exit
    }
} else {
    puts "tkscan: No $c(tkscandir) directory, create it."
    exec mkdir $c(tkscandir)
}
set c(scanout)		""
set c(userconf)		"$c(tkscandir)/.conf"
set c(tmpdirclear)	0

# The following entries are saved in the user configuration file.
set s(saveList) "device preresolutionRange premode preresolution pregamma unit"
foreach i $s(settingList) {append s(saveList) " Default$i"}
set c(saveList) "mode_quick_set size_quick_set tmpdirclear"

