#------------------------------------------------------------------------
# Epson SCSI scanner -- ep_scan
#------------------------------------------------------------------------

# Full scanning size. This should be in inches.
set s(scanwidth)	8.5
set s(scanheight)	11.6

# Minimum, maximum and step of scanning resolution in dpi
set s(resolutionRange)	{1 600 1}

# Time(in miliseconds) for coming back from the opposite end 
# after finishing full height scanning
set s(scantime)		20000

# Command-line driver
set s(command)	"ep_scan"

# Scanner device (leave empty for autodetection)
set s(device)		""

# Options other than for mode and resolution
#     Label         Type  Variable      Values or Range  Default value
set s(optionList) { 
    { {Brightness}     r  brightness    {-3 3 1}  0 }
    { {Sharpness}      r  sharpness     {0 255 1}  0 }
    { {Gamma}          r  gamma         {0.2 5.0 0.1}  1.0 }
}
set s(modedepoptionList) { gamma }

# Supported scanning modes
#     Mode   Format  bpp  Mode-dependent options
set s(modeList) {
    { Lineart   pbm   1  {} }
    { Halftone  pbm   1  {} }
    { Gray      pgm   8  {gamma} }
    { Color     ppm  24  {gamma} }
}

# Gamma correction support
# 0 : support by scanner driver
# 1 : support by external (image editor, image converter) commands
set s(gamma_support)	0

#------------------------------------------------------------------------
# Procedure launching scanner driver
#------------------------------------------------------------------------

proc run_scanner_driver { i file } { global s c
    set command $s(command)
    set file "-o $c(tkscandir)/$file.pnm"
    foreach j {tx ty bx by} { set $j [pixelto pt [expr $s($j$i)-$s(o)]] }
    set wd [expr $bx-$tx]
    set ht [expr $by-$ty]
    set geometry "-x $tx -y $ty -w $wd -h $ht"
    switch $s(mode) {
        Lineart		{ set mode "-i" }
        Halftone	{ set mode "-a" }
        Gray		{ set mode "-m" }
        Color		{ set mode "" }
    }
    set resolution "-r $s(resolution)"
    set option "-s $s(sharpness) -b $s(brightness)"
    foreach i $s($s(mode)option) { switch $i {
      gamma       { if {$s(gamma_support)==0} {append option " -g $s(gamma)}}
    }}
    set cmdline "$command $mode $resolution $option $geometry $file"
    exec sh -c "$cmdline" &
}

