#------------------------------------------------------------------------
# MicroTek SCSI scanner -- mtekscan
#------------------------------------------------------------------------

# Full scanning size. This should be in inches.
set s(scanwidth)	8.5
set s(scanheight)	11.6

# Minimum, maximum and step of scanning resolution in dpi
set s(resolutionRange)	{1 600 1}

# Time(in miliseconds) for coming back from the opposite end 
# after finishing full height scanning
set s(scantime)		20000

# Command-line driver
set s(command)	"mtekscan"

# Scanner device (leave empty for autodetection)
set s(device)		""

# Options other than for mode and resolution
#     Label         Type  Variable      Values or Range  Default value
set s(optionList) { 
    { {Backtrack}      m  backtrack     {yes no}  yes }
    { {Speed}          r  speed         {1 7 1}  1 }
    { {Brightness}     r  brightness    {-100 100 1}  0 }
    { {Exposure Time}  r  exposuretime  {-18 21 3}  0 }
    { {Contrast}       r  contrast      {-42 49 1}  0 }
    { {Halftoning}     r  halftoning    {0 11 1}  0 }
    { {Shadow}         r  shadow        {0 255 1}  0 }
    { {Midtone}        r  midtone       {0 255 1}  128 }
    { {Highlight}      r  highlight     {0 255 1}  255 }
    { {Gamma}          r  gamma         {0.2 5.0 0.1}  1.0 }
}
set s(modedepoptionList) { shadow midtone highlight halftoning gamma }

# Supported scanning modes
#     Mode   Format  bpp  Mode-dependent options
set s(modeList) {
    { Lineart   pbm   1  {} }
    { Halftone  pbm   1  {halftoning} }
    { Gray      pgm   8  {shadow midtone highlight gamma} }
    { Color     ppm  24  {shadow midtone highlight gamma} }
}

# Gamma correction support
# 0 : support by scanner driver
# 1 : support by external (image editor, image converter) commands
set s(gamma_support)	0

#------------------------------------------------------------------------
# Procedure launching scanner driver
#------------------------------------------------------------------------

proc run_scanner_driver { i file } { global s c
    set command $s(command)
    set file "-o $c(tkscandir)/$file.pnm"
    foreach j {tx ty bx by} { set $j [pixelto inch [expr $s($j$i)-$s(o)]] }
    set geometry "-f $tx $ty $bx $by"
    switch $s(mode) {
        Lineart		{ set mode "-b" }
        Halftone	{ set mode "-a" }
        Gray		{ set mode "-g" }
        Color		{ set mode "-c" }
    }
    set resolution "-r $s(resolution)"
    set option "-v $s(speed) -k $s(contrast) -d $s(brightness) \
                -e $s(exposuretime)"
    if {$s(backtracking) == "no"} {append option " -B"}
    foreach i $s($s(mode)option) { switch $i {
      halftoning  {append option " -H $s(halftoning)"}
      shadow      {append option " -s $s(shadow)"}
      midtone     {append option " -m $s(midtone)"}
      highlight   {append option " -l $s(highlight)"}
      gamma       { if {$s(gamma_support)==0} {append option " -G $s(gamma)}}
    }}
    set cmdline "$command $mode $resolution $option $geometry $file"
    exec sh -c "$cmdline" &
}

