#------------------------------------------------------------------------
# Mustek Paragon 600(800) II SP scanner
#------------------------------------------------------------------------

# Full scanning size. This should be in inches.
set s(scanwidth)	8.5
set s(scanheight)	11.6

# Minimum, maximum and step of scanning resolution in dpi
set s(resolutionRange)	{1 800 1}

# Time(in miliseconds) for coming back from the opposite end 
# after finishing full height scanning
set s(scantime)		20000

# Command-line driver
set s(command)	"scanimage"

# Scanner device (leave empty for autodetection)
set s(device)		"mustek:/dev/scanner"

# Options other than for mode and resolution
#     Label         Type  Variable      Values or Range  Default value
set s(optionList) { 
    { {Backtrack}      m  backtrack     {yes no}  yes }
    { {Speed}          m  speed  {Slowest Slower Normal Faster Fastest} Normal }
    { {Grain}          m  grain         {2 3 4 5 6 8}  2 }
    { {Brightness}     r  brightness    {-100 100 1}  0 }
    { {Contrast}       r  contrast      {-100 100 1}  0 }
    { {Halftone Size}  m  halftonesize  {0 2 3 4 5 6 7 8 }  0 }
    { {Gamma}          r  gamma         {0.2 5.0 0.1}  2.0 }
    { {Gamma Red}      r  gamma_red     {0.2 5.0 0.1}  1.0 }
    { {Gamma Blue}     r  gamma_blue    {0.2 5.0 0.1}  1.0 }
    { {Gamma Green}    r  gamma_green   {0.2 5.0 0.1}  1.0 }
}
set s(modedepoptionList) { brightness contrast halftonesize \
                           gamma gamma_red gamma_blue gamma_green }

# Supported scanning modes
#     Mode   Format  bpp  Mode-dependent options
set s(modeList) {
    { Lineart   pbm   1  {brightness contrast}                    }
    { Halftone  pbm   1  {brightness contrast halftonesize}       }
    { Gray      pgm   8  {gamma}                                  }
    { Color     ppm  24  {gamma gamma_red gamma_green gamma_blue} }
}

# Gamma correction support
# 0 : support by scanner driver
# 1 : support by external (image editor, image converter) commands
set s(gamma_support)	0

#------------------------------------------------------------------------
# Procedure launching scanner driver
#------------------------------------------------------------------------

proc run_scanner_driver { i file } { global s c
    set command $s(command)
    set file "> $c(tkscandir)/$file.pnm"
    foreach j {tx ty bx by} { set $j [pixelto mm [expr $s($j$i)-$s(o)]] }
    if {$ty > 292.0} { set ty 292.0 }
    if {$by > 292.0} { set by 292.0 }
    set wd [expr $bx-$tx]
    set ht [expr $by-$ty]
    set geometry "-l $tx -t $ty -x $wd -y $ht"
    switch $s(mode) {
        Lineart		{ set mode "--mode Lineart" }
        Halftone	{ set mode "--mode Halftone" }
        Gray		{ set mode "--mode Gray" }
        Color		{ set mode "--mode Color" }
    }
    set resolution "--resolution $s(resolution)"
    if {$s(device) == {}} {
        set device "--device-name mustek:/dev/scanner"
    } else {
        set device "--device-name $s(device)"
    }
    set option ""
    append option " --speed $s(speed)"
    append option " --source Flatbed"
    append option " --backtrack=$s(backtrack)"
    append option " --grain $s(grain)"
    foreach i $s($s(mode)option) { switch $i {
      brightness   {
          append option " --brightness $s(brightness)"
      }
      contrast     {
          append option " --contrast $s(contrast)"
      }
      halftonesize {
          append option " --halftone-size $s(halftonesize)"
      }
      gamma { if {$s(gamma_support)==0} {
          append option " --custom-gamma"
          append option " --gamma-table [gamma_table $s(gamma)]"
      }}
      gamma_red { if {$s(gamma_support)==0} {
          append option " --red-gamma-table [gamma_table $s(gamma_red)]"
      }}
      gamma_green { if {$s(gamma_support)==0} {
          append option " --green-gamma-table [gamma_table $s(gamma_green)]"
      }}
      gamma_blue { if {$s(gamma_support)==0} {
          append option " --blue-gamma-table [gamma_table $s(gamma_blue)]"
      }}
    }}
    set cmdline "$command $device $mode $resolution $option $geometry $file"
    exec sh -c "$cmdline" &
}

